/*
 * Decompiled with CFR 0.152.
 */
package org.kie.camel.container.integration.tests.remote;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.kie.camel.container.api.ExecutionServerCommand;
import org.kie.camel.container.integration.tests.remote.AbstractRemoteIntegrationTest;
import org.kie.dmn.api.core.DMNContext;
import org.kie.dmn.api.core.DMNResult;

public class DMNClientIntegrationTest
extends AbstractRemoteIntegrationTest {
    @Test
    public void testEvaluateAll() {
        DMNContext dmnContext = this.createDMNContext();
        dmnContext.set("a", (Object)10);
        dmnContext.set("b", (Object)5);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("containerId", "test-container");
        ExecutionServerCommand executionServerCommand = new ExecutionServerCommand();
        executionServerCommand.setClient("dmn");
        executionServerCommand.setOperation("evaluateAll");
        executionServerCommand.setParameters(parameters);
        executionServerCommand.setBody((Object)dmnContext);
        Object results = this.runOnExecutionServer(executionServerCommand);
        Assertions.assertThat((Object)results).isNotNull();
        Assertions.assertThat((Object)results).isInstanceOf(DMNResult.class);
        DMNResult dmnResult = (DMNResult)results;
        Map map = (Map)dmnResult.getContext().get("Math");
        Assertions.assertThat(map.get("Sum")).isEqualTo((Object)BigDecimal.valueOf(15L));
    }

    private DMNContext createDMNContext() {
        ExecutionServerCommand executionServerCommand = new ExecutionServerCommand();
        executionServerCommand.setClient("dmn");
        executionServerCommand.setOperation("newContext");
        Object response = this.runOnExecutionServer(executionServerCommand);
        return (DMNContext)response;
    }
}

