/*
 * Decompiled with CFR 0.152.
 */
package org.kie.camel.container.integration.tests.remote;

import java.util.HashMap;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kie.camel.container.api.ExecutionServerCommand;
import org.kie.camel.container.api.model.cloudbalance.CloudBalance;
import org.kie.camel.container.integration.tests.remote.AbstractRemoteIntegrationTest;
import org.kie.camel.container.integration.tests.remote.CloudBalancingGenerator;
import org.kie.server.api.model.instance.SolverInstance;

public class SolverClientIntegrationTest
extends AbstractRemoteIntegrationTest {
    private static final String CLOUD_BALANCE_SOLVER_ID = "cloudsolver";

    @Test
    public void testGetSolver() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("containerId", "test-container");
        parameters.put("solverId", CLOUD_BALANCE_SOLVER_ID);
        ExecutionServerCommand executionServerCommand = new ExecutionServerCommand();
        executionServerCommand.setClient("solver");
        executionServerCommand.setOperation("getSolver");
        executionServerCommand.setParameters(parameters);
        Object response = this.runOnExecutionServer(executionServerCommand);
        Assertions.assertThat((Object)response).isNotNull();
        Assertions.assertThat((Object)response).isInstanceOf(SolverInstance.class);
        SolverInstance solverInstance = (SolverInstance)response;
        Assertions.assertThat((String)solverInstance.getContainerId()).isEqualTo("test-container");
        Assertions.assertThat((String)solverInstance.getSolverId()).isEqualTo(CLOUD_BALANCE_SOLVER_ID);
    }

    @Test
    public void testSolveCloudBalanceProblem() throws InterruptedException {
        CloudBalancingGenerator cloudBalancingGenerator = new CloudBalancingGenerator();
        CloudBalance cloudBalanceProblem = cloudBalancingGenerator.createCloudBalance(5, 15);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("containerId", "test-container");
        parameters.put("solverId", CLOUD_BALANCE_SOLVER_ID);
        parameters.put("planningProblem", (String)cloudBalanceProblem);
        ExecutionServerCommand executionServerCommand = new ExecutionServerCommand();
        executionServerCommand.setClient("solver");
        executionServerCommand.setOperation("solvePlanningProblem");
        executionServerCommand.setParameters(parameters);
        this.runOnExecutionServer(executionServerCommand);
        SolverInstance.SolverStatus solverStatus = this.getSolverStatus();
        Assertions.assertThat((Comparable)solverStatus).isEqualTo((Object)SolverInstance.SolverStatus.SOLVING);
        Thread.sleep(5000L);
        solverStatus = this.getSolverStatus();
        Assertions.assertThat((Comparable)solverStatus).isEqualTo((Object)SolverInstance.SolverStatus.NOT_SOLVING);
    }

    @Before
    public void createTestSolver() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("containerId", "test-container");
        parameters.put("solverId", CLOUD_BALANCE_SOLVER_ID);
        parameters.put("configFile", "org/test/cloudbalance-solver.xml");
        ExecutionServerCommand executionServerCommand = new ExecutionServerCommand();
        executionServerCommand.setClient("solver");
        executionServerCommand.setOperation("createSolver");
        executionServerCommand.setParameters(parameters);
        Object response = this.runOnExecutionServer(executionServerCommand);
        Assertions.assertThat((Object)response).isNotNull();
        Assertions.assertThat((Object)response).isInstanceOf(SolverInstance.class);
    }

    @After
    public void cleanUpSolvers() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("containerId", "test-container");
        ExecutionServerCommand executionServerCommand = new ExecutionServerCommand();
        executionServerCommand.setClient("solver");
        executionServerCommand.setOperation("getSolvers");
        executionServerCommand.setParameters(parameters);
        Object response = this.runOnExecutionServer(executionServerCommand);
        List solverInstances = (List)response;
        for (SolverInstance solverInstance : solverInstances) {
            this.disposeSolver(solverInstance.getSolverId());
        }
    }

    private SolverInstance.SolverStatus getSolverStatus() {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("containerId", "test-container");
        parameters.put("solverId", CLOUD_BALANCE_SOLVER_ID);
        ExecutionServerCommand executionServerCommand = new ExecutionServerCommand();
        executionServerCommand.setClient("solver");
        executionServerCommand.setOperation("getSolver");
        executionServerCommand.setParameters(parameters);
        Object response = this.runOnExecutionServer(executionServerCommand);
        Assertions.assertThat((Object)response).isNotNull();
        Assertions.assertThat((Object)response).isInstanceOf(SolverInstance.class);
        SolverInstance solverInstance = (SolverInstance)response;
        return solverInstance.getStatus();
    }

    private void disposeSolver(String solverId) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("containerId", "test-container");
        parameters.put("solverId", solverId);
        ExecutionServerCommand executionServerCommand = new ExecutionServerCommand();
        executionServerCommand.setClient("solver");
        executionServerCommand.setOperation("disposeSolver");
        executionServerCommand.setParameters(parameters);
        this.runOnExecutionServer(executionServerCommand);
    }
}

