/*
 * Decompiled with CFR 0.152.
 */
package org.kie.camel.container.integration.tests;

import org.assertj.core.api.Assertions;
import org.drools.core.command.runtime.GetGlobalCommand;
import org.drools.core.command.runtime.SetGlobalCommand;
import org.drools.core.command.runtime.rule.DeleteCommand;
import org.drools.core.command.runtime.rule.FireAllRulesCommand;
import org.drools.core.command.runtime.rule.GetObjectCommand;
import org.drools.core.command.runtime.rule.InsertObjectCommand;
import org.junit.Test;
import org.kie.api.command.Command;
import org.kie.api.runtime.ExecutionResults;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.camel.container.api.model.Person;
import org.kie.camel.container.integration.tests.AbstractKieCamelIntegrationTest;

public class RuleEngineIntegrationTest
extends AbstractKieCamelIntegrationTest {
    private static final String GLOBAL_NAME = "testGlobal";
    private static final String GLOBAL_VALUE = "global-value";

    @Test
    public void testRuleEvaluationService() {
        Person person = new Person();
        person.setName("George");
        person.setAge(15);
        Person response = this.kieCamelTestService.verifyAge(person);
        Assertions.assertThat((Object)response).isNotNull();
        Assertions.assertThat((boolean)response.isCanDrink()).isFalse();
        person = new Person();
        person.setName("John");
        person.setAge(25);
        response = this.kieCamelTestService.verifyAge(person);
        Assertions.assertThat((Object)response).isNotNull();
        Assertions.assertThat((boolean)response.isCanDrink()).isTrue();
    }

    @Test
    public void testSetGetGlobal() {
        SetGlobalCommand setGlobalCommand = new SetGlobalCommand(GLOBAL_NAME, (Object)GLOBAL_VALUE);
        this.runCommand((Command)setGlobalCommand);
        GetGlobalCommand getGlobalCommand = new GetGlobalCommand(GLOBAL_NAME);
        getGlobalCommand.setOutIdentifier(GLOBAL_NAME);
        ExecutionResults executionResults = this.runCommand((Command)getGlobalCommand);
        Assertions.assertThat((Object)executionResults).isNotNull();
        Assertions.assertThat((Object)executionResults.getValue(GLOBAL_NAME)).isEqualTo((Object)GLOBAL_VALUE);
    }

    @Test
    public void testInsertGetDeleteFact() {
        Person person = new Person("John", 15);
        FactHandle factHandle = this.insertObject(person);
        Person returnedPerson = (Person)this.getObject(factHandle);
        Assertions.assertThat((Object)returnedPerson).isEqualToComparingFieldByField((Object)person);
        DeleteCommand deleteCommand = new DeleteCommand(factHandle);
        this.runCommand((Command)deleteCommand);
        Assertions.assertThat((Object)this.getObject(factHandle)).isNull();
    }

    @Test
    public void testFireAllRules() {
        Person oldPerson = new Person("Tom", 30);
        Person youngPerson = new Person("John", 15);
        FactHandle oldPersonFactHandle = this.insertObject(oldPerson);
        FactHandle youngPersonFactHandle = this.insertObject(youngPerson);
        FireAllRulesCommand fireAllRulesCommand = new FireAllRulesCommand();
        fireAllRulesCommand.setOutIdentifier("out-identifier");
        ExecutionResults executionResults = this.runCommand((Command)fireAllRulesCommand);
        Assertions.assertThat((Object)executionResults).isNotNull();
        Assertions.assertThat((Object)executionResults.getValue("out-identifier")).isEqualTo((Object)2);
        Person oldPerson2 = (Person)this.getObject(oldPersonFactHandle);
        Assertions.assertThat((boolean)oldPerson2.isCanDrink()).isTrue();
        Person youngPerson2 = (Person)this.getObject(youngPersonFactHandle);
        Assertions.assertThat((boolean)youngPerson2.isCanDrink()).isFalse();
    }

    private FactHandle insertObject(Object object) {
        InsertObjectCommand insertObjectCommand = new InsertObjectCommand(object);
        insertObjectCommand.setOutIdentifier("out-identifier");
        ExecutionResults executionResults = this.runCommand((Command)insertObjectCommand);
        Assertions.assertThat((Object)executionResults).isNotNull();
        Assertions.assertThat((Object)executionResults.getFactHandle("out-identifier")).isNotNull();
        FactHandle factHandle = (FactHandle)executionResults.getFactHandle("out-identifier");
        return factHandle;
    }

    private Object getObject(FactHandle factHandle) {
        GetObjectCommand getObjectCommand = new GetObjectCommand(factHandle);
        getObjectCommand.setOutIdentifier("out-identifier");
        ExecutionResults executionResults = this.runCommand((Command)getObjectCommand);
        Assertions.assertThat((Object)executionResults).isNotNull();
        Object object = executionResults.getValue("out-identifier");
        return object;
    }
}

