/*
 * Decompiled with CFR 0.152.
 */
package org.kie.camel.container.integration.tests.remote;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.kie.camel.container.api.model.cloudbalance.CloudBalance;
import org.kie.camel.container.api.model.cloudbalance.CloudComputer;
import org.kie.camel.container.api.model.cloudbalance.CloudProcess;

public class CloudBalancingGenerator {
    private static final Price[] CPU_POWER_PRICES = new Price[]{new Price(3, "single core 3ghz", 110), new Price(4, "dual core 2ghz", 140), new Price(6, "dual core 3ghz", 180), new Price(8, "quad core 2ghz", 270), new Price(12, "quad core 3ghz", 400), new Price(16, "quad core 4ghz", 1000), new Price(24, "eight core 3ghz", 3000)};
    private static final Price[] MEMORY_PRICES = new Price[]{new Price(2, "2 gigabyte", 140), new Price(4, "4 gigabyte", 180), new Price(8, "8 gigabyte", 220), new Price(16, "16 gigabyte", 300), new Price(32, "32 gigabyte", 400), new Price(64, "64 gigabyte", 600), new Price(96, "96 gigabyte", 1000)};
    private static final Price[] NETWORK_BANDWIDTH_PRICES = new Price[]{new Price(2, "2 gigabyte", 100), new Price(4, "4 gigabyte", 200), new Price(6, "6 gigabyte", 300), new Price(8, "8 gigabyte", 400), new Price(12, "12 gigabyte", 600), new Price(16, "16 gigabyte", 800), new Price(20, "20 gigabyte", 1000)};
    private static final int MAXIMUM_REQUIRED_CPU_POWER = 12;
    private static final int MAXIMUM_REQUIRED_MEMORY = 32;
    private static final int MAXIMUM_REQUIRED_NETWORK_BANDWIDTH = 12;
    protected Random random;

    public CloudBalancingGenerator() {
        this.checkConfiguration();
    }

    private void checkConfiguration() {
        if (CPU_POWER_PRICES.length != MEMORY_PRICES.length || CPU_POWER_PRICES.length != NETWORK_BANDWIDTH_PRICES.length) {
            throw new IllegalStateException("All price arrays must be equal in length.");
        }
    }

    public CloudBalance createCloudBalance(int computerListSize, int processListSize) {
        return this.createCloudBalance(this.determineFileName(computerListSize, processListSize), computerListSize, processListSize);
    }

    private String determineFileName(int computerListSize, int processListSize) {
        return computerListSize + "computers-" + processListSize + "processes";
    }

    public CloudBalance createCloudBalance(String inputId, int computerListSize, int processListSize) {
        this.random = new Random(47L);
        CloudBalance cloudBalance = new CloudBalance();
        cloudBalance.setId(Long.valueOf(0L));
        this.createComputerList(cloudBalance, computerListSize);
        this.createProcessList(cloudBalance, processListSize);
        this.assureComputerCapacityTotalAtLeastProcessRequiredTotal(cloudBalance);
        BigInteger possibleSolutionSize = BigInteger.valueOf(cloudBalance.getComputerList().size()).pow(cloudBalance.getProcessList().size());
        return cloudBalance;
    }

    public CloudComputer createCloudComputer(int currentNumberOfComputers) {
        this.random = new Random(47L);
        return this.generateCloudComputer(currentNumberOfComputers);
    }

    private void createComputerList(CloudBalance cloudBalance, int computerListSize) {
        ArrayList<CloudComputer> computerList = new ArrayList<CloudComputer>(computerListSize);
        for (int i = 0; i < computerListSize; ++i) {
            CloudComputer computer = this.generateCloudComputer(i);
            computerList.add(computer);
        }
        cloudBalance.setComputerList(computerList);
    }

    private CloudComputer generateCloudComputer(long id) {
        CloudComputer computer = new CloudComputer();
        computer.setId(Long.valueOf(id));
        int cpuPowerPricesIndex = this.random.nextInt(CPU_POWER_PRICES.length);
        computer.setCpuPower(CPU_POWER_PRICES[cpuPowerPricesIndex].getHardwareValue());
        int memoryPricesIndex = this.distortIndex(cpuPowerPricesIndex, MEMORY_PRICES.length);
        computer.setMemory(MEMORY_PRICES[memoryPricesIndex].getHardwareValue());
        int networkBandwidthPricesIndex = this.distortIndex(cpuPowerPricesIndex, NETWORK_BANDWIDTH_PRICES.length);
        computer.setNetworkBandwidth(NETWORK_BANDWIDTH_PRICES[networkBandwidthPricesIndex].getHardwareValue());
        int cost = CPU_POWER_PRICES[cpuPowerPricesIndex].getCost() + MEMORY_PRICES[memoryPricesIndex].getCost() + NETWORK_BANDWIDTH_PRICES[networkBandwidthPricesIndex].getCost();
        computer.setCost(cost);
        return computer;
    }

    private int distortIndex(int referenceIndex, int length) {
        int index = referenceIndex;
        double randomDouble = this.random.nextDouble();
        for (double loweringThreshold = 0.25; randomDouble < loweringThreshold && index >= 1; --index, loweringThreshold *= 0.1) {
        }
        double heighteningThreshold = 0.75;
        while (randomDouble >= heighteningThreshold && index <= length - 2) {
            ++index;
            heighteningThreshold = 1.0 - (1.0 - heighteningThreshold) * 0.1;
        }
        return index;
    }

    private void createProcessList(CloudBalance cloudBalance, int processListSize) {
        ArrayList<CloudProcess> processList = new ArrayList<CloudProcess>(processListSize);
        for (int i = 0; i < processListSize; ++i) {
            CloudProcess process = new CloudProcess();
            process.setId(Long.valueOf(i));
            int requiredCpuPower = this.generateRandom(12);
            process.setRequiredCpuPower(requiredCpuPower);
            int requiredMemory = this.generateRandom(32);
            process.setRequiredMemory(requiredMemory);
            int requiredNetworkBandwidth = this.generateRandom(12);
            process.setRequiredNetworkBandwidth(requiredNetworkBandwidth);
            processList.add(process);
        }
        cloudBalance.setProcessList(processList);
    }

    private int generateRandom(int maximumValue) {
        double parabolaBase = 2000.0;
        double randomDouble = this.random.nextDouble();
        double parabolaRandomDouble = (Math.pow(parabolaBase, randomDouble) - 1.0) / (parabolaBase - 1.0);
        if (parabolaRandomDouble < 0.0 || parabolaRandomDouble >= 1.0) {
            throw new IllegalArgumentException("Invalid generated parabolaRandomDouble (" + parabolaRandomDouble + ")");
        }
        int value = (int)Math.floor(parabolaRandomDouble * (double)maximumValue) + 1;
        if (value < 1 || value > maximumValue) {
            throw new IllegalArgumentException("Invalid generated value (" + value + ")");
        }
        return value;
    }

    private void assureComputerCapacityTotalAtLeastProcessRequiredTotal(CloudBalance cloudBalance) {
        int upgrade;
        int upgrade2;
        int upgrade3;
        List computerList = cloudBalance.getComputerList();
        int cpuPowerTotal = 0;
        int memoryTotal = 0;
        int networkBandwidthTotal = 0;
        for (CloudComputer computer : computerList) {
            cpuPowerTotal += computer.getCpuPower();
            memoryTotal += computer.getMemory();
            networkBandwidthTotal += computer.getNetworkBandwidth();
        }
        int requiredCpuPowerTotal = 0;
        int requiredMemoryTotal = 0;
        int requiredNetworkBandwidthTotal = 0;
        for (CloudProcess process : cloudBalance.getProcessList()) {
            requiredCpuPowerTotal += process.getRequiredCpuPower();
            requiredMemoryTotal += process.getRequiredMemory();
            requiredNetworkBandwidthTotal += process.getRequiredNetworkBandwidth();
        }
        for (int cpuPowerLacking = requiredCpuPowerTotal - cpuPowerTotal; cpuPowerLacking > 0; cpuPowerLacking -= upgrade3) {
            CloudComputer computer = (CloudComputer)computerList.get(this.random.nextInt(computerList.size()));
            upgrade3 = this.determineUpgrade(cpuPowerLacking);
            computer.setCpuPower(computer.getCpuPower() + upgrade3);
        }
        for (int memoryLacking = requiredMemoryTotal - memoryTotal; memoryLacking > 0; memoryLacking -= upgrade2) {
            CloudComputer computer = (CloudComputer)computerList.get(this.random.nextInt(computerList.size()));
            upgrade2 = this.determineUpgrade(memoryLacking);
            computer.setMemory(computer.getMemory() + upgrade2);
        }
        for (int networkBandwidthLacking = requiredNetworkBandwidthTotal - networkBandwidthTotal; networkBandwidthLacking > 0; networkBandwidthLacking -= upgrade) {
            CloudComputer computer = (CloudComputer)computerList.get(this.random.nextInt(computerList.size()));
            upgrade = this.determineUpgrade(networkBandwidthLacking);
            computer.setNetworkBandwidth(computer.getNetworkBandwidth() + upgrade);
        }
    }

    private int determineUpgrade(int lacking) {
        for (int upgrade : new int[]{8, 4, 2, 1}) {
            if (lacking < upgrade) continue;
            return upgrade;
        }
        throw new IllegalStateException("Lacking (" + lacking + ") should be at least 1.");
    }

    private static class Price {
        private int hardwareValue;
        private String description;
        private int cost;

        private Price(int hardwareValue, String description, int cost) {
            this.hardwareValue = hardwareValue;
            this.description = description;
            this.cost = cost;
        }

        public int getHardwareValue() {
            return this.hardwareValue;
        }

        public String getDescription() {
            return this.description;
        }

        public int getCost() {
            return this.cost;
        }
    }
}

