/*
 * Decompiled with CFR 0.152.
 */
package org.kie.camel.container.integration.tests;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.security.TypePermission;
import com.thoughtworks.xstream.security.WildcardTypePermission;
import java.util.List;
import org.apache.cxf.jaxrs.client.JAXRSClientFactory;
import org.drools.core.command.runtime.process.GetProcessInstancesCommand;
import org.drools.core.runtime.help.impl.BatchExecutionHelperProviderImpl;
import org.junit.Before;
import org.kie.api.KieServices;
import org.kie.api.command.Command;
import org.kie.api.command.KieCommands;
import org.kie.api.runtime.ExecutionResults;
import org.kie.camel.container.api.service.KieCamelTestService;

public class AbstractKieCamelIntegrationTest {
    private static final String CAMEL_TEST_SERVICE_URL = "http://localhost:8080/rest";
    protected static final String DEFAULT_OUT_ID = "out-identifier";
    protected KieCamelTestService kieCamelTestService;
    protected KieCommands kieCommands;
    protected XStream xstreamMarshaller;

    @Before
    public void init() {
        this.kieCamelTestService = (KieCamelTestService)JAXRSClientFactory.create((String)CAMEL_TEST_SERVICE_URL, KieCamelTestService.class);
        this.kieCommands = KieServices.Factory.get().getCommands();
        BatchExecutionHelperProviderImpl batchExecutionHelperProvider = new BatchExecutionHelperProviderImpl();
        this.xstreamMarshaller = batchExecutionHelperProvider.newXStreamMarshaller();
        String[] allowList = new String[]{"org.kie.camel.container.api.model.Person"};
        this.xstreamMarshaller.addPermission((TypePermission)new WildcardTypePermission(allowList));
    }

    protected ExecutionResults runCommand(Command command) {
        String commandXML = this.xstreamMarshaller.toXML((Object)command);
        String resultsXML = this.kieCamelTestService.runCommand(commandXML);
        ExecutionResults executionResults = (ExecutionResults)this.xstreamMarshaller.fromXML(resultsXML);
        return executionResults;
    }

    protected List<Long> listProcesses() {
        List results;
        GetProcessInstancesCommand getProcessInstancesCommand = new GetProcessInstancesCommand();
        getProcessInstancesCommand.setOutIdentifier(DEFAULT_OUT_ID);
        String commandXML = this.xstreamMarshaller.toXML((Object)getProcessInstancesCommand);
        String resultsXML = this.kieCamelTestService.runCommand(commandXML);
        List processIds = results = (List)this.xstreamMarshaller.fromXML(resultsXML);
        return processIds;
    }
}

