/*
 * Decompiled with CFR 0.152.
 */
package org.kie.camel.container.integration.tests.remote;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.appformer.maven.support.AFReleaseId;
import org.assertj.core.api.Assertions;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.drools.core.util.FileManager;
import org.drools.modelcompiler.ExecutableModelProject;
import org.junit.After;
import org.junit.Before;
import org.junit.BeforeClass;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.model.KieModuleModel;
import org.kie.camel.container.api.ExecutionServerCommand;
import org.kie.camel.container.integration.tests.AbstractKieCamelIntegrationTest;
import org.kie.scanner.KieMavenRepository;
import org.kie.server.api.marshalling.xstream.XStreamMarshaller;
import org.kie.server.api.model.KieContainerResource;
import org.kie.server.api.model.ReleaseId;
import org.kie.server.api.model.instance.ProcessInstance;
import org.kie.server.api.model.instance.VariableInstance;

public class AbstractRemoteIntegrationTest
extends AbstractKieCamelIntegrationTest {
    protected static final String KJAR_RESOURCES_PATH = "/org/kie/camel/container/integration/tests/kjar/";
    protected static final String KJAR_TEST_PACKAGE_PATH = "/src/main/resources/org/test/";
    protected static final String PATH_POM = "/org/kie/camel/container/integration/tests/kjar/pom.xml";
    protected static final String PROCESS_FILE_NAME = "process1.bpmn2";
    protected static final String PROCESS_WITH_SIGNAL_FILE_NAME = "processWithSignal.bpmn2";
    protected static final String PROCESS_WITH_HUMAN_TASK_FILE_NAME = "processWithHumanTask.bpmn2";
    protected static final String RULES_FILE_NAME = "rules.drl";
    protected static final String CLOUD_BALANCE_SOLVER_CONFIG = "cloudbalance-solver.xml";
    protected static final String CLOUD_BALANCE_SCORE_RULES = "cloudBalancingScoreRules.drl";
    protected static final String DMN_FUNCTION_DEFINITION = "FunctionDefinition.dmn";
    protected static final ReleaseId RELEASE_ID = new ReleaseId("org.drools", "camel-container-tests-kjar", "1.0.0");
    protected static final String CONTAINER_ID = "test-container";
    protected static final String PROCESS_ID = "process1";
    protected static final String PROCESS_WITH_SIGNAL_ID = "processWithSignal";
    protected static final String PROCESS_WITH_HUMAN_TASK = "processWithHumanTask";
    protected static final String SIGNAL_NAME = "signal1";
    protected static final String PROCESS_VARIABLE_NAME = "var1";
    protected static final String INITIATOR = "yoda";
    protected static final String SIMPLE_QUERY_NAME = "process-instances-query";
    protected static final String SIMPLE_QUERY_EXPRESSION = "select * from ProcessInstanceLog";
    protected static final String SIMPLE_QUERY_TARGET = "PROCESS";
    protected static final String SIMPLE_QUERY_DATASOURCE = "java:jboss/datasources/ExampleDS";
    protected static final String DEFAULT_USER = "yoda";

    @BeforeClass
    public static void createKieJar() throws IOException {
        KieServices ks = KieServices.get();
        KieFileSystem kfs = AbstractRemoteIntegrationTest.createKieFileSystemWithKProject(ks);
        kfs.writePomXML(AbstractRemoteIntegrationTest.loadResource(PATH_POM));
        kfs = AbstractRemoteIntegrationTest.addClasspathResourceToKjar("/org/kie/camel/container/integration/tests/kjar/process1.bpmn2", "/src/main/resources/org/test/process1.bpmn2", kfs);
        kfs = AbstractRemoteIntegrationTest.addClasspathResourceToKjar("/org/kie/camel/container/integration/tests/kjar/processWithSignal.bpmn2", "/src/main/resources/org/test/processWithSignal.bpmn2", kfs);
        kfs = AbstractRemoteIntegrationTest.addClasspathResourceToKjar("/org/kie/camel/container/integration/tests/kjar/rules.drl", "/src/main/resources/org/test/rules.drl", kfs);
        kfs = AbstractRemoteIntegrationTest.addClasspathResourceToKjar("/org/kie/camel/container/integration/tests/kjar/processWithHumanTask.bpmn2", "/src/main/resources/org/test/processWithHumanTask.bpmn2", kfs);
        kfs = AbstractRemoteIntegrationTest.addClasspathResourceToKjar("/org/kie/camel/container/integration/tests/kjar/cloudbalance-solver.xml", "/src/main/resources/org/test/cloudbalance-solver.xml", kfs);
        kfs = AbstractRemoteIntegrationTest.addClasspathResourceToKjar("/org/kie/camel/container/integration/tests/kjar/cloudBalancingScoreRules.drl", "/src/main/resources/org/test/cloudBalancingScoreRules.drl", kfs);
        kfs = AbstractRemoteIntegrationTest.addClasspathResourceToKjar("/org/kie/camel/container/integration/tests/kjar/FunctionDefinition.dmn", "/src/main/resources/org/test/FunctionDefinition.dmn", kfs);
        KieBuilder kieBuilder = ks.newKieBuilder(kfs);
        List messageList = kieBuilder.buildAll(ExecutableModelProject.class).getResults().getMessages();
        Assertions.assertThat((List)messageList).isEmpty();
        InternalKieModule kJar1 = (InternalKieModule)kieBuilder.getKieModule();
        KieMavenRepository repository = KieMavenRepository.getKieMavenRepository();
        repository.installArtifact((AFReleaseId)RELEASE_ID, kJar1, AbstractRemoteIntegrationTest.createKPom());
    }

    @Before
    public void deploy() throws IOException {
        KieContainerResource kieContainerResource = new KieContainerResource(RELEASE_ID);
        kieContainerResource.setContainerId(CONTAINER_ID);
        ExecutionServerCommand executionServerCommand = new ExecutionServerCommand();
        executionServerCommand.setClient("kieServices");
        executionServerCommand.setOperation("createContainer");
        executionServerCommand.addParameter("id", CONTAINER_ID);
        executionServerCommand.setBodyParam("resource");
        executionServerCommand.setBody((Object)kieContainerResource);
        this.runOnExecutionServer(executionServerCommand);
    }

    @After
    public void teardown() {
        ExecutionServerCommand executionServerCommand = new ExecutionServerCommand();
        executionServerCommand.setClient("kieServices");
        executionServerCommand.setOperation("disposeContainer");
        executionServerCommand.addParameter("id", CONTAINER_ID);
        this.runOnExecutionServer(executionServerCommand);
    }

    protected Object runOnExecutionServer(ExecutionServerCommand executionServerCommand) {
        XStreamMarshaller marshaller = new XStreamMarshaller(new HashSet(), AbstractRemoteIntegrationTest.class.getClassLoader());
        String commandXML = marshaller.marshall((Object)executionServerCommand);
        String resultString = this.kieCamelTestService.runOnExecServer(commandXML);
        Object result = marshaller.unmarshall(resultString, Object.class);
        return result;
    }

    protected Long startProcess(String containerId, String processId) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("containerId", containerId);
        parameters.put("processId", processId);
        ExecutionServerCommand executionServerCommand = new ExecutionServerCommand();
        executionServerCommand.setClient("process");
        executionServerCommand.setOperation("startProcess");
        executionServerCommand.setParameters(parameters);
        Object response = this.runOnExecutionServer(executionServerCommand);
        Assertions.assertThat((Object)response).isNotNull();
        Assertions.assertThat((Object)response).isInstanceOf(Long.class);
        Long processInstanceId = (Long)response;
        Assertions.assertThat((Long)processInstanceId).isGreaterThan(0L);
        return processInstanceId;
    }

    protected Long startProcess(String containerId, String processId, Map<String, Object> processVariables) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("containerId", containerId);
        parameters.put("processId", processId);
        parameters.put("variables", processVariables);
        ExecutionServerCommand executionServerCommand = new ExecutionServerCommand();
        executionServerCommand.setClient("process");
        executionServerCommand.setOperation("startProcess");
        executionServerCommand.setParameters(parameters);
        Object response = this.runOnExecutionServer(executionServerCommand);
        Assertions.assertThat((Object)response).isNotNull();
        Assertions.assertThat((Object)response).isInstanceOf(Long.class);
        Long processInstanceId = (Long)response;
        Assertions.assertThat((Long)processInstanceId).isGreaterThan(0L);
        return processInstanceId;
    }

    protected HashMap<String, String> getProcessVariables(String containerId, long processInstanceId) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("containerId", containerId);
        parameters.put("processInstanceId", processInstanceId);
        ExecutionServerCommand executionServerCommand = new ExecutionServerCommand();
        executionServerCommand.setClient("process");
        executionServerCommand.setOperation("findVariablesCurrentState");
        executionServerCommand.setParameters(parameters);
        Object response = this.runOnExecutionServer(executionServerCommand);
        Assertions.assertThat((Object)response).isNotNull();
        Assertions.assertThat((Object)response).isInstanceOf(List.class);
        List variableInstances = (List)response;
        HashMap<String, String> variablesMap = new HashMap<String, String>();
        for (VariableInstance variable : variableInstances) {
            variablesMap.put(variable.getVariableName(), variable.getValue());
        }
        return variablesMap;
    }

    protected List<ProcessInstance> findActiveProcesses() {
        List<Integer> statuses = Arrays.asList(1);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("status", statuses);
        parameters.put("page", "0");
        parameters.put("pageSize", "100");
        ExecutionServerCommand executionServerCommand = new ExecutionServerCommand();
        executionServerCommand.setClient("query");
        executionServerCommand.setOperation("findProcessInstancesByStatus");
        executionServerCommand.setParameters(parameters);
        Object response = this.runOnExecutionServer(executionServerCommand);
        List processInstances = (List)response;
        return processInstances;
    }

    protected void abortProcess(String containerId, String processInstanceId) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("containerId", containerId);
        parameters.put("processInstanceId", processInstanceId);
        ExecutionServerCommand executionServerCommand = new ExecutionServerCommand();
        executionServerCommand.setClient("process");
        executionServerCommand.setOperation("abortProcessInstance");
        executionServerCommand.setParameters(parameters);
        this.runOnExecutionServer(executionServerCommand);
    }

    protected void sendSignalToProcessInstance(String containerId, Long processInstanceId, String signalName) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("containerId", containerId);
        parameters.put("processInstanceId", processInstanceId);
        parameters.put("signalName", signalName);
        parameters.put("event", null);
        ExecutionServerCommand executionServerCommand = new ExecutionServerCommand();
        executionServerCommand.setClient("process");
        executionServerCommand.setOperation("signalProcessInstance");
        executionServerCommand.setParameters(parameters);
        this.runOnExecutionServer(executionServerCommand);
    }

    @After
    public void abortAllProcesses() {
        List<ProcessInstance> activeProcesses = this.findActiveProcesses();
        for (ProcessInstance processInstance : activeProcesses) {
            this.abortProcess(CONTAINER_ID, String.valueOf(processInstance.getId()));
        }
    }

    private static KieFileSystem createKieFileSystemWithKProject(KieServices ks) {
        KieModuleModel kproj = ks.newKieModuleModel();
        KieFileSystem kfs = ks.newKieFileSystem();
        kfs.writeKModuleXML(kproj.toXML());
        return kfs;
    }

    private static File createKPom() throws IOException {
        FileManager fileManager = new FileManager();
        fileManager.setUp();
        File pomFile = fileManager.newFile("pom.xml");
        fileManager.write(pomFile, AbstractRemoteIntegrationTest.loadResource(PATH_POM));
        return pomFile;
    }

    private static KieFileSystem addClasspathResourceToKjar(String classpathPath, String kjarPath, KieFileSystem kieFileSystem) {
        String resourceContent = AbstractRemoteIntegrationTest.loadResource(classpathPath);
        return kieFileSystem.write(kjarPath, resourceContent);
    }

    private static String loadResource(String path) {
        String string;
        block8: {
            InputStream inputStream = AbstractRemoteIntegrationTest.class.getResourceAsStream(path);
            try {
                string = IOUtils.toString((InputStream)inputStream);
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("Error loading resource from classpath", e);
                }
            }
            inputStream.close();
        }
        return string;
    }
}

