/*
 * Decompiled with CFR 0.152.
 */
package org.drools.example.cdi.scopes;

import java.io.Serializable;
import java.util.UUID;
import javax.enterprise.context.Conversation;
import javax.enterprise.context.ConversationScoped;
import javax.enterprise.inject.spi.PassivationCapable;
import javax.inject.Inject;
import org.drools.example.cdi.scopes.MyBean;
import org.kie.api.cdi.KSession;
import org.kie.api.runtime.KieSession;

@ConversationScoped
public class MyConversationScopedBean
implements PassivationCapable,
Serializable {
    @Inject
    private Conversation conversation;
    @Inject
    @KSession
    private KieSession kSession;
    @Inject
    private MyBean myBean;

    public MyConversationScopedBean() {
        System.out.println(">>> new MyConversationScopedBean: " + this.hashCode());
    }

    public String getId() {
        return "MyConversationScopedBean-" + UUID.randomUUID().toString();
    }

    public int doSomething(String string) {
        System.out.println(" >> Doing Something: " + string);
        this.kSession.insert((Object)string);
        String doSomething = this.myBean.doSomething(string);
        return this.kSession.fireAllRules();
    }

    public KieSession getkSession() {
        return this.kSession;
    }

    public MyBean getMyBean() {
        return this.myBean;
    }

    public void begin() {
        this.conversation.begin();
    }

    public void begin(String id) {
        this.conversation.begin(id);
    }

    public void end() {
        this.conversation.end();
    }
}

