/*
 * Decompiled with CFR 0.152.
 */
package org.drools.example.cdi.scopes;

import java.lang.annotation.Annotation;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import org.apache.deltaspike.cdise.api.ContextControl;
import org.apache.deltaspike.core.api.provider.BeanProvider;
import org.drools.example.cdi.scopes.MyApplicationScopedBean;
import org.drools.example.cdi.scopes.MyBean;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class ApplicationScopedRulesJUnitTest {
    @Inject
    private MyApplicationScopedBean myApplicationBean;
    private ContextControl ctxCtrl = (ContextControl)BeanProvider.getContextualReference(ContextControl.class, (Annotation[])new Annotation[0]);

    @Deployment
    public static JavaArchive createDeployment() {
        JavaArchive jar = (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class)).addClasses(new Class[]{MyBean.class, MyApplicationScopedBean.class})).addPackages(true, new String[]{"org.apache.deltaspike"})).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
        return jar;
    }

    @After
    public void stopContexts() {
        this.ctxCtrl.stopContexts();
    }

    @Test
    public void helloApplicationScoped() {
        Assert.assertNotNull((Object)this.myApplicationBean);
        this.ctxCtrl.startContext(ApplicationScoped.class);
        this.ctxCtrl.startContext(RequestScoped.class);
        String myBeanId = this.myApplicationBean.getMyBean().getId();
        long myKieSessionId = this.myApplicationBean.getkSession().getIdentifier();
        int result = this.myApplicationBean.doSomething("hello 0");
        Assert.assertEquals((long)1L, (long)result);
        this.ctxCtrl.stopContext(RequestScoped.class);
        this.ctxCtrl.startContext(RequestScoped.class);
        Assert.assertEquals((Object)myBeanId, (Object)this.myApplicationBean.getMyBean().getId());
        Assert.assertEquals((long)myKieSessionId, (long)this.myApplicationBean.getkSession().getIdentifier());
        myBeanId = this.myApplicationBean.getMyBean().getId();
        myKieSessionId = this.myApplicationBean.getkSession().getIdentifier();
        result = this.myApplicationBean.doSomething("hello 1");
        Assert.assertEquals((long)1L, (long)result);
        this.ctxCtrl.stopContext(RequestScoped.class);
        this.ctxCtrl.startContext(RequestScoped.class);
        Assert.assertEquals((Object)myBeanId, (Object)this.myApplicationBean.getMyBean().getId());
        Assert.assertEquals((long)myKieSessionId, (long)this.myApplicationBean.getkSession().getIdentifier());
        result = this.myApplicationBean.doSomething("hello 2");
        Assert.assertEquals((long)1L, (long)result);
    }
}

