/*
 * Copyright 2005 JBoss Inc
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.drools.javaparser.ast.visitor;

import org.drools.javaparser.ast.drlx.OOPathChunk;
import org.drools.javaparser.ast.drlx.OOPathExpr;
import org.drools.javaparser.ast.drlx.RuleBody;
import org.drools.javaparser.ast.drlx.RuleConsequence;
import org.drools.javaparser.ast.drlx.RuleDeclaration;
import org.drools.javaparser.ast.drlx.RulePattern;
import org.drools.javaparser.ast.drlx.expr.DrlxExpression;
import org.drools.javaparser.ast.drlx.expr.HalfBinaryExpr;
import org.drools.javaparser.ast.drlx.expr.HalfPointFreeExpr;
import org.drools.javaparser.ast.drlx.expr.InlineCastExpr;
import org.drools.javaparser.ast.drlx.expr.NullSafeFieldAccessExpr;
import org.drools.javaparser.ast.drlx.expr.NullSafeMethodCallExpr;
import org.drools.javaparser.ast.drlx.expr.PointFreeExpr;
import org.drools.javaparser.ast.drlx.expr.TemporalLiteralChunkExpr;
import org.drools.javaparser.ast.drlx.expr.TemporalLiteralExpr;
import org.drools.javaparser.ast.drlx.expr.TemporalLiteralInfiniteChunkExpr;
import org.drools.javaparser.ast.expr.BigDecimalLiteralExpr;
import org.drools.javaparser.ast.expr.BigIntegerLiteralExpr;

public interface VoidRuleVisitor<A> {

    default void visit( RuleDeclaration ruleDeclaration, A arg ) { }

    default void visit( RuleBody ruleBody, A arg ) { }

    default void visit( RulePattern rulePattern, A arg ) { }

    default void visit( DrlxExpression expr, A arg ) { }

    default void visit( OOPathExpr expr, A arg ) { }

    default void visit( OOPathChunk chunk, A arg ) { }

    default void visit( RuleConsequence ruleConsequence, A arg ) { }

    default void visit( InlineCastExpr inlineCastExpr, A arg ) { }

    default void visit( NullSafeFieldAccessExpr nullSafeFieldAccessExpr, A arg ) { }

    default void visit( NullSafeMethodCallExpr nullSafeMethodCallExpr, A arg ) { }

    default void visit( PointFreeExpr pointFreeExpr, A arg ) { }

    default void visit( TemporalLiteralExpr temporalLiteralExpr, A arg ) { }

    default void visit(TemporalLiteralChunkExpr temporalLiteralChunkExpr, A arg) {}

    default void visit(HalfBinaryExpr n, A arg) {}

    default void visit(HalfPointFreeExpr n, A arg) {}

    default void visit(BigDecimalLiteralExpr bigDecimalLiteralExpr, A arg) {}

    default void visit(BigIntegerLiteralExpr bigIntegerLiteralExpr, A arg) {}

    default void visit(TemporalLiteralInfiniteChunkExpr temporalLiteralInfiniteChunkExpr, A arg) { }
}
