package org.drools.javaparser.printer.lexicalpreservation.changes;

import org.drools.javaparser.ast.Node;
import org.drools.javaparser.ast.observer.ObservableProperty;

/**
 * The change in value of a property.
 */
public class PropertyChange implements Change {
    private final ObservableProperty property;
    private final Object oldValue;
    private final Object newValue;

    public ObservableProperty getProperty() {
        return property;
    }

    public Object getOldValue() {
        return oldValue;
    }

    public Object getNewValue() {
        return newValue;
    }

    public PropertyChange(ObservableProperty property, Object oldValue, Object newValue) {
        this.property = property;
        this.oldValue = oldValue;
        this.newValue = newValue;
    }

    @Override
    public Object getValue(ObservableProperty property, Node node) {
        if (property == this.property) {
            return newValue;
        } else {
            return property.getRawValue(node);
        }
    }
}
