/*
 * Decompiled with CFR 0.152.
 */
package org.drools.drlx;

import com.github.javaparser.JavaParser;
import com.github.javaparser.ParseProblemException;
import com.github.javaparser.ParseStart;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.drlx.OOPathChunk;
import com.github.javaparser.ast.drlx.OOPathExpr;
import com.github.javaparser.ast.drlx.expr.DrlxExpression;
import com.github.javaparser.ast.drlx.expr.HalfBinaryExpr;
import com.github.javaparser.ast.drlx.expr.HalfPointFreeExpr;
import com.github.javaparser.ast.drlx.expr.PointFreeExpr;
import com.github.javaparser.ast.drlx.expr.TemporalLiteralChunkExpr;
import com.github.javaparser.ast.drlx.expr.TemporalLiteralExpr;
import com.github.javaparser.ast.expr.BinaryExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.FieldAccessExpr;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.printer.PrintUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.TimeUnit;
import org.drools.drlx.DrlxParser;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class DrlxParserTest {
    private static final Collection<String> operators = new HashSet<String>();
    final ParseStart<DrlxExpression> parser;

    public DrlxParserTest() {
        operators.addAll(Arrays.asList("after", "before", "in", "matches", "includes"));
        this.parser = DrlxParser.buildDrlxParserWithArguments(operators);
    }

    @Test
    public void testParseSimpleExpr() {
        String expr = "name == \"Mark\"";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        System.out.println(expression);
        BinaryExpr binaryExpr = (BinaryExpr)expression;
        Assert.assertEquals((Object)"name", (Object)binaryExpr.getLeft().toString());
        Assert.assertEquals((Object)"\"Mark\"", (Object)binaryExpr.getRight().toString());
        Assert.assertEquals((Object)BinaryExpr.Operator.EQUALS, (Object)binaryExpr.getOperator());
    }

    @Test
    public void testParseSafeCastExpr() {
        String expr = "this instanceof Person && ((Person)this).name == \"Mark\"";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        System.out.println(expression);
    }

    @Test
    public void testParseInlineCastExpr() {
        String expr = "this#Person.name == \"Mark\"";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        Assert.assertEquals((Object)expr, (Object)PrintUtil.toDrlx((Node)expression));
    }

    @Test
    public void testNotAllowedInlineCastInJava() {
        String expr = "this#Person.name == \"Mark\"";
        try {
            Expression expression = JavaParser.parseExpression((String)expr);
            Assert.fail((String)"Parsing of non valid java expression must fail");
        }
        catch (ParseProblemException parseProblemException) {
            // empty catch block
        }
    }

    @Test
    public void testParseNullSafeFieldAccessExpr() {
        String expr = "person!.name == \"Mark\"";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        Assert.assertEquals((Object)expr, (Object)PrintUtil.toDrlx((Node)expression));
    }

    @Test
    public void testDotFreeExpr() {
        String expr = "this after $a";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        Assert.assertTrue((boolean)(expression instanceof PointFreeExpr));
        Assert.assertEquals((Object)expr, (Object)PrintUtil.toDrlx((Node)expression));
    }

    @Test
    public void testDotFreeEnclosed() {
        String expr = "(this after $a)";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        Assert.assertEquals((Object)expr, (Object)PrintUtil.toDrlx((Node)expression));
    }

    @Test
    public void testDotFreeEnclosedWithNameExpr() {
        String expr = "(something after $a)";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        Assert.assertEquals((Object)expr, (Object)PrintUtil.toDrlx((Node)expression));
    }

    @Test
    public void testLiteral() {
        String bigDecimalLiteral = "bigInteger < (50B)";
        Expression bigDecimalExpr = DrlxParser.parseExpression(this.parser, (String)bigDecimalLiteral).getExpr();
        Assert.assertEquals((Object)bigDecimalLiteral, (Object)PrintUtil.toDrlx((Node)bigDecimalExpr));
        String bigIntegerLiteral = "bigInteger == (50I)";
        Expression bigIntegerExpr = DrlxParser.parseExpression(this.parser, (String)bigIntegerLiteral).getExpr();
        Assert.assertEquals((Object)bigIntegerLiteral, (Object)PrintUtil.toDrlx((Node)bigIntegerExpr));
    }

    @Test
    public void testDotFreeExprWithOr() {
        String expr = "this after $a || this after $b";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        Assert.assertTrue((boolean)(expression instanceof BinaryExpr));
        Assert.assertEquals((Object)expr, (Object)PrintUtil.toDrlx((Node)expression));
    }

    @Test
    public void testDotFreeExprWithArgs() {
        String expr = "this after[5,8] $a";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        Assert.assertTrue((boolean)(expression instanceof PointFreeExpr));
        Assert.assertFalse((boolean)((PointFreeExpr)expression).isNegated());
        Assert.assertEquals((Object)"this after[5ms,8ms] $a", (Object)PrintUtil.toDrlx((Node)expression));
    }

    @Test
    public void testDotFreeExprWithArgsInfinite() {
        String expr = "this after[5s,*] $a";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        Assert.assertTrue((boolean)(expression instanceof PointFreeExpr));
        Assert.assertFalse((boolean)((PointFreeExpr)expression).isNegated());
        Assert.assertEquals((Object)"this after[5s,*] $a", (Object)PrintUtil.toDrlx((Node)expression));
    }

    @Test
    public void testDotFreeExprWithThreeArgsInfinite() {
        String expr = "this after[*,*,*,2s] $a";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        Assert.assertTrue((boolean)(expression instanceof PointFreeExpr));
        Assert.assertFalse((boolean)((PointFreeExpr)expression).isNegated());
        Assert.assertEquals((Object)"this after[*,*,*,2s] $a", (Object)PrintUtil.toDrlx((Node)expression));
    }

    @Test
    public void testDotFreeExprWithArgsNegated() {
        String expr = "this not after[5,8] $a";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        Assert.assertThat((Object)expression, (Matcher)CoreMatchers.instanceOf(PointFreeExpr.class));
        Assert.assertTrue((boolean)((PointFreeExpr)expression).isNegated());
        Assert.assertEquals((Object)"this not after[5ms,8ms] $a", (Object)PrintUtil.toDrlx((Node)expression));
    }

    @Test
    public void testDotFreeExprWithTemporalArgs() {
        String expr = "this after[5ms,8d] $a";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        Assert.assertTrue((boolean)(expression instanceof PointFreeExpr));
        Assert.assertEquals((Object)expr, (Object)PrintUtil.toDrlx((Node)expression));
    }

    @Test
    public void testDotFreeExprWithFourTemporalArgs() {
        String expr = "this includes[1s,1m,1h,1d] $a";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        Assert.assertTrue((boolean)(expression instanceof PointFreeExpr));
        Assert.assertEquals((Object)expr, (Object)PrintUtil.toDrlx((Node)expression));
    }

    @Test
    public void testHalfDotFreeExprWithFourTemporalArgs() {
        String expr = "includes[1s,1m,1h,1d] $a";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        Assert.assertThat((Object)expression, (Matcher)CoreMatchers.instanceOf(HalfPointFreeExpr.class));
        Assert.assertEquals((Object)expr, (Object)PrintUtil.toDrlx((Node)expression));
    }

    @Test(expected=ParseProblemException.class)
    public void testInvalidTemporalArgs() {
        String expr = "this after[5ms,8f] $a";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
    }

    @Test
    public void testOOPathExpr() {
        String expr = "/wife/children[age > 10]/toys";
        DrlxExpression drlx = DrlxParser.parseExpression(this.parser, (String)expr);
        Expression expression = drlx.getExpr();
        Assert.assertTrue((boolean)(expression instanceof OOPathExpr));
        Assert.assertEquals((Object)expr, (Object)PrintUtil.toDrlx((Node)drlx));
    }

    @Test
    public void testOOPathExprWithMultipleCondition() {
        String expr = "$address : /address[street == \"Elm\",city == \"Big City\"]";
        DrlxExpression drlx = DrlxParser.parseExpression(this.parser, (String)expr);
        Expression expression = drlx.getExpr();
        Assert.assertTrue((boolean)(expression instanceof OOPathExpr));
        Assert.assertEquals((Object)expr, (Object)PrintUtil.toDrlx((Node)drlx));
    }

    @Test
    public void testOOPathExprWithDeclaration() {
        String expr = "$toy : /wife/children[age > 10]/toys";
        DrlxExpression drlx = DrlxParser.parseExpression(this.parser, (String)expr);
        Assert.assertEquals((Object)"$toy", (Object)drlx.getBind().asString());
        Expression expression = drlx.getExpr();
        Assert.assertTrue((boolean)(expression instanceof OOPathExpr));
        Assert.assertEquals((Object)expr, (Object)PrintUtil.toDrlx((Node)drlx));
    }

    @Test
    public void testOOPathExprWithBackReference() {
        String expr = "$toy : /wife/children/toys[name.length == ../../name.length]";
        DrlxExpression drlx = DrlxParser.parseExpression(this.parser, (String)expr);
        Assert.assertEquals((Object)"$toy", (Object)drlx.getBind().asString());
        Expression expression = drlx.getExpr();
        Assert.assertTrue((boolean)(expression instanceof OOPathExpr));
        OOPathChunk secondChunk = (OOPathChunk)((OOPathExpr)expression).getChunks().get(2);
        BinaryExpr secondChunkFirstCondition = (BinaryExpr)secondChunk.getConditions().get(0);
        NameExpr rightName = (NameExpr)((FieldAccessExpr)secondChunkFirstCondition.getRight()).getScope();
        Assert.assertEquals((long)2L, (long)rightName.getBackReferencesCount());
        Assert.assertEquals((Object)expr, (Object)PrintUtil.toDrlx((Node)drlx));
    }

    @Test
    public void testParseTemporalLiteral() {
        String expr = "5s";
        TemporalLiteralExpr drlx = DrlxParser.parseTemporalLiteral((String)expr);
        Assert.assertEquals((Object)expr, (Object)PrintUtil.toDrlx((Node)drlx));
        Assert.assertEquals((long)1L, (long)drlx.getChunks().size());
        TemporalLiteralChunkExpr chunk0 = (TemporalLiteralChunkExpr)drlx.getChunks().get(0);
        Assert.assertEquals((long)5L, (long)chunk0.getValue());
        Assert.assertEquals((Object)((Object)TimeUnit.SECONDS), (Object)((Object)chunk0.getTimeUnit()));
    }

    @Test
    public void testParseTemporalLiteralOf2Chunks() {
        String expr = "1m5s";
        TemporalLiteralExpr drlx = DrlxParser.parseTemporalLiteral((String)expr);
        Assert.assertEquals((Object)expr, (Object)PrintUtil.toDrlx((Node)drlx));
        Assert.assertEquals((long)2L, (long)drlx.getChunks().size());
        TemporalLiteralChunkExpr chunk0 = (TemporalLiteralChunkExpr)drlx.getChunks().get(0);
        Assert.assertEquals((long)1L, (long)chunk0.getValue());
        Assert.assertEquals((Object)((Object)TimeUnit.MINUTES), (Object)((Object)chunk0.getTimeUnit()));
        TemporalLiteralChunkExpr chunk1 = (TemporalLiteralChunkExpr)drlx.getChunks().get(1);
        Assert.assertEquals((long)5L, (long)chunk1.getValue());
        Assert.assertEquals((Object)((Object)TimeUnit.SECONDS), (Object)((Object)chunk1.getTimeUnit()));
    }

    @Test
    public void testInExpression() {
        String expr = "this in ()";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        Assert.assertTrue((boolean)(expression instanceof PointFreeExpr));
        Assert.assertEquals((Object)expr, (Object)PrintUtil.toDrlx((Node)expression));
    }

    @Test
    public void testUnsupportedImplicitParameter() {
        String expr = "== \"Mark\"";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        Assert.assertTrue((boolean)(expression instanceof HalfBinaryExpr));
        Assert.assertEquals((Object)expr, (Object)PrintUtil.toDrlx((Node)expression));
    }

    @Test(expected=ParseProblemException.class)
    public void testUnsupportedImplicitParameterWithJavaParser() {
        String expr = "== \"Mark\"";
        JavaParser.parseExpression((String)expr);
    }

    @Test
    public void testAndWithImplicitNegativeParameter() {
        String expr = "value > -2 && < -1";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        System.out.println(expression);
        BinaryExpr comboExpr = (BinaryExpr)expression;
        Assert.assertEquals((Object)BinaryExpr.Operator.AND, (Object)comboExpr.getOperator());
        BinaryExpr first = (BinaryExpr)comboExpr.getLeft();
        Assert.assertEquals((Object)"value", (Object)first.getLeft().toString());
        Assert.assertEquals((Object)"-2", (Object)first.getRight().toString());
        Assert.assertEquals((Object)BinaryExpr.Operator.GREATER, (Object)first.getOperator());
        HalfBinaryExpr second = (HalfBinaryExpr)comboExpr.getRight();
        Assert.assertEquals((Object)"-1", (Object)second.getRight().toString());
        Assert.assertEquals((Object)HalfBinaryExpr.Operator.LESS, (Object)second.getOperator());
    }

    @Test
    public void testOrWithImplicitParameter() {
        String expr = "name == \"Mark\" || == \"Mario\" || == \"Luca\"";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        System.out.println(expression);
        BinaryExpr comboExpr = (BinaryExpr)expression;
        Assert.assertEquals((Object)BinaryExpr.Operator.OR, (Object)comboExpr.getOperator());
        BinaryExpr first = (BinaryExpr)((BinaryExpr)comboExpr.getLeft()).getLeft();
        Assert.assertEquals((Object)"name", (Object)first.getLeft().toString());
        Assert.assertEquals((Object)"\"Mark\"", (Object)first.getRight().toString());
        Assert.assertEquals((Object)BinaryExpr.Operator.EQUALS, (Object)first.getOperator());
        HalfBinaryExpr second = (HalfBinaryExpr)((BinaryExpr)comboExpr.getLeft()).getRight();
        Assert.assertEquals((Object)"\"Mario\"", (Object)second.getRight().toString());
        Assert.assertEquals((Object)HalfBinaryExpr.Operator.EQUALS, (Object)second.getOperator());
        HalfBinaryExpr third = (HalfBinaryExpr)comboExpr.getRight();
        Assert.assertEquals((Object)"\"Luca\"", (Object)third.getRight().toString());
        Assert.assertEquals((Object)HalfBinaryExpr.Operator.EQUALS, (Object)third.getOperator());
    }

    @Test
    public void testAndWithImplicitParameter() {
        String expr = "name == \"Mark\" && == \"Mario\" && == \"Luca\"";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        System.out.println(expression);
        BinaryExpr comboExpr = (BinaryExpr)expression;
        Assert.assertEquals((Object)BinaryExpr.Operator.AND, (Object)comboExpr.getOperator());
        BinaryExpr first = (BinaryExpr)((BinaryExpr)comboExpr.getLeft()).getLeft();
        Assert.assertEquals((Object)"name", (Object)first.getLeft().toString());
        Assert.assertEquals((Object)"\"Mark\"", (Object)first.getRight().toString());
        Assert.assertEquals((Object)BinaryExpr.Operator.EQUALS, (Object)first.getOperator());
        HalfBinaryExpr second = (HalfBinaryExpr)((BinaryExpr)comboExpr.getLeft()).getRight();
        Assert.assertEquals((Object)"\"Mario\"", (Object)second.getRight().toString());
        Assert.assertEquals((Object)HalfBinaryExpr.Operator.EQUALS, (Object)second.getOperator());
        HalfBinaryExpr third = (HalfBinaryExpr)comboExpr.getRight();
        Assert.assertEquals((Object)"\"Luca\"", (Object)third.getRight().toString());
        Assert.assertEquals((Object)HalfBinaryExpr.Operator.EQUALS, (Object)third.getOperator());
    }

    @Test
    public void testAndWithImplicitParameter2() {
        String expr = "name == \"Mark\" && == \"Mario\" || == \"Luca\"";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        System.out.println(expression);
        BinaryExpr comboExpr = (BinaryExpr)expression;
        Assert.assertEquals((Object)BinaryExpr.Operator.OR, (Object)comboExpr.getOperator());
        Assert.assertEquals((Object)BinaryExpr.Operator.AND, (Object)((BinaryExpr)comboExpr.getLeft()).getOperator());
        BinaryExpr first = (BinaryExpr)((BinaryExpr)comboExpr.getLeft()).getLeft();
        Assert.assertEquals((Object)"name", (Object)first.getLeft().toString());
        Assert.assertEquals((Object)"\"Mark\"", (Object)first.getRight().toString());
        Assert.assertEquals((Object)BinaryExpr.Operator.EQUALS, (Object)first.getOperator());
        HalfBinaryExpr second = (HalfBinaryExpr)((BinaryExpr)comboExpr.getLeft()).getRight();
        Assert.assertEquals((Object)"\"Mario\"", (Object)second.getRight().toString());
        Assert.assertEquals((Object)HalfBinaryExpr.Operator.EQUALS, (Object)second.getOperator());
        HalfBinaryExpr third = (HalfBinaryExpr)comboExpr.getRight();
        Assert.assertEquals((Object)"\"Luca\"", (Object)third.getRight().toString());
        Assert.assertEquals((Object)HalfBinaryExpr.Operator.EQUALS, (Object)third.getOperator());
    }

    @Test
    public void testAndWithImplicitParameter3() {
        String expr = "age == 2 && == 3 || == 4";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        System.out.println(expression);
        BinaryExpr comboExpr = (BinaryExpr)expression;
        Assert.assertEquals((Object)BinaryExpr.Operator.OR, (Object)comboExpr.getOperator());
        Assert.assertEquals((Object)BinaryExpr.Operator.AND, (Object)((BinaryExpr)comboExpr.getLeft()).getOperator());
        BinaryExpr first = (BinaryExpr)((BinaryExpr)comboExpr.getLeft()).getLeft();
        Assert.assertEquals((Object)"age", (Object)first.getLeft().toString());
        Assert.assertEquals((Object)"2", (Object)first.getRight().toString());
        Assert.assertEquals((Object)BinaryExpr.Operator.EQUALS, (Object)first.getOperator());
        HalfBinaryExpr second = (HalfBinaryExpr)((BinaryExpr)comboExpr.getLeft()).getRight();
        Assert.assertEquals((Object)"3", (Object)second.getRight().toString());
        Assert.assertEquals((Object)HalfBinaryExpr.Operator.EQUALS, (Object)second.getOperator());
        HalfBinaryExpr third = (HalfBinaryExpr)comboExpr.getRight();
        Assert.assertEquals((Object)"4", (Object)third.getRight().toString());
        Assert.assertEquals((Object)HalfBinaryExpr.Operator.EQUALS, (Object)third.getOperator());
    }

    @Test
    public void regressionTestImplicitOperator() {
        String expr = "{    for (i = 0; i < 10 && i < 2; i++) {\n            break;\n   }\n}";
        BlockStmt expression = JavaParser.parseBlock((String)expr);
        System.out.println(expression);
    }

    @Test
    public void regressionTestImplicitOperator2() {
        String expr = "i < 10 && i < 2";
        Expression expression = JavaParser.parseExpression((String)expr);
        System.out.println(expression);
    }

    @Test
    public void regressionTestImplicitOperator3() {
        String expr = "i == 10 && i == 2";
        Expression expression = JavaParser.parseExpression((String)expr);
        System.out.println(expression);
    }

    @Test
    public void dotFreeWithRegexp() {
        String expr = "name matches \"[a-z]*\"";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        Assert.assertThat((Object)expression, (Matcher)CoreMatchers.instanceOf(PointFreeExpr.class));
        Assert.assertEquals((Object)"name matches \"[a-z]*\"", (Object)PrintUtil.toDrlx((Node)expression));
        PointFreeExpr e = (PointFreeExpr)expression;
        Assert.assertEquals((Object)"matches", (Object)e.getOperator().asString());
        Assert.assertEquals((Object)"name", (Object)e.getLeft().toString());
        Assert.assertEquals((Object)"\"[a-z]*\"", (Object)((Expression)e.getRight().get(0)).toString());
    }

    @Test
    public void implicitOperatorWithRegexps() {
        String expr = "name matches \"[a-z]*\" || matches \"pippo\"";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        Assert.assertEquals((Object)"name matches \"[a-z]*\" || matches \"pippo\"", (Object)PrintUtil.toDrlx((Node)expression));
    }

    @Test
    public void halfPointFreeExpr() {
        String expr = "matches \"[A-Z]*\"";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        Assert.assertThat((Object)expression, (Matcher)CoreMatchers.instanceOf(HalfPointFreeExpr.class));
        Assert.assertEquals((Object)"matches \"[A-Z]*\"", (Object)PrintUtil.toDrlx((Node)expression));
    }

    @Test
    public void halfPointFreeExprNegated() {
        String expr = "not matches \"[A-Z]*\"";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        Assert.assertThat((Object)expression, (Matcher)CoreMatchers.instanceOf(HalfPointFreeExpr.class));
        Assert.assertEquals((Object)"not matches \"[A-Z]*\"", (Object)PrintUtil.toDrlx((Node)expression));
    }

    @Test
    public void regressionTestHalfPointFree() {
        Assert.assertThat((Object)DrlxParser.parseExpression(this.parser, (String)"getAddress().getAddressName().length() == 5").getExpr(), (Matcher)CoreMatchers.instanceOf(BinaryExpr.class));
        Assert.assertThat((Object)DrlxParser.parseExpression(this.parser, (String)"isFortyYearsOld(this, true)").getExpr(), (Matcher)CoreMatchers.instanceOf(MethodCallExpr.class));
        Assert.assertThat((Object)DrlxParser.parseExpression(this.parser, (String)"getName().startsWith(\"M\")").getExpr(), (Matcher)CoreMatchers.instanceOf(MethodCallExpr.class));
        Assert.assertThat((Object)DrlxParser.parseExpression(this.parser, (String)"isPositive($i.intValue())").getExpr(), (Matcher)CoreMatchers.instanceOf(MethodCallExpr.class));
        Assert.assertThat((Object)DrlxParser.parseExpression(this.parser, (String)"someEntity.someString in (\"1.500\")").getExpr(), (Matcher)CoreMatchers.instanceOf(PointFreeExpr.class));
    }

    @Test
    public void mvelSquareBracketsOperators() {
        this.testMvelSquareOperator("this str[startsWith] \"M\"", "str[startsWith]", "this", "\"M\"", false);
        this.testMvelSquareOperator("this not str[startsWith] \"M\"", "str[startsWith]", "this", "\"M\"", true);
        this.testMvelSquareOperator("this str[endsWith] \"K\"", "str[endsWith]", "this", "\"K\"", false);
        this.testMvelSquareOperator("this str[length] 17", "str[length]", "this", "17", false);
    }

    @Test
    public void halfPointFreeMVEL() {
        String expr = "this str[startsWith] \"M\" || str[startsWith] \"E\"";
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        Assert.assertEquals((Object)"this str[startsWith] \"M\" || str[startsWith] \"E\"", (Object)PrintUtil.toDrlx((Node)expression));
        Expression expression2 = DrlxParser.parseExpression(this.parser, (String)"str[startsWith] \"E\"").getExpr();
        Assert.assertThat((Object)expression2, (Matcher)CoreMatchers.instanceOf(HalfPointFreeExpr.class));
        Assert.assertEquals((Object)"str[startsWith] \"E\"", (Object)PrintUtil.toDrlx((Node)expression2));
    }

    private void testMvelSquareOperator(String wholeExpression, String operator, String left, String right, boolean isNegated) {
        String expr = wholeExpression;
        Expression expression = DrlxParser.parseExpression(this.parser, (String)expr).getExpr();
        Assert.assertThat((Object)expression, (Matcher)CoreMatchers.instanceOf(PointFreeExpr.class));
        Assert.assertEquals((Object)wholeExpression, (Object)PrintUtil.toDrlx((Node)expression));
        PointFreeExpr e = (PointFreeExpr)expression;
        Assert.assertEquals((Object)operator, (Object)e.getOperator().asString());
        Assert.assertEquals((Object)left, (Object)e.getLeft().toString());
        Assert.assertEquals((Object)right, (Object)((Expression)e.getRight().get(0)).toString());
        Assert.assertEquals((Object)isNegated, (Object)e.isNegated());
    }
}

