package org.drools.javaparser.ast.nodeTypes.modifiers;

import org.drools.javaparser.ast.Node;
import org.drools.javaparser.ast.nodeTypes.NodeWithModifiers;

import static org.drools.javaparser.ast.Modifier.Keyword.ABSTRACT;

/**
 * A node that can be abstract.
 */
public interface NodeWithAbstractModifier<N extends Node> extends NodeWithModifiers<N> {
    default boolean isAbstract() {
        return hasModifier(ABSTRACT);
    }

    @SuppressWarnings("unchecked")
    default N setAbstract(boolean set) {
        return setModifier(ABSTRACT, set);
    }
}
