package org.drools.javaparser.ast.nodeTypes.modifiers;

import org.drools.javaparser.ast.Node;
import org.drools.javaparser.ast.nodeTypes.NodeWithModifiers;

import static org.drools.javaparser.ast.Modifier.Keyword.PUBLIC;

/**
 * A node that can be public.
 */
public interface NodeWithPublicModifier<N extends Node> extends NodeWithModifiers<N> {
    default boolean isPublic() {
        return hasModifier(PUBLIC);
    }

    @SuppressWarnings("unchecked")
    default N setPublic(boolean set) {
        return setModifier(PUBLIC, set);
    }

}
