/*
 * Decompiled with CFR 0.152.
 */
package org.drools.android;

import android.content.Context;
import java.io.File;
import org.drools.android.MultiDexClassLoader;
import org.mvel2.optimizers.OptimizerFactory;
import org.mvel2.optimizers.impl.asm.ASMAccessorOptimizer;
import org.mvel2.util.MVELClassLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DroolsAndroidContext {
    private static final Logger log = LoggerFactory.getLogger(DroolsAndroidContext.class);
    private static Context context;
    private static boolean reuseClassFiles;
    private static File cacheDir;
    private static File dexDir;
    private static File optimizedDir;

    public static Context getContext() {
        return context;
    }

    public static void setContext(Context ctx) {
        context = ctx;
        cacheDir = new File(context.getCacheDir(), "drools");
        dexDir = new File(cacheDir, "dex");
        if (!DroolsAndroidContext.isReuseClassFiles()) {
            DroolsAndroidContext.deleteDir(dexDir);
        }
        dexDir.mkdirs();
        optimizedDir = new File(cacheDir, "optimized");
        optimizedDir.mkdirs();
        System.setProperty("drools.dialect.java.compiler.lnglevel", "1.6");
        System.setProperty("java.version", "1.6");
        System.setProperty("mvel.java.version", "1.6");
        ASMAccessorOptimizer.setMVELClassLoader((MVELClassLoader)new MultiDexClassLoader((ClassLoader)ASMAccessorOptimizer.getMVELClassLoader()));
        OptimizerFactory.setDefaultOptimizer((String)"ASM");
    }

    private static boolean deleteDir(File dir) {
        if (dir != null && dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = DroolsAndroidContext.deleteDir(new File(dir, children[i]));
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }

    public static boolean isReuseClassFiles() {
        return reuseClassFiles;
    }

    public static void setReuseClassFiles(boolean reuse) {
        reuseClassFiles = reuse;
    }

    public static File getCacheDir() {
        return cacheDir;
    }

    public static File getDexDir() {
        return dexDir;
    }

    public static File getOptimizedDir() {
        return optimizedDir;
    }

    static {
        reuseClassFiles = true;
    }
}

