/*
 * Decompiled with CFR 0.152.
 */
package org.drools.android;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import org.drools.android.MultiDexClassLoader;
import org.drools.core.rule.JavaDialectRuntimeData;
import org.drools.core.util.ClassUtils;
import org.kie.internal.utils.FastClassLoader;

public class DexPackageClassLoader
extends MultiDexClassLoader
implements FastClassLoader {
    protected JavaDialectRuntimeData store;
    private Set<String> existingPackages = new ConcurrentSkipListSet<String>();

    public DexPackageClassLoader(JavaDialectRuntimeData store, ClassLoader rootClassLoader) {
        super(rootClassLoader);
        this.store = store;
    }

    public Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> cls = this.fastFindClass(name);
        if (cls == null) {
            ClassLoader parent = this.getParent();
            cls = parent.loadClass(name);
        }
        if (cls == null) {
            throw new ClassNotFoundException("Unable to load class: " + name);
        }
        return cls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class<?> fastFindClass(String name) {
        Class cls = this.findLoadedClass(name);
        if (cls == null) {
            byte[] clazzBytes = this.store.read(ClassUtils.convertClassToResourcePath((String)name));
            if (clazzBytes != null) {
                String pkgName = name.substring(0, name.lastIndexOf(46));
                if (!this.existingPackages.contains(pkgName)) {
                    DexPackageClassLoader dexPackageClassLoader = this;
                    synchronized (dexPackageClassLoader) {
                        if (this.getPackage(pkgName) == null) {
                            this.definePackage(pkgName, "", "", "", "", "", "", null);
                        }
                        this.existingPackages.add(pkgName);
                    }
                }
                cls = super.defineClass(name, clazzBytes);
            }
            if (cls != null) {
                this.resolveClass(cls);
            }
        }
        return cls;
    }

    public InputStream getResourceAsStream(String name) {
        byte[] clsBytes = this.store.read(name);
        if (clsBytes != null) {
            return new ByteArrayInputStream(clsBytes);
        }
        return null;
    }

    public URL getResource(String name) {
        return null;
    }

    public Enumeration<URL> getResources(String name) throws IOException {
        return new Enumeration<URL>(){

            @Override
            public boolean hasMoreElements() {
                return false;
            }

            @Override
            public URL nextElement() {
                throw new NoSuchElementException();
            }
        };
    }
}

