/*
 * Decompiled with CFR 0.152.
 */
package org.drools.contrib;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.io.StringReader;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;
import org.drools.RuleBase;
import org.drools.RuleBaseFactory;
import org.drools.RuntimeDroolsException;
import org.drools.brms.client.modeldriven.brl.RuleModel;
import org.drools.brms.server.util.BRDRLPersistence;
import org.drools.brms.server.util.BRXMLPersistence;
import org.drools.compiler.DrlParser;
import org.drools.compiler.DroolsParserException;
import org.drools.compiler.PackageBuilder;
import org.drools.compiler.PackageBuilderConfiguration;
import org.drools.lang.Expander;
import org.drools.lang.dsl.DSLMappingFile;
import org.drools.lang.dsl.DefaultExpander;
import org.drools.lang.dsl.DefaultExpanderResolver;
import org.drools.rule.Package;

public class DroolsCompilerAntTask
extends MatchingTask {
    public static String BRLFILEEXTENSION = ".brl";
    public static String XMLFILEEXTENSION = ".xml";
    public static String RULEFLOWFILEEXTENSION = ".rfm";
    public static String DSLFILEEXTENSION = ".dslr";
    private File srcdir;
    private File toFile;
    private Path classpath;

    public void setSrcDir(File directory) {
        this.srcdir = directory;
    }

    public void setToFile(File toFile) {
        this.toFile = toFile;
    }

    public void setClasspath(Path classpath) {
        this.createClasspath().append(classpath);
    }

    public void setClasspathref(Reference r) {
        this.createClasspath().setRefid(r);
    }

    public Path createClasspath() {
        if (this.classpath == null) {
            this.classpath = new Path(this.getProject());
        }
        return this.classpath.createPath();
    }

    public void execute() throws BuildException {
        super.execute();
        if (this.toFile == null) {
            throw new BuildException("Destination rulebase file does not specified.");
        }
        if (this.srcdir == null) {
            throw new BuildException("Source directory not specified.");
        }
        if (!this.srcdir.exists()) {
            throw new BuildException("Source directory does not exists." + this.srcdir.getAbsolutePath());
        }
        try {
            AntClassLoader loader = this.getClassLoader();
            PackageBuilder builder = this.getPackageBuilder(loader);
            String[] fileNames = this.getFileList();
            for (int i = 0; i < fileNames.length; ++i) {
                this.compileAndAddFile(builder, fileNames[i]);
            }
            Package pkg = builder.getPackage();
            RuleBase ruleBase = RuleBaseFactory.newRuleBase();
            ruleBase.addPackage(pkg);
            this.serializeRulebase(ruleBase);
        }
        catch (Exception e) {
            throw new BuildException("RuleBaseTask failed: " + e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serializeRulebase(RuleBase ruleBase) throws FileNotFoundException, IOException {
        ObjectOutputStream outstream = null;
        try {
            FileOutputStream fout = new FileOutputStream(this.toFile);
            outstream = new ObjectOutputStream(fout);
            outstream.writeObject(ruleBase);
        }
        finally {
            if (outstream != null) {
                outstream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compileAndAddFile(PackageBuilder builder, String fileName) throws FileNotFoundException, DroolsParserException, IOException {
        InputStreamReader instream = null;
        try {
            if (fileName.endsWith(BRLFILEEXTENSION)) {
                RuleModel model = BRXMLPersistence.getInstance().unmarshal(this.loadResource(fileName));
                String packagefile = this.loadResource(this.resolvePackageFile(this.srcdir.getAbsolutePath()));
                model.name = fileName.replace(BRLFILEEXTENSION, "");
                ByteArrayInputStream istream = new ByteArrayInputStream((packagefile + BRDRLPersistence.getInstance().marshal(model)).getBytes());
                instream = new InputStreamReader(istream);
            } else {
                File file = new File(this.srcdir, fileName);
                instream = new InputStreamReader(new FileInputStream(file));
            }
            if (fileName.endsWith(RULEFLOWFILEEXTENSION)) {
                builder.addRuleFlow((Reader)instream);
            } else if (fileName.endsWith(XMLFILEEXTENSION)) {
                builder.addPackageFromXml((Reader)instream);
            } else if (fileName.endsWith(DSLFILEEXTENSION)) {
                DrlParser parser = new DrlParser();
                String expandedDRL = parser.getExpandedDRL(this.loadResource(fileName), this.resolveDSLFiles());
                builder.addPackageFromDrl((Reader)new StringReader(expandedDRL));
            } else {
                builder.addPackageFromDrl((Reader)instream);
            }
        }
        finally {
            if (instream != null) {
                instream.close();
            }
        }
    }

    private DefaultExpanderResolver resolveDSLFiles() throws IOException {
        DefaultExpanderResolver resolver = new DefaultExpanderResolver();
        File dir = new File(this.srcdir.getAbsolutePath());
        DSLMappingFile file = new DSLMappingFile();
        FilenameFilter filter = new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(".dsl");
            }
        };
        String[] children = dir.list(filter);
        if (children.length == 0) {
            throw new BuildException("There are no DSL files for this directory:" + this.srcdir.getAbsolutePath());
        }
        for (int index = 0; index < children.length; ++index) {
            if (!file.parseAndLoad((Reader)new StringReader(this.loadResource(children[index])))) {
                throw new RuntimeDroolsException("Error parsing and loading DSL file." + file.getErrors());
            }
            DefaultExpander expander = new DefaultExpander();
            expander.addDSLMapping(file.getMapping());
            resolver.addExpander("*", (Expander)expander);
        }
        return resolver;
    }

    private String resolvePackageFile(String dirname) {
        File dir = new File(dirname);
        FilenameFilter filter = new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(".package");
            }
        };
        String[] children = dir.list(filter);
        if (children.length > 1) {
            throw new BuildException("There are more than one package configuration file for this directory :" + dirname);
        }
        if (children.length == 0) {
            throw new BuildException("There is no package configuration file for this directory:" + dirname);
        }
        return children[0];
    }

    private String loadResource(String name) throws IOException {
        FileInputStream in = new FileInputStream(this.srcdir + "/" + name);
        InputStreamReader reader = new InputStreamReader(in);
        StringBuffer text = new StringBuffer();
        char[] buf = new char[1024];
        int len = 0;
        while ((len = reader.read(buf)) >= 0) {
            text.append(buf, 0, len);
        }
        return text.toString();
    }

    private AntClassLoader getClassLoader() {
        AntClassLoader loader = null;
        loader = this.classpath != null ? new AntClassLoader(PackageBuilder.class.getClassLoader(), this.getProject(), this.classpath, false) : new AntClassLoader(PackageBuilder.class.getClassLoader(), false);
        loader.setThreadContextLoader();
        return loader;
    }

    private PackageBuilder getPackageBuilder(AntClassLoader loader) {
        PackageBuilderConfiguration conf = new PackageBuilderConfiguration();
        conf.setClassLoader((ClassLoader)loader);
        PackageBuilder builder = new PackageBuilder(conf);
        return builder;
    }

    private String[] getFileList() {
        DirectoryScanner directoryScanner = this.getDirectoryScanner(this.srcdir);
        String[] fileNames = directoryScanner.getIncludedFiles();
        if (fileNames == null || fileNames.length <= 0) {
            throw new BuildException("No rule files found in include directory.");
        }
        return fileNames;
    }
}

