/*
 * Decompiled with CFR 0.152.
 */
package org.drools.contrib;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import junit.framework.Assert;
import org.drools.KnowledgeBase;
import org.drools.RuleBase;
import org.drools.contrib.BuildFileTest;
import org.drools.definition.KnowledgePackage;
import org.drools.rule.Package;
import org.drools.util.DroolsStreamUtils;

public class DroolsAntTaskTest
extends BuildFileTest {
    public DroolsAntTaskTest() {
        super("DroolsAntTest");
    }

    public void setUp() {
        this.configureProject("src/test/resources/DroolsAntTask.xml");
    }

    public void testVerifierReport() {
        try {
            this.executeTarget("verifierreport");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void testDslRules() throws IOException, ClassNotFoundException {
        try {
            this.executeTarget("dslRules");
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("Should not throw any exception: " + e.getMessage()));
        }
        Package p1 = (Package)DroolsStreamUtils.streamIn((InputStream)new FileInputStream("target/cheese.rules.dpkg"));
        DroolsAntTaskTest.assertNotNull((Object)p1);
        DroolsAntTaskTest.assertEquals((int)1, (int)p1.getRules().length);
    }

    public void testDslRulesKnowledge() throws IOException, ClassNotFoundException {
        try {
            this.executeTarget("dslRulesKnowledge");
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("Should not throw any exception: " + e.getMessage()));
        }
        KnowledgePackage kpackage1 = (KnowledgePackage)DroolsStreamUtils.streamIn((InputStream)new FileInputStream("target/cheese.rules.dpkg"));
        DroolsAntTaskTest.assertNotNull((Object)kpackage1);
        DroolsAntTaskTest.assertEquals((int)1, (int)kpackage1.getRules().size());
    }

    public void testRules() throws IOException, ClassNotFoundException {
        try {
            this.executeTarget("rules");
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("Should not throw any exception: " + e.getMessage()));
        }
        RuleBase r1 = (RuleBase)DroolsStreamUtils.streamIn((InputStream)new FileInputStream("target/cheese.rules"));
        DroolsAntTaskTest.assertNotNull((Object)r1);
        DroolsAntTaskTest.assertEquals((int)1, (int)r1.getPackages().length);
    }

    public void testRulesKnowledge() throws IOException, ClassNotFoundException {
        try {
            this.executeTarget("rulesKnowledge");
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("Should not throw any exception: " + e.getMessage()));
        }
        KnowledgeBase kbase = (KnowledgeBase)DroolsStreamUtils.streamIn((InputStream)new FileInputStream("target/cheese.rules"));
        DroolsAntTaskTest.assertNotNull((Object)kbase);
        DroolsAntTaskTest.assertEquals((int)1, (int)kbase.getKnowledgePackages().size());
    }

    public void testRuleFlow() throws IOException, ClassNotFoundException {
        try {
            this.executeTarget("ruleFlow");
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("Should not throw any exception: " + e.getMessage()));
        }
        RuleBase r1 = (RuleBase)DroolsStreamUtils.streamIn((InputStream)new FileInputStream("target/ruleFlow.rules"));
        DroolsAntTaskTest.assertNotNull((Object)r1);
        DroolsAntTaskTest.assertEquals((int)1, (int)r1.getPackages().length);
    }

    public void testRuleFlowKnowledge() throws IOException, ClassNotFoundException {
        try {
            this.executeTarget("ruleFlowKnowledge");
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("Should not throw any exception: " + e.getMessage()));
        }
        KnowledgeBase kbase = (KnowledgeBase)DroolsStreamUtils.streamIn((InputStream)new FileInputStream("target/ruleFlow.rules"));
        DroolsAntTaskTest.assertNotNull((Object)kbase);
        DroolsAntTaskTest.assertEquals((int)1, (int)kbase.getKnowledgePackages().size());
    }

    public void testNoPackageFile() {
        try {
            this.executeTarget("rulesnopackagefile");
            Assert.fail((String)"Should throw an exception ");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void testManyPackageFiles() {
        try {
            this.executeTarget("rulesmanypackagefile");
            Assert.fail((String)"Should throw an exception ");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

