/*
 * Decompiled with CFR 0.152.
 */
package org.drools.contrib;

import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;
import org.junit.Assert;

public abstract class BuildFileTest {
    protected Project project;
    private StringBuffer logBuffer;
    private StringBuffer fullLogBuffer;
    private StringBuffer outBuffer;
    private StringBuffer errBuffer;
    private BuildException buildException;

    protected void expectBuildException(String target, String cause) {
        this.expectSpecificBuildException(target, cause, null);
    }

    protected void expectLog(String target, String log) {
        this.executeTarget(target);
        String realLog = this.getLog();
        Assert.assertEquals((Object)log, (Object)realLog);
    }

    protected void assertLogContaining(String substring) {
        String realLog = this.getLog();
        Assert.assertTrue((String)("expecting log to contain \"" + substring + "\" log was \"" + realLog + "\""), (realLog.indexOf(substring) >= 0 ? 1 : 0) != 0);
    }

    protected void expectLogContaining(String target, String log) {
        this.executeTarget(target);
        this.assertLogContaining(log);
    }

    protected String getLog() {
        return this.logBuffer.toString();
    }

    protected void expectDebuglog(String target, String log) {
        this.executeTarget(target);
        String realLog = this.getFullLog();
        Assert.assertEquals((Object)log, (Object)realLog);
    }

    protected String getFullLog() {
        return this.fullLogBuffer.toString();
    }

    protected void expectOutput(String target, String output) {
        this.executeTarget(target);
        String realOutput = this.getOutput();
        Assert.assertEquals((Object)output, (Object)realOutput.trim());
    }

    protected void expectOutputAndError(String target, String output, String error) {
        this.executeTarget(target);
        String realOutput = this.getOutput();
        Assert.assertEquals((Object)output, (Object)realOutput);
        String realError = this.getError();
        Assert.assertEquals((Object)error, (Object)realError);
    }

    protected String getOutput() {
        return this.cleanBuffer(this.outBuffer);
    }

    protected String getError() {
        return this.cleanBuffer(this.errBuffer);
    }

    protected BuildException getBuildException() {
        return this.buildException;
    }

    private String cleanBuffer(StringBuffer buffer) {
        StringBuffer cleanedBuffer = new StringBuffer();
        boolean cr = false;
        for (int i = 0; i < buffer.length(); ++i) {
            char ch = buffer.charAt(i);
            if (ch == '\r') {
                cr = true;
                continue;
            }
            if (!cr) {
                cleanedBuffer.append(ch);
                continue;
            }
            cleanedBuffer.append(ch);
        }
        return cleanedBuffer.toString();
    }

    protected void configureProject(String filename) throws BuildException {
        this.configureProject(filename, 4);
    }

    protected void configureProject(String filename, int logLevel) throws BuildException {
        this.logBuffer = new StringBuffer();
        this.fullLogBuffer = new StringBuffer();
        this.project = new Project();
        this.project.init();
        this.project.setUserProperty("ant.file", new File(filename).getAbsolutePath());
        this.project.addBuildListener((BuildListener)new AntTestListener(logLevel));
        ProjectHelper.configureProject((Project)this.project, (File)new File(filename));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeTarget(String targetName) {
        PrintStream sysOut = System.out;
        PrintStream sysErr = System.err;
        try {
            sysOut.flush();
            sysErr.flush();
            this.outBuffer = new StringBuffer();
            PrintStream out = new PrintStream(new AntOutputStream(this.outBuffer));
            System.setOut(out);
            this.errBuffer = new StringBuffer();
            PrintStream err = new PrintStream(new AntOutputStream(this.errBuffer));
            System.setErr(err);
            this.logBuffer = new StringBuffer();
            this.fullLogBuffer = new StringBuffer();
            this.buildException = null;
            this.project.executeTarget(targetName);
        }
        finally {
            System.setOut(sysOut);
            System.setErr(sysErr);
        }
    }

    protected Project getProject() {
        return this.project;
    }

    protected File getProjectDir() {
        return this.project.getBaseDir();
    }

    protected void expectSpecificBuildException(String target, String cause, String msg) {
        try {
            this.executeTarget(target);
        }
        catch (BuildException ex) {
            this.buildException = ex;
            if (null != msg && !ex.getMessage().equals(msg)) {
                Assert.fail((String)("Should throw BuildException because '" + cause + "' with message '" + msg + "' (actual message '" + ex.getMessage() + "' instead)"));
            }
            return;
        }
        Assert.fail((String)("Should throw BuildException because: " + cause));
    }

    protected void expectBuildExceptionContaining(String target, String cause, String contains) {
        try {
            this.executeTarget(target);
        }
        catch (BuildException ex) {
            this.buildException = ex;
            if (null != contains && ex.getMessage().indexOf(contains) == -1) {
                Assert.fail((String)("Should throw BuildException because '" + cause + "' with message containing '" + contains + "' (actual message '" + ex.getMessage() + "' instead)"));
            }
            return;
        }
        Assert.fail((String)("Should throw BuildException because: " + cause));
    }

    protected void expectPropertySet(String target, String property, String value) {
        this.executeTarget(target);
        this.assertPropertyEquals(property, value);
    }

    protected void assertPropertyEquals(String property, String value) {
        String result = this.project.getProperty(property);
        Assert.assertEquals((String)("property " + property), (Object)value, (Object)result);
    }

    protected void assertPropertySet(String property) {
        this.assertPropertyEquals(property, "true");
    }

    protected void assertPropertyUnset(String property) {
        this.assertPropertyEquals(property, null);
    }

    protected void expectPropertySet(String target, String property) {
        this.expectPropertySet(target, property, "true");
    }

    protected void expectPropertyUnset(String target, String property) {
        this.expectPropertySet(target, property, null);
    }

    protected URL getResource(String resource) {
        URL url = this.getClass().getResource(resource);
        Assert.assertNotNull((String)("Could not find resource :" + resource), (Object)url);
        return url;
    }

    private class AntTestListener
    implements BuildListener {
        private int logLevel;

        public AntTestListener(int logLevel) {
            this.logLevel = logLevel;
        }

        public void buildStarted(BuildEvent event) {
        }

        public void buildFinished(BuildEvent event) {
        }

        public void targetStarted(BuildEvent event) {
        }

        public void targetFinished(BuildEvent event) {
        }

        public void taskStarted(BuildEvent event) {
        }

        public void taskFinished(BuildEvent event) {
        }

        public void messageLogged(BuildEvent event) {
            if (event.getPriority() > this.logLevel) {
                return;
            }
            if (event.getPriority() == 2 || event.getPriority() == 1 || event.getPriority() == 0) {
                BuildFileTest.this.logBuffer.append(event.getMessage());
            }
            BuildFileTest.this.fullLogBuffer.append(event.getMessage());
        }
    }

    private static class AntOutputStream
    extends OutputStream {
        private StringBuffer buffer;

        public AntOutputStream(StringBuffer buffer) {
            this.buffer = buffer;
        }

        public void write(int b) {
            this.buffer.append((char)b);
        }
    }
}

