/*
 * Decompiled with CFR 0.152.
 */
package org.drools.contrib;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.tools.ant.BuildException;
import org.drools.KnowledgeBase;
import org.drools.RuleBase;
import org.drools.contrib.BuildFileTest;
import org.drools.core.util.DroolsStreamUtils;
import org.drools.definition.KnowledgePackage;
import org.drools.rule.Package;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DroolsAntTaskTest
extends BuildFileTest {
    @Before
    public void setUp() {
        String path = System.getProperty("eclipsepath");
        if (path == null) {
            System.setProperty("eclipsepath", "../../../");
        }
        this.configureProject("src/test/resources/DroolsAntTask.xml");
    }

    @Test
    public void testVerifierReport() {
        this.executeTarget("verifierreport");
    }

    @Test
    public void testDslRules() throws IOException, ClassNotFoundException {
        this.executeTarget("dslRules");
        Package p1 = (Package)DroolsStreamUtils.streamIn((InputStream)new FileInputStream("target/cheese.rules.pkg"));
        Assert.assertNotNull((Object)p1);
        Assert.assertEquals((long)1L, (long)p1.getRules().length);
    }

    @Test
    public void testDslRulesKnowledge() throws IOException, ClassNotFoundException {
        this.executeTarget("dslRulesKnowledge");
        KnowledgePackage kpackage1 = (KnowledgePackage)DroolsStreamUtils.streamIn((InputStream)new FileInputStream("target/cheese.rules.pkg"));
        Assert.assertNotNull((Object)kpackage1);
        Assert.assertEquals((long)1L, (long)kpackage1.getRules().size());
    }

    @Test
    public void testRules() throws IOException, ClassNotFoundException {
        this.executeTarget("rules");
        RuleBase r1 = (RuleBase)DroolsStreamUtils.streamIn((InputStream)new FileInputStream("target/cheese.rules"));
        Assert.assertNotNull((Object)r1);
        Assert.assertEquals((long)1L, (long)r1.getPackages().length);
    }

    @Test
    public void testRulesKnowledge() throws IOException, ClassNotFoundException {
        this.executeTarget("rulesKnowledge");
        KnowledgeBase kbase = (KnowledgeBase)DroolsStreamUtils.streamIn((InputStream)new FileInputStream("target/cheese.rules"));
        Assert.assertNotNull((Object)kbase);
        Assert.assertEquals((long)1L, (long)kbase.getKnowledgePackages().size());
    }

    @Test
    public void testRuleFlow() throws IOException, ClassNotFoundException {
        this.executeTarget("ruleFlow");
        RuleBase r1 = (RuleBase)DroolsStreamUtils.streamIn((InputStream)new FileInputStream("target/ruleFlow.rules"));
        Assert.assertNotNull((Object)r1);
        Assert.assertEquals((long)1L, (long)r1.getPackages().length);
    }

    @Test
    public void testRuleFlowKnowledge() throws IOException, ClassNotFoundException {
        this.executeTarget("ruleFlowKnowledge");
        KnowledgeBase kbase = (KnowledgeBase)DroolsStreamUtils.streamIn((InputStream)new FileInputStream("target/ruleFlow.rules"));
        Assert.assertNotNull((Object)kbase);
        Assert.assertEquals((long)1L, (long)kbase.getKnowledgePackages().size());
    }

    @Test(expected=BuildException.class)
    public void testNoPackageFile() {
        this.executeTarget("rulesnopackagefile");
    }
}

