/*
 * Decompiled with CFR 0.152.
 */
package org.drools.contrib;

import java.io.File;
import org.apache.jackrabbit.core.RepositoryCopier;
import org.apache.jackrabbit.core.config.RepositoryConfig;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.MatchingTask;

public class JackrabbitMigrationAntTask
extends MatchingTask {
    private String verbose;
    private boolean verboseVal;
    private String sourcedir;
    private String sourceconfig;
    private String targetdir;
    private String targetconfig;

    public void execute() throws BuildException {
        super.execute();
        this.verboseVal = this.verbose != null && this.verbose.equalsIgnoreCase("true");
        String inputErrors = this.checkInput();
        if (inputErrors.length() > 0) {
            throw new BuildException(inputErrors);
        }
        try {
            if (this.verboseVal) {
                this.log("Installing source repository.");
            }
            RepositoryConfig sourceRepo = RepositoryConfig.install((File)new File(this.sourceconfig), (File)new File(this.sourcedir));
            if (this.verboseVal) {
                this.log("Installing target repository.");
            }
            RepositoryConfig targetRepo = RepositoryConfig.install((File)new File(this.targetconfig), (File)new File(this.targetdir));
            if (this.verboseVal) {
                this.log("Migrating source repository to target repository.");
            }
            RepositoryCopier.copy((RepositoryConfig)sourceRepo, (RepositoryConfig)targetRepo);
        }
        catch (Exception e) {
            this.log(e.getMessage());
            throw new BuildException((Throwable)e);
        }
    }

    public void setVerbose(String verbose) {
        this.verbose = verbose;
    }

    private String checkInput() {
        if (this.verboseVal) {
            this.log("Validating task input parameters.");
        }
        String errors = "";
        if (JackrabbitMigrationAntTask.isEmpty(this.sourcedir)) {
            errors = errors + "\nInvalid source repository directory.";
        } else {
            File sourceDirFile = new File(this.sourcedir);
            if (!sourceDirFile.canRead()) {
                errors = errors + "\nInvalid source repository directory.";
            }
        }
        if (JackrabbitMigrationAntTask.isEmpty(this.sourceconfig)) {
            errors = errors + "\nInvalid source source configuration.";
        } else {
            File sourceConfFile = new File(this.sourceconfig);
            if (!sourceConfFile.canRead()) {
                errors = errors + "\nInvalid source repository configuration file.";
            }
        }
        if (JackrabbitMigrationAntTask.isEmpty(this.targetconfig)) {
            errors = errors + "\nInvalid target repository configuration.";
        } else {
            File targetConfFile = new File(this.targetconfig);
            if (!targetConfFile.canRead()) {
                errors = errors + "\nInvalid target repository configuration file.";
            }
        }
        if (JackrabbitMigrationAntTask.isEmpty(this.targetdir)) {
            errors = errors + "\nInvalid target directory configuration.";
        } else {
            File targetDirFile = new File(this.targetdir);
            if (!targetDirFile.canRead()) {
                errors = errors + "\nInvalid target repository directory.";
            }
        }
        return errors;
    }

    public static boolean isEmpty(CharSequence str) {
        if (str == null || str.length() == 0) {
            return true;
        }
        int length = str.length();
        for (int i = 0; i < length; ++i) {
            if (str.charAt(i) == ' ') continue;
            return false;
        }
        return true;
    }

    public void setSourcedir(String sourcedir) {
        this.sourcedir = sourcedir;
    }

    public void setSourceconfig(String sourceconfig) {
        this.sourceconfig = sourceconfig;
    }

    public void setTargetdir(String targetdir) {
        this.targetdir = targetdir;
    }

    public void setTargetconfig(String targetconfig) {
        this.targetconfig = targetconfig;
    }
}

