/*
 * Decompiled with CFR 0.152.
 */
package org.drools.builder;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ResourceType {
    private String name;
    private static final Map<String, ResourceType> CACHE = Collections.synchronizedMap(new HashMap());
    public static final ResourceType DRL = ResourceType.addResourceTypeToRegistry("DRL");
    public static final ResourceType XDRL = ResourceType.addResourceTypeToRegistry("XDRL");
    public static final ResourceType DSL = ResourceType.addResourceTypeToRegistry("DSL");
    public static final ResourceType DSLR = ResourceType.addResourceTypeToRegistry("DSLR");
    public static final ResourceType DRF = ResourceType.addResourceTypeToRegistry("DRF");
    public static final ResourceType DTABLE = ResourceType.addResourceTypeToRegistry("DTABLE");
    public static final ResourceType PKG = ResourceType.addResourceTypeToRegistry("PKG");
    public static final ResourceType BRL = ResourceType.addResourceTypeToRegistry("BRL");
    public static final ResourceType ChangeSet = ResourceType.addResourceTypeToRegistry("ChangeSet");

    public ResourceType(String name) {
        this.name = name;
    }

    public static ResourceType addResourceTypeToRegistry(String resourceType) {
        ResourceType resource = new ResourceType(resourceType);
        CACHE.put(resourceType, resource);
        return resource;
    }

    public static ResourceType getResourceType(String resourceType) {
        ResourceType resource = CACHE.get(resourceType);
        if (resource == null) {
            throw new RuntimeException("Unable to determine resource type " + resourceType);
        }
        return resource;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ResourceType other = (ResourceType)obj;
        return this.name.equals(other.name);
    }
}

