/*
 * Decompiled with CFR 0.152.
 */
package org.drools;

import java.util.Properties;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseConfiguration;
import org.drools.KnowledgeBaseProvider;
import org.drools.ProviderInitializationException;

public class KnowledgeBaseFactory {
    private static KnowledgeBaseProvider provider;

    public static KnowledgeBase newKnowledgeBase() {
        return KnowledgeBaseFactory.getKnowledgeBaseProvider().newKnowledgeBase();
    }

    public static KnowledgeBase newKnowledgeBase(KnowledgeBaseConfiguration conf) {
        return KnowledgeBaseFactory.getKnowledgeBaseProvider().newKnowledgeBase(conf);
    }

    public static KnowledgeBaseConfiguration newKnowledgeBaseConfiguration() {
        return KnowledgeBaseFactory.getKnowledgeBaseProvider().newKnowledgeBaseConfiguration();
    }

    public static KnowledgeBaseConfiguration newKnowledgeBaseConfiguration(Properties properties, ClassLoader classLoader) {
        return KnowledgeBaseFactory.getKnowledgeBaseProvider().newKnowledgeBaseConfiguration(properties, classLoader);
    }

    private static synchronized void setKnowledgeBaseProvider(KnowledgeBaseProvider provider) {
        KnowledgeBaseFactory.provider = provider;
    }

    private static synchronized KnowledgeBaseProvider getKnowledgeBaseProvider() {
        if (provider == null) {
            KnowledgeBaseFactory.loadProvider();
        }
        return provider;
    }

    private static void loadProvider() {
        try {
            Class<?> cls = Class.forName("org.drools.impl.KnowledgeBaseProviderImpl");
            KnowledgeBaseFactory.setKnowledgeBaseProvider((KnowledgeBaseProvider)cls.newInstance());
        }
        catch (Exception e) {
            throw new ProviderInitializationException("Provider org.drools.impl.KnowledgeBaseProviderImpl could not be set.", e);
        }
    }
}

