/*
 * Decompiled with CFR 0.152.
 */
package org.drools.builder;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ResourceType
implements Serializable {
    private String name;
    private String description;
    private String defaultExtension;
    private static final Map<String, ResourceType> CACHE = Collections.synchronizedMap(new HashMap());
    public static final ResourceType DRL = ResourceType.addResourceTypeToRegistry("DRL", "Drools Rule Language", "drl");
    public static final ResourceType XDRL = ResourceType.addResourceTypeToRegistry("XDRL", "Drools XML Rule Language", "xdrl");
    public static final ResourceType DSL = ResourceType.addResourceTypeToRegistry("DSL", "Drools DSL", "dsl");
    public static final ResourceType DSLR = ResourceType.addResourceTypeToRegistry("DSLR", "Drools DSL Rule", "dslr");
    public static final ResourceType DRF = ResourceType.addResourceTypeToRegistry("DRF", "Drools Rule Flow Language", "rf");
    public static final ResourceType DTABLE = ResourceType.addResourceTypeToRegistry("DTABLE", "Decision Table", "xls");
    public static final ResourceType PKG = ResourceType.addResourceTypeToRegistry("PKG", "Binary Package", "pkg");
    public static final ResourceType BRL = ResourceType.addResourceTypeToRegistry("BRL", "Drools Business Rule Language", "brl");
    public static final ResourceType CHANGE_SET = ResourceType.addResourceTypeToRegistry("CHANGE_SET", "Change Set", "xcs");

    public ResourceType(String name, String description, String defaultExtension) {
        this.name = name;
        this.description = description;
        this.defaultExtension = defaultExtension;
    }

    public static ResourceType addResourceTypeToRegistry(String resourceType, String description, String defaultExtension) {
        ResourceType resource = new ResourceType(resourceType, description, defaultExtension);
        CACHE.put(resourceType, resource);
        return resource;
    }

    public static ResourceType getResourceType(String resourceType) {
        ResourceType resource = CACHE.get(resourceType);
        if (resource == null) {
            throw new RuntimeException("Unable to determine resource type " + resourceType);
        }
        return resource;
    }

    public static ResourceType determineResourceType(String resourceName) {
        for (ResourceType type : CACHE.values()) {
            if (!type.matchesExtension(resourceName)) continue;
            return type;
        }
        return null;
    }

    public boolean matchesExtension(String resourceName) {
        return resourceName != null && resourceName.endsWith("." + this.defaultExtension);
    }

    public String toString() {
        return "ResourceType = '" + this.description + "'";
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ResourceType other = (ResourceType)obj;
        return this.name.equals(other.name);
    }
}

