/*
 * Decompiled with CFR 0.152.
 */
package org.drools.camel.component;

import java.net.URISyntaxException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.impl.DefaultExchange;
import org.apache.camel.impl.DefaultMessage;
import org.apache.camel.spi.DataFormat;
import org.drools.camel.component.DroolsComponent;
import org.drools.camel.component.DroolsConsumer;
import org.drools.camel.component.DroolsExecuteProducer;
import org.drools.camel.component.DroolsInsertProducer;
import org.drools.core.command.impl.CommandBasedStatefulKnowledgeSession;
import org.drools.core.impl.KnowledgeBaseImpl;
import org.drools.core.impl.StatefulKnowledgeSessionImpl;
import org.drools.core.impl.StatelessKnowledgeSessionImpl;
import org.drools.core.reteoo.ReteooRuleBase;
import org.drools.core.util.StringUtils;
import org.drools.grid.GridNode;
import org.kie.api.runtime.CommandExecutor;

public class DroolsEndpoint
extends DefaultEndpoint {
    public static final Pattern p = Pattern.compile("[\"']?lookup[\"']?\\s*[:=]\\s*[\"']([^\"']+)[\"']");
    public String ksessionId;
    public CommandExecutor executor;
    public GridNode node;
    public String dataFormatName;
    public DataFormat dataFormat;
    public Action action = Action.EXECUTE;
    public String entryPoint = null;
    public String channel = null;

    public DroolsEndpoint(String endpointUri, String remaining, DroolsComponent component) throws URISyntaxException {
        super(endpointUri, (Component)component);
        this.configure(component, remaining);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        return new DroolsConsumer((Endpoint)this, processor);
    }

    public Producer createProducer() throws Exception {
        if (Action.EXECUTE.equals((Object)this.action)) {
            return new DroolsExecuteProducer((Endpoint)this, this.node);
        }
        return new DroolsInsertProducer((Endpoint)this, this.node);
    }

    public boolean isSingleton() {
        return true;
    }

    public String getKsessionId() {
        return this.ksessionId;
    }

    public void setKsessionId(String ksession) {
        this.ksessionId = ksession;
    }

    public CommandExecutor getExecutor() {
        return this.executor;
    }

    public GridNode getGridNode() {
        return this.node;
    }

    protected void configure(DroolsComponent component, String uri) {
        String nodeId = DroolsEndpoint.getExecuteNodeId(uri);
        this.ksessionId = DroolsEndpoint.getKsessionId(uri);
        if (!StringUtils.isEmpty((CharSequence)nodeId)) {
            this.node = (GridNode)component.getCamelContext().getRegistry().lookup(nodeId, GridNode.class);
            if (this.node == null) {
                throw new RuntimeCamelException("Could not find GridNode for uri=\"" + uri + "\" in CamelContext. Check configuration.");
            }
            if (!StringUtils.isEmpty((CharSequence)this.ksessionId)) {
                this.executor = (CommandExecutor)this.node.get(this.ksessionId, CommandExecutor.class);
                if (this.executor == null) {
                    throw new RuntimeCamelException("Failed to instantiate DroolsEndpoint. Lookup of CommandExecutor with uri=\"" + uri + "\" failed. Check configuration.");
                }
            }
        } else {
            this.executor = (CommandExecutor)component.getCamelContext().getRegistry().lookup(this.ksessionId, CommandExecutor.class);
            if (this.executor == null) {
                throw new RuntimeCamelException("Failed to instantiate DroolsEndpoint. Could not find ksession for  uri=\"" + uri + "\". Check configuration.");
            }
        }
    }

    public static final String getExecuteNodeId(String uri) {
        int pos = uri.indexOf(47);
        return pos < 0 ? uri : uri.substring(0, pos);
    }

    public static final String getKsessionId(String uri) {
        int pos = uri.indexOf(47);
        return pos < 0 ? "" : uri.substring(pos + 1);
    }

    public String getDataFormat() {
        return this.dataFormatName;
    }

    public void setDataFormat(String dataFormatName) {
        this.dataFormatName = dataFormatName;
    }

    public String getLookup(String body) {
        Matcher m = p.matcher(body);
        String name = null;
        if (m.find()) {
            name = m.group(1);
        }
        return name;
    }

    public CommandExecutor getCommandExecutor(String name) {
        if (this.executor != null) {
            return this.executor;
        }
        if (this.node == null) {
            throw new RuntimeException("ExecutionNode for CommandExecutor lookup cannot be null");
        }
        return (CommandExecutor)this.node.get(name, CommandExecutor.class);
    }

    public ClassLoader getClassLoader(CommandExecutor exec) {
        ClassLoader cl = null;
        if (exec instanceof StatefulKnowledgeSessionImpl) {
            cl = ((ReteooRuleBase)((StatefulKnowledgeSessionImpl)exec).getRuleBase()).getRootClassLoader();
        } else if (exec instanceof StatelessKnowledgeSessionImpl) {
            cl = ((ReteooRuleBase)((StatelessKnowledgeSessionImpl)exec).getRuleBase()).getRootClassLoader();
        } else if (exec instanceof CommandBasedStatefulKnowledgeSession) {
            cl = ((ReteooRuleBase)((KnowledgeBaseImpl)((CommandBasedStatefulKnowledgeSession)exec).getKieBase()).getRuleBase()).getRootClassLoader();
        }
        return cl;
    }

    public Action getAction() {
        return this.action;
    }

    public void setAction(Action action) {
        this.action = action;
    }

    public void setAction(String action) {
        this.action = Action.resolveAction(action);
    }

    public String getEntryPoint() {
        return this.entryPoint;
    }

    public void setEntryPoint(String entryPoint) {
        this.entryPoint = entryPoint;
    }

    public String getChannel() {
        return this.channel;
    }

    public void setChannel(String channel) {
        this.channel = channel;
    }

    public Exchange createExchange(Object pojo) {
        DefaultMessage msg = new DefaultMessage();
        msg.setBody(pojo);
        DefaultExchange exchange = new DefaultExchange((Endpoint)this, this.getExchangePattern());
        exchange.setIn((Message)msg);
        return exchange;
    }

    public static enum Action {
        EXECUTE("execute"),
        INSERT_BODY("insertBody"),
        INSERT_MESSAGE("insertMessage"),
        INSERT_EXCHANGE("insertExchange");

        private final String id;

        private Action(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }

        public static Action resolveAction(String id) {
            if (EXECUTE.getId().equalsIgnoreCase(id)) {
                return EXECUTE;
            }
            if (INSERT_BODY.getId().equalsIgnoreCase(id)) {
                return INSERT_BODY;
            }
            if (INSERT_MESSAGE.getId().equalsIgnoreCase(id)) {
                return INSERT_MESSAGE;
            }
            if (INSERT_EXCHANGE.getId().equalsIgnoreCase(id)) {
                return INSERT_EXCHANGE;
            }
            throw new IllegalArgumentException("Invalid action configuring EndPoint = " + id);
        }
    }
}

