/*
 * Decompiled with CFR 0.152.
 */
package org.drools.camel.component;

import com.sun.tools.xjc.Language;
import com.sun.tools.xjc.Options;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import javax.naming.Context;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.apache.camel.CamelContext;
import org.apache.camel.Route;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.DataFormatDefinition;
import org.apache.camel.model.PolicyDefinition;
import org.apache.camel.model.dataformat.JaxbDataFormat;
import org.apache.camel.spi.Policy;
import org.drools.camel.component.DroolsCamelTestSupport;
import org.drools.camel.component.DroolsPolicy;
import org.drools.core.command.runtime.BatchExecutionCommandImpl;
import org.drools.core.command.runtime.GetGlobalCommand;
import org.drools.core.command.runtime.SetGlobalCommand;
import org.drools.core.command.runtime.rule.FireAllRulesCommand;
import org.drools.core.command.runtime.rule.InsertObjectCommand;
import org.drools.core.impl.KnowledgeBaseImpl;
import org.drools.pipeline.camel.Person;
import org.drools.pipeline.camel.WrappedList;
import org.junit.Test;
import org.kie.api.command.Command;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceType;
import org.kie.api.runtime.CommandExecutor;
import org.kie.api.runtime.ExecutionResults;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.internal.KnowledgeBase;
import org.kie.internal.KnowledgeBaseFactoryService;
import org.kie.internal.builder.KnowledgeBuilder;
import org.kie.internal.builder.KnowledgeBuilderFactoryService;
import org.kie.internal.builder.help.KnowledgeBuilderHelper;
import org.kie.internal.io.ResourceFactory;
import org.kie.internal.runtime.StatefulKnowledgeSession;

public class CamelEndpointWithJaxWrapperCollectionTest
extends DroolsCamelTestSupport {
    private String handle;
    private JAXBContext jaxbContext;
    private RouteBuilder routeBuilder;

    @Test
    public void testWorkingSetGlobalTestSessionSetAndGetGlobal() throws Exception {
        BatchExecutionCommandImpl cmd = new BatchExecutionCommandImpl();
        cmd.setLookup("ksession1");
        SetGlobalCommand setGlobal = new SetGlobalCommand("list", (Object)new WrappedList());
        setGlobal.setOutIdentifier("list");
        cmd.getCommands().add(setGlobal);
        cmd.getCommands().add(new InsertObjectCommand((Object)new Person("baunax")));
        cmd.getCommands().add(new FireAllRulesCommand());
        cmd.getCommands().add(new GetGlobalCommand("list"));
        Marshaller marshaller = this.getJaxbContext().createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        StringWriter xml = new StringWriter();
        marshaller.marshal((Object)cmd, (Writer)xml);
        System.out.println(xml.toString());
        byte[] response = (byte[])this.template.requestBody("direct:test-with-session", (Object)xml.toString());
        CamelEndpointWithJaxWrapperCollectionTest.assertNotNull((Object)response);
        System.out.println("response:\n" + new String(response));
        Unmarshaller unmarshaller = this.getJaxbContext().createUnmarshaller();
        ExecutionResults res = (ExecutionResults)unmarshaller.unmarshal((InputStream)new ByteArrayInputStream(response));
        WrappedList resp = (WrappedList)res.getValue("list");
        CamelEndpointWithJaxWrapperCollectionTest.assertNotNull((Object)resp);
        CamelEndpointWithJaxWrapperCollectionTest.assertEquals((long)resp.size(), (long)2L);
        CamelEndpointWithJaxWrapperCollectionTest.assertEquals((Object)"baunax", (Object)resp.get(0).getName());
        CamelEndpointWithJaxWrapperCollectionTest.assertEquals((Object)"Hadrian", (Object)resp.get(1).getName());
    }

    @Override
    protected void configureDroolsContext(Context jndiContext) {
        Person me = new Person();
        me.setName("Hadrian");
        String rule = "";
        rule = rule + "package org.drools.pipeline.camel \n";
        rule = rule + "import org.drools.pipeline.camel.Person\n";
        rule = rule + "import org.drools.pipeline.camel.WrappedList\n";
        rule = rule + "global WrappedList list\n";
        rule = rule + "rule rule1 \n";
        rule = rule + "  when \n";
        rule = rule + "    $p : Person() \n";
        rule = rule + " \n";
        rule = rule + "  then \n";
        rule = rule + "    System.out.println(\"executed\"); \n";
        rule = rule + "    list.add($p); \n";
        rule = rule + "end\n";
        StatefulKnowledgeSession ksession = this.registerKnowledgeRuntime("ksession1", rule);
        InsertObjectCommand cmd = new InsertObjectCommand((Object)me);
        cmd.setOutIdentifier("camel-rider");
        cmd.setReturnObject(false);
        BatchExecutionCommandImpl script = new BatchExecutionCommandImpl(Arrays.asList(cmd));
        ExecutionResults results = (ExecutionResults)ksession.execute((Command)script);
        this.handle = ((FactHandle)results.getFactHandle("camel-rider")).toExternalForm();
    }

    @Override
    protected StatefulKnowledgeSession registerKnowledgeRuntime(String identifier, String rule) {
        KnowledgeBuilder kbuilder = ((KnowledgeBuilderFactoryService)this.node.get(KnowledgeBuilderFactoryService.class)).newKnowledgeBuilder();
        Options xjcOpts = new Options();
        xjcOpts.setSchemaLanguage(Language.XMLSCHEMA);
        try {
            KnowledgeBuilderHelper.addXsdModel((Resource)ResourceFactory.newClassPathResource((String)"person.xsd", ((Object)((Object)this)).getClass()), (KnowledgeBuilder)kbuilder, (Options)xjcOpts, (String)"xsd");
        }
        catch (IOException e) {
            LOG.error("Errors while adding xsd model. ", (Object)kbuilder.getErrors());
        }
        CamelEndpointWithJaxWrapperCollectionTest.assertFalse((boolean)kbuilder.hasErrors());
        if (rule != null && rule.length() > 0) {
            kbuilder.add(ResourceFactory.newByteArrayResource((byte[])rule.getBytes()), ResourceType.DRL);
            if (kbuilder.hasErrors()) {
                LOG.info("Errors while adding rule. ", (Object)kbuilder.getErrors());
            }
        }
        CamelEndpointWithJaxWrapperCollectionTest.assertFalse((boolean)kbuilder.hasErrors());
        KnowledgeBase kbase = ((KnowledgeBaseFactoryService)this.node.get(KnowledgeBaseFactoryService.class)).newKnowledgeBase();
        kbase.addKnowledgePackages(kbuilder.getKnowledgePackages());
        StatefulKnowledgeSession session = kbase.newStatefulKnowledgeSession();
        this.node.set(identifier, (Object)session);
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JAXBContext getJaxbContext() {
        if (this.jaxbContext == null) {
            JaxbDataFormat def = new JaxbDataFormat();
            def.setPrettyPrint(Boolean.valueOf(true));
            def.setContextPath("org.drools.pipeline.camel");
            StatefulKnowledgeSession ksession1 = (StatefulKnowledgeSession)this.node.get("ksession1", CommandExecutor.class);
            KnowledgeBase kbase = ksession1.getKieBase();
            ClassLoader originalCl = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(((KnowledgeBaseImpl)kbase).getRootClassLoader());
                def = DroolsPolicy.augmentJaxbDataFormatDefinition((JaxbDataFormat)def);
                org.apache.camel.converter.jaxb.JaxbDataFormat jaxbDataformat = (org.apache.camel.converter.jaxb.JaxbDataFormat)def.getDataFormat(((Route)this.context.getRoutes().get(0)).getRouteContext());
                jaxbDataformat.setCamelContext((CamelContext)this.routeBuilder.getContext());
                try {
                    jaxbDataformat.start();
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
                this.jaxbContext = jaxbDataformat.getContext();
            }
            finally {
                Thread.currentThread().setContextClassLoader(originalCl);
            }
        }
        return this.jaxbContext;
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        this.routeBuilder = new RouteBuilder(){

            public void configure() throws Exception {
                JaxbDataFormat def = new JaxbDataFormat();
                def.setPrettyPrint(Boolean.valueOf(true));
                def.setContextPath("org.drools.pipeline.camel");
                ((PolicyDefinition)((PolicyDefinition)this.from("direct:test-with-session").policy((Policy)new DroolsPolicy()).unmarshal((DataFormatDefinition)def)).to("drools:node/ksession1")).marshal((DataFormatDefinition)def);
            }
        };
        return this.routeBuilder;
    }
}

