/*
 * Decompiled with CFR 0.152.
 */
package org.drools.camel.component;

import java.util.ArrayList;
import java.util.HashMap;
import javax.naming.Context;
import org.apache.camel.CamelContext;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.model.PolicyDefinition;
import org.apache.camel.spi.Policy;
import org.apache.camel.util.jndi.JndiContext;
import org.drools.KnowledgeBase;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceType;
import org.drools.camel.component.DroolsPolicy;
import org.drools.camel.testdomain.Person;
import org.drools.command.Command;
import org.drools.command.CommandFactory;
import org.drools.grid.GridNode;
import org.drools.grid.impl.GridImpl;
import org.drools.io.ResourceFactory;
import org.drools.runtime.ExecutionResults;
import org.drools.runtime.StatefulKnowledgeSession;
import org.drools.runtime.rule.QueryResults;
import org.junit.Assert;
import org.junit.Test;

public class JsonQueryTest {
    private ProducerTemplate template;

    private CamelContext configure(StatefulKnowledgeSession session) throws Exception {
        GridImpl grid = new GridImpl(new HashMap());
        GridNode node = grid.createGridNode("testnode");
        JndiContext context = new JndiContext();
        context.bind("testnode", (Object)node);
        node.set("ksession", (Object)session);
        DefaultCamelContext camelContext = new DefaultCamelContext((Context)context);
        camelContext.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() throws Exception {
                ((PolicyDefinition)((PolicyDefinition)this.from("direct:test-session").policy((Policy)new DroolsPolicy()).unmarshal("json")).to("drools://testnode/ksession")).marshal("json");
                this.from("direct:unmarshall").policy((Policy)new DroolsPolicy()).unmarshal("json");
                this.from("direct:marshall").policy((Policy)new DroolsPolicy()).marshal("json");
            }
        });
        return camelContext;
    }

    private void initializeTemplate(StatefulKnowledgeSession session) throws Exception {
        CamelContext context = this.configure(session);
        this.template = context.createProducerTemplate();
        context.start();
    }

    private KnowledgeBase getKbase() {
        KnowledgeBuilder kbuilder = KnowledgeBuilderFactory.newKnowledgeBuilder();
        kbuilder.add(ResourceFactory.newClassPathResource((String)"getOlder.drl", this.getClass()), ResourceType.DRL);
        return kbuilder.newKnowledgeBase();
    }

    @Test
    public void testQuery() throws Exception {
        StatefulKnowledgeSession session = this.getKbase().newStatefulKnowledgeSession();
        this.initializeTemplate(session);
        ArrayList<Person> persons = new ArrayList<Person>();
        persons.add(new Person("john", "john", 25));
        persons.add(new Person("sarah", "john", 35));
        session.execute(CommandFactory.newInsertElements(persons));
        Assert.assertEquals((long)2L, (long)session.getFactCount());
        QueryResults results = this.query("people over the age of x", new Object[]{30});
        Assert.assertNotNull((Object)results);
    }

    private QueryResults query(String queryName, Object[] args) {
        Command command = CommandFactory.newQuery((String)"persons", (String)queryName, (Object[])args);
        String queryStr = (String)this.template.requestBody("direct:marshall", (Object)command, String.class);
        String json = (String)this.template.requestBody("direct:test-session", (Object)queryStr, String.class);
        ExecutionResults res = (ExecutionResults)this.template.requestBody("direct:unmarshall", (Object)json);
        return (QueryResults)res.getValue("persons");
    }
}

