/*
 * Decompiled with CFR 0.152.
 */
package org.drools.cdi;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.inject.Inject;
import org.drools.cdi.CDITestRunner;
import org.drools.cdi.kproject.AbstractKnowledgeTest;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.api.cdi.KReleaseId;
import org.kie.api.cdi.KSession;
import org.kie.api.runtime.KieSession;

@RunWith(value=CDITestRunner.class)
public class KieSessionInjectionTest {
    public static AbstractKnowledgeTest helper;
    @Inject
    @KSession
    @KReleaseId(groupId="jar1", artifactId="art1", version="1.0")
    private KieSession defaultKsession;
    @Inject
    @KSession(value="jar1.KSession2")
    @KReleaseId(groupId="jar1", artifactId="art1", version="1.0")
    private KieSession kbase1ksession2v10;
    @Inject
    @KSession(value="jar1.KSession2")
    @KReleaseId(groupId="jar1", artifactId="art1", version="1.1")
    private KieSession kbase1ksession2v11;
    @Inject
    @KSession(value="jar1.KSession2", name="ks1")
    @KReleaseId(groupId="jar1", artifactId="art1", version="1.0")
    private KieSession kbase1ksession2ks1;
    @Inject
    @KSession(value="jar1.KSession2", name="ks2")
    @KReleaseId(groupId="jar1", artifactId="art1", version="1.0")
    private KieSession kbase1ksession2ks2;
    @Inject
    @KSession(value="jar1.KSession2", name="ks2")
    @KReleaseId(groupId="jar1", artifactId="art1", version="1.0")
    private KieSession kbase1ksession2ks22;

    @BeforeClass
    public static void beforeClass() {
        helper = new AbstractKnowledgeTest();
        try {
            helper.setUp();
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        try {
            helper.createKieModule("jar1", true, "1.0");
            helper.createKieModule("jar1", true, "1.1");
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("Unable to build dynamic KieModules:\n" + e.toString()));
        }
        CDITestRunner.setUp(new File[0]);
        CDITestRunner.weld = CDITestRunner.createWeld(KieSessionInjectionTest.class.getName());
        CDITestRunner.container = CDITestRunner.weld.initialize();
    }

    @AfterClass
    public static void afterClass() {
        CDITestRunner.tearDown();
        try {
            helper.tearDown();
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testDynamicKieSessionReleaseId() throws IOException, ClassNotFoundException, InterruptedException {
        this.checkKSession(this.defaultKsession, "1.0");
        this.checkKSession(this.kbase1ksession2v10, "1.0");
        this.checkKSession(this.kbase1ksession2v11, "1.1");
    }

    private void checkKSession(KieSession ksession, String check) {
        Assert.assertNotNull((Object)ksession);
        ArrayList list = new ArrayList();
        ksession.setGlobal("list", list);
        ksession.fireAllRules();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertTrue((boolean)((String)list.get(0)).endsWith(check));
        Assert.assertTrue((boolean)((String)list.get(1)).endsWith(check));
    }

    @Test
    public void testNamedKieSessions() throws IOException, ClassNotFoundException, InterruptedException {
        Assert.assertNotNull((Object)this.kbase1ksession2ks1);
        Assert.assertNotNull((Object)this.kbase1ksession2ks2);
        Assert.assertNotNull((Object)this.kbase1ksession2ks22);
        Assert.assertNotSame((Object)this.kbase1ksession2ks1, (Object)this.kbase1ksession2ks2);
        Assert.assertSame((Object)this.kbase1ksession2ks2, (Object)this.kbase1ksession2ks22);
        ArrayList list = new ArrayList();
        this.kbase1ksession2ks1.setGlobal("list", list);
        this.kbase1ksession2ks1.fireAllRules();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertTrue((boolean)((String)list.get(0)).endsWith("1.0"));
        Assert.assertTrue((boolean)((String)list.get(1)).endsWith("1.0"));
        list = new ArrayList();
        this.kbase1ksession2ks2.setGlobal("list", list);
        this.kbase1ksession2ks2.fireAllRules();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertTrue((boolean)((String)list.get(0)).endsWith("1.0"));
        Assert.assertTrue((boolean)((String)list.get(1)).endsWith("1.0"));
    }
}

