/*
 * Decompiled with CFR 0.152.
 */
package org.drools.cdi;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.inject.Inject;
import org.drools.cdi.CDITestRunner;
import org.drools.cdi.kproject.AbstractKnowledgeTest;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.api.KieServices;
import org.kie.api.cdi.KReleaseId;
import org.kie.api.cdi.KSession;
import org.kie.api.command.KieCommands;
import org.kie.api.runtime.StatelessKieSession;

@RunWith(value=CDITestRunner.class)
public class StatelessKieSessionInjectionTest {
    public static AbstractKnowledgeTest helper;
    @Inject
    @KSession(value="jar1.KSession1")
    @KReleaseId(groupId="jar1", artifactId="art1", version="1.0")
    private StatelessKieSession kbase1ksession1v10;
    @Inject
    @KSession(value="jar1.KSession1")
    @KReleaseId(groupId="jar1", artifactId="art1", version="1.1")
    private StatelessKieSession kbase1ksession1v11;
    @Inject
    @KSession(value="jar1.KSession1", name="sks1")
    @KReleaseId(groupId="jar1", artifactId="art1", version="1.0")
    private StatelessKieSession kbase1ksession1sks1;
    @Inject
    @KSession(value="jar1.KSession1", name="sks2")
    @KReleaseId(groupId="jar1", artifactId="art1", version="1.0")
    private StatelessKieSession kbase1ksession1sks2;
    @Inject
    @KSession(value="jar1.KSession1", name="sks2")
    @KReleaseId(groupId="jar1", artifactId="art1", version="1.0")
    private StatelessKieSession kbase1ksession1sks22;

    @BeforeClass
    public static void beforeClass() {
        helper = new AbstractKnowledgeTest();
        try {
            helper.setUp();
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        try {
            helper.createKieModule("jar1", true, "1.0");
            helper.createKieModule("jar1", true, "1.1");
        }
        catch (Exception e) {
            Assert.fail((String)("Unable to build dynamic KieModules:\n" + e.toString()));
        }
        CDITestRunner.setUp(new File[0]);
        CDITestRunner.weld = CDITestRunner.createWeld(StatelessKieSessionInjectionTest.class.getName());
        CDITestRunner.container = CDITestRunner.weld.initialize();
    }

    @AfterClass
    public static void afterClass() {
        CDITestRunner.tearDown();
        try {
            helper.tearDown();
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testDynamicStatelessKieSessionReleaseId() throws IOException, ClassNotFoundException, InterruptedException {
        Assert.assertNotNull((Object)this.kbase1ksession1v10);
        Assert.assertNotNull((Object)this.kbase1ksession1v10);
        KieCommands cmds = KieServices.Factory.get().getCommands();
        ArrayList list = new ArrayList();
        this.kbase1ksession1v10.setGlobal("list", list);
        this.kbase1ksession1v10.execute(cmds.newFireAllRules());
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertTrue((boolean)((String)list.get(0)).endsWith("1.0"));
        Assert.assertTrue((boolean)((String)list.get(1)).endsWith("1.0"));
        list = new ArrayList();
        this.kbase1ksession1v11.setGlobal("list", list);
        this.kbase1ksession1v11.execute(cmds.newFireAllRules());
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertTrue((boolean)((String)list.get(0)).endsWith("1.1"));
        Assert.assertTrue((boolean)((String)list.get(1)).endsWith("1.1"));
    }

    @Test
    public void testNamedStatelessKieSessions() throws IOException, ClassNotFoundException, InterruptedException {
        Assert.assertNotNull((Object)this.kbase1ksession1sks1);
        Assert.assertNotNull((Object)this.kbase1ksession1sks2);
        Assert.assertNotNull((Object)this.kbase1ksession1sks22);
        Assert.assertNotSame((Object)this.kbase1ksession1sks1, (Object)this.kbase1ksession1sks2);
        Assert.assertSame((Object)this.kbase1ksession1sks2, (Object)this.kbase1ksession1sks22);
        KieCommands cmds = KieServices.Factory.get().getCommands();
        ArrayList list = new ArrayList();
        this.kbase1ksession1sks1.setGlobal("list", list);
        this.kbase1ksession1sks1.execute(cmds.newFireAllRules());
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertTrue((boolean)((String)list.get(0)).endsWith("1.0"));
        Assert.assertTrue((boolean)((String)list.get(1)).endsWith("1.0"));
        list = new ArrayList();
        this.kbase1ksession1sks2.setGlobal("list", list);
        this.kbase1ksession1sks2.execute(cmds.newFireAllRules());
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertTrue((boolean)((String)list.get(0)).endsWith("1.0"));
        Assert.assertTrue((boolean)((String)list.get(1)).endsWith("1.0"));
    }
}

