/*
 * Decompiled with CFR 0.152.
 */
package org.drools.cdi.kproject;

import java.io.File;
import org.assertj.core.api.Assertions;
import org.drools.cdi.kproject.AbstractKnowledgeTest;
import org.drools.compiler.kie.builder.impl.ClasspathKieProject;
import org.drools.compiler.kproject.ReleaseIdImpl;
import org.junit.Test;
import org.kie.api.builder.ReleaseId;

public class ClasspathKieProjectTest
extends AbstractKnowledgeTest {
    private static final String MODULE_JARFILE_NAME = "jar1";
    private static final String MODULE_JARFILE_VERSION = "1.0";
    private static final String MODULE_JARDIR_NAME = "jar2";
    private static final String MODULE_JARDIR_VERSION = "2.0";

    @Test
    public void testParsePomPropertiesFromJarFile() throws Exception {
        this.createKieModule(MODULE_JARFILE_NAME, true, MODULE_JARFILE_VERSION);
        File kModuleFile = this.getFileManager().newFile("jar1-1.0.jar");
        String pomProperties = ClasspathKieProject.getPomProperties((String)kModuleFile.getAbsolutePath());
        this.checkPomProperties(pomProperties, MODULE_JARFILE_NAME, MODULE_JARFILE_VERSION);
    }

    @Test
    public void testParsePomPropertiesFromJarDir() throws Exception {
        this.createKieModule(MODULE_JARDIR_NAME, false, MODULE_JARDIR_VERSION);
        File kModuleDir = this.getFileManager().newFile("jar2-2.0");
        Assertions.assertThat((File)kModuleDir).isNotNull();
        Assertions.assertThat((File)kModuleDir).isDirectory();
        kModuleDir.renameTo(new File(kModuleDir.getAbsolutePath() + ".jar"));
        File kModuleFile = this.getFileManager().newFile("jar2-2.0.jar");
        String pomProperties = ClasspathKieProject.getPomProperties((String)kModuleFile.getAbsolutePath());
        this.checkPomProperties(pomProperties, MODULE_JARDIR_NAME, MODULE_JARDIR_VERSION);
    }

    private void checkPomProperties(String pomProperties, String expectedGroupId, String expectedVersion) {
        Assertions.assertThat((String)pomProperties).isNotNull();
        ReleaseId actualReleaseId = ReleaseIdImpl.fromPropertiesString((String)pomProperties);
        Assertions.assertThat((String)actualReleaseId.getGroupId()).isEqualTo((Object)expectedGroupId);
        Assertions.assertThat((String)actualReleaseId.getVersion()).isEqualTo((Object)expectedVersion);
    }
}

