/*
 * Decompiled with CFR 0.152.
 */
package org.drools.cdi.kproject;

import java.util.List;
import org.drools.compiler.kproject.models.KieBaseModelImpl;
import org.drools.compiler.kproject.models.KieModuleModelImpl;
import org.drools.compiler.kproject.models.KieSessionModelImpl;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.KieServices;
import org.kie.api.builder.model.FileLoggerModel;
import org.kie.api.builder.model.KieBaseModel;
import org.kie.api.builder.model.KieModuleModel;
import org.kie.api.builder.model.KieSessionModel;
import org.kie.api.builder.model.ListenerModel;
import org.kie.api.builder.model.WorkItemHandlerModel;
import org.kie.api.conf.DeclarativeAgendaOption;
import org.kie.api.conf.EqualityBehaviorOption;
import org.kie.api.conf.EventProcessingOption;
import org.kie.api.runtime.conf.BeliefSystemTypeOption;
import org.kie.api.runtime.conf.ClockTypeOption;
import org.kie.internal.builder.conf.LanguageLevelOption;
import org.kie.internal.builder.conf.PropertySpecificOption;

public class KieModuleModelTest {
    @Test
    public void testMarshallingUnmarshalling() {
        KieServices ks = KieServices.Factory.get();
        KieModuleModel kproj = ks.newKieModuleModel().setConfigurationProperty("drools.lang.level", LanguageLevelOption.DRL6_STRICT.toString()).setConfigurationProperty("drools.propertySpecific", PropertySpecificOption.ALWAYS.toString());
        KieBaseModel kieBaseModel1 = kproj.newKieBaseModel("KBase1").setEqualsBehavior(EqualityBehaviorOption.EQUALITY).setEventProcessingMode(EventProcessingOption.STREAM).setDeclarativeAgenda(DeclarativeAgendaOption.ENABLED).addInclude("OtherKBase").addPackage("org.kie.pkg1").addPackage("org.kie.pkg2");
        KieSessionModel ksession1 = kieBaseModel1.newKieSessionModel("KSession1").setType(KieSessionModel.KieSessionType.STATEFUL).setClockType(ClockTypeOption.get((String)"realtime")).setBeliefSystem(BeliefSystemTypeOption.get((String)"jtms")).setFileLogger("drools.log", 10, true).setDefault(true);
        ksession1.newListenerModel("org.domain.FirstInterface", ListenerModel.Kind.AGENDA_EVENT_LISTENER);
        ksession1.newListenerModel("org.domain.SecondInterface", ListenerModel.Kind.RULE_RUNTIME_EVENT_LISTENER).newQualifierModel("MyQualfier2");
        ksession1.newListenerModel("org.domain.ThirdInterface", ListenerModel.Kind.PROCESS_EVENT_LISTENER).newQualifierModel("MyQualfier3").setValue("v1");
        ksession1.newListenerModel("org.domain.FourthInterface", ListenerModel.Kind.AGENDA_EVENT_LISTENER).newQualifierModel("MyQualfier4").addArgument("name1", "xxxx").addArgument("name2", "yyyy");
        ksession1.newWorkItemHandlerModel("name", "org.domain.FifthInterface").newQualifierModel("MyQualfier5").addArgument("name1", "aaa").addArgument("name2", "bbb");
        String xml = kproj.toXML();
        KieModuleModel kprojXml = KieModuleModelImpl.fromXML((String)xml);
        Assert.assertEquals((Object)LanguageLevelOption.DRL6_STRICT.toString(), (Object)kprojXml.getConfigurationProperty("drools.lang.level"));
        Assert.assertEquals((Object)PropertySpecificOption.ALWAYS.toString(), (Object)kprojXml.getConfigurationProperty("drools.propertySpecific"));
        KieBaseModel kieBaseModelXML = (KieBaseModel)kprojXml.getKieBaseModels().get("KBase1");
        Assert.assertSame((Object)kprojXml, (Object)((KieBaseModelImpl)kieBaseModelXML).getKModule());
        Assert.assertEquals((Object)EqualityBehaviorOption.EQUALITY, (Object)kieBaseModelXML.getEqualsBehavior());
        Assert.assertEquals((Object)EventProcessingOption.STREAM, (Object)kieBaseModelXML.getEventProcessingMode());
        Assert.assertEquals((Object)DeclarativeAgendaOption.ENABLED, (Object)kieBaseModelXML.getDeclarativeAgenda());
        Assert.assertFalse((boolean)kieBaseModelXML.isDefault());
        Assert.assertEquals((Object)"org.kie.pkg1", kieBaseModelXML.getPackages().get(0));
        Assert.assertEquals((Object)"org.kie.pkg2", kieBaseModelXML.getPackages().get(1));
        Assert.assertEquals((Object)"OtherKBase", ((KieBaseModelImpl)kieBaseModelXML).getIncludes().iterator().next());
        KieSessionModel kieSessionModelXML = (KieSessionModel)kieBaseModelXML.getKieSessionModels().get("KSession1");
        Assert.assertSame((Object)kieBaseModelXML, (Object)((KieSessionModelImpl)kieSessionModelXML).getKieBaseModel());
        Assert.assertEquals((Object)KieSessionModel.KieSessionType.STATEFUL, (Object)kieSessionModelXML.getType());
        Assert.assertEquals((Object)ClockTypeOption.get((String)"realtime"), (Object)kieSessionModelXML.getClockType());
        Assert.assertEquals((Object)BeliefSystemTypeOption.get((String)"jtms"), (Object)kieSessionModelXML.getBeliefSystem());
        FileLoggerModel fileLogger = kieSessionModelXML.getFileLogger();
        Assert.assertEquals((Object)"drools.log", (Object)fileLogger.getFile());
        Assert.assertEquals((long)10L, (long)fileLogger.getInterval());
        Assert.assertEquals((Object)true, (Object)fileLogger.isThreaded());
        Assert.assertTrue((boolean)kieSessionModelXML.isDefault());
        List listeners = kieSessionModelXML.getListenerModels();
        ListenerModel listener2 = (ListenerModel)listeners.get(0);
        Assert.assertEquals((Object)"org.domain.SecondInterface", (Object)listener2.getType());
        Assert.assertEquals((Object)ListenerModel.Kind.RULE_RUNTIME_EVENT_LISTENER, (Object)listener2.getKind());
        ListenerModel listener1 = (ListenerModel)listeners.get(1);
        Assert.assertEquals((Object)"org.domain.FirstInterface", (Object)listener1.getType());
        Assert.assertEquals((Object)ListenerModel.Kind.AGENDA_EVENT_LISTENER, (Object)listener1.getKind());
        ListenerModel listener4 = (ListenerModel)listeners.get(2);
        Assert.assertEquals((Object)"org.domain.FourthInterface", (Object)listener4.getType());
        Assert.assertEquals((Object)ListenerModel.Kind.AGENDA_EVENT_LISTENER, (Object)listener4.getKind());
        ListenerModel listener3 = (ListenerModel)listeners.get(3);
        Assert.assertEquals((Object)"org.domain.ThirdInterface", (Object)listener3.getType());
        Assert.assertEquals((Object)ListenerModel.Kind.PROCESS_EVENT_LISTENER, (Object)listener3.getKind());
        WorkItemHandlerModel wihm = (WorkItemHandlerModel)kieSessionModelXML.getWorkItemHandlerModels().get(0);
        Assert.assertEquals((Object)"org.domain.FifthInterface", (Object)wihm.getType());
    }
}

