/*
 * Decompiled with CFR 0.152.
 */
package org.drools.cdi;

import java.io.File;
import java.lang.annotation.Annotation;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.SessionScoped;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.util.AnnotationLiteral;
import javax.inject.Inject;
import org.drools.cdi.CDITestRunner;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.api.KieBase;
import org.kie.api.cdi.KBase;
import org.kie.api.cdi.KSession;
import org.kie.api.runtime.KieSession;

@RunWith(value=CDITestRunner.class)
public class CDIScopeTest {
    @Inject
    @KBase(value="org.kie.kbase2")
    private KieBase kBase2;
    @Inject
    @KBase(value="org.kie.kbase3")
    private KieBase kBase3;
    @Inject
    @KSession(value="org.kie.kbase3.ksession1")
    private KieSession kbase3ksession1;
    @Inject
    @KSession(value="org.kie.kbase3.ksession2")
    private KieSession kbase3ksession2;
    @Inject
    BeanManager beanManager;

    @BeforeClass
    public static void beforeClass() {
        CDITestRunner.setUp(new File[0]);
        CDITestRunner.weld = CDITestRunner.createWeld(CDIScopeTest.class.getName());
        CDITestRunner.container = CDITestRunner.weld.initialize();
    }

    @AfterClass
    public static void afterClass() {
        CDITestRunner.tearDown();
    }

    @Test
    public void testKieBaseScope() {
        Set beans = this.beanManager.getBeans(KieBase.class, new Annotation[]{new KBaseLiteral("org.kie.kbase2")});
        Assert.assertEquals((long)1L, (long)beans.size());
        Bean bean1 = beans.toArray(new Bean[1])[0];
        Assert.assertEquals(ApplicationScoped.class, (Object)bean1.getScope());
        beans = this.beanManager.getBeans(KieBase.class, new Annotation[]{new KBaseLiteral("org.kie.kbase3")});
        Assert.assertEquals((long)1L, (long)beans.size());
        bean1 = beans.toArray(new Bean[1])[0];
        Assert.assertEquals(SessionScoped.class, (Object)bean1.getScope());
    }

    @Test
    public void testKieSessionScope() {
        Set beans = this.beanManager.getBeans(KieSession.class, new Annotation[]{new KSessionLiteral("org.kie.kbase3.ksession1")});
        Assert.assertEquals((long)1L, (long)beans.size());
        Bean bean1 = beans.toArray(new Bean[1])[0];
        Assert.assertEquals(ApplicationScoped.class, (Object)bean1.getScope());
        beans = this.beanManager.getBeans(KieSession.class, new Annotation[]{new KSessionLiteral("org.kie.kbase3.ksession2")});
        Assert.assertEquals((long)1L, (long)beans.size());
        bean1 = beans.toArray(new Bean[1])[0];
        Assert.assertEquals(SessionScoped.class, (Object)bean1.getScope());
    }

    public static class KSessionLiteral
    extends AnnotationLiteral<KSession>
    implements KSession {
        private String value;

        public KSessionLiteral(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }

        public String name() {
            return "";
        }
    }

    public static class KBaseLiteral
    extends AnnotationLiteral<KBase>
    implements KBase {
        private String value;

        public KBaseLiteral(String value) {
            this.value = value;
        }

        public String value() {
            return this.value;
        }

        public String name() {
            return "";
        }
    }
}

