/*
 * Decompiled with CFR 0.152.
 */
package org.drools.cdi.kproject;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.drools.cdi.kproject.KPTest;
import org.drools.cdi.kproject.KProjectTestClass;
import org.drools.compiler.commons.jci.compilers.CompilationResult;
import org.drools.compiler.commons.jci.compilers.EclipseJavaCompiler;
import org.drools.compiler.commons.jci.compilers.EclipseJavaCompilerSettings;
import org.drools.compiler.commons.jci.readers.ResourceReader;
import org.drools.compiler.commons.jci.stores.ResourceStore;
import org.drools.compiler.compiler.io.Folder;
import org.drools.compiler.compiler.io.Resource;
import org.drools.compiler.compiler.io.memory.MemoryFile;
import org.drools.compiler.compiler.io.memory.MemoryFileSystem;
import org.drools.compiler.kie.builder.impl.KieFileSystemImpl;
import org.drools.compiler.kie.builder.impl.MemoryKieModule;
import org.drools.compiler.kproject.models.KieModuleModelImpl;
import org.drools.core.util.FileManager;
import org.drools.core.util.IoUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.Message;
import org.kie.api.builder.ReleaseId;
import org.kie.api.builder.model.KieBaseModel;
import org.kie.api.builder.model.KieModuleModel;
import org.kie.api.builder.model.KieSessionModel;
import org.kie.api.cdi.KBase;
import org.kie.api.cdi.KSession;
import org.kie.api.conf.EqualityBehaviorOption;
import org.kie.api.conf.EventProcessingOption;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.StatelessKieSession;
import org.kie.api.runtime.conf.ClockTypeOption;

public class AbstractKnowledgeTest {
    protected FileManager fileManager;

    @Before
    public void setUp() throws Exception {
        this.fileManager = new FileManager();
        this.fileManager.setUp();
    }

    @After
    public void tearDown() throws Exception {
        this.fileManager.tearDown();
    }

    public FileManager getFileManager() {
        return this.fileManager;
    }

    public void testEntry(KProjectTestClass testClass, String jarName) {
        ArrayList list = new ArrayList();
        StatelessKieSession stlsKsession = testClass.getKBase1KSession1();
        stlsKsession.setGlobal("list", list);
        stlsKsession.execute((Object)"dummy");
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertTrue((boolean)list.contains(jarName + ".test1:rule1:1.0-SNAPSHOT"));
        Assert.assertTrue((boolean)list.contains(jarName + ".test1:rule2:1.0-SNAPSHOT"));
        list.clear();
        KieSession stflKsession = testClass.getKBase1KSession2();
        stflKsession.setGlobal("list", list);
        stflKsession.fireAllRules();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertTrue((boolean)list.contains(jarName + ".test1:rule1:1.0-SNAPSHOT"));
        Assert.assertTrue((boolean)list.contains(jarName + ".test1:rule2:1.0-SNAPSHOT"));
        list.clear();
        stflKsession = testClass.getKBase2KSession3();
        stflKsession.setGlobal("list", list);
        stflKsession.fireAllRules();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertTrue((boolean)list.contains(jarName + ".test2:rule1:1.0-SNAPSHOT"));
        Assert.assertTrue((boolean)list.contains(jarName + ".test2:rule2:1.0-SNAPSHOT"));
        list.clear();
        stlsKsession = testClass.getKBase3KSession4();
        stlsKsession.setGlobal("list", list);
        stlsKsession.execute((Object)"dummy");
        Assert.assertEquals((long)4L, (long)list.size());
        Assert.assertTrue((boolean)list.contains(jarName + ".test1:rule1:1.0-SNAPSHOT"));
        Assert.assertTrue((boolean)list.contains(jarName + ".test1:rule2:1.0-SNAPSHOT"));
        Assert.assertTrue((boolean)list.contains(jarName + ".test2:rule1:1.0-SNAPSHOT"));
        Assert.assertTrue((boolean)list.contains(jarName + ".test2:rule2:1.0-SNAPSHOT"));
    }

    public KieModuleModel createKieModule(String namespace, boolean createJar) throws IOException, ClassNotFoundException, InterruptedException {
        return this.createKieModule(namespace, createJar, "1.0-SNAPSHOT");
    }

    public KieModuleModel createKieModule(String namespace, boolean createJar, String version) throws IOException, ClassNotFoundException, InterruptedException {
        KieModuleModelImpl kproj = new KieModuleModelImpl();
        KieBaseModel kieBaseModel1 = kproj.newKieBaseModel(namespace + ".KBase1").setEqualsBehavior(EqualityBehaviorOption.EQUALITY).setEventProcessingMode(EventProcessingOption.STREAM).addPackage(namespace + ".test1").setDefault(true);
        kieBaseModel1.newKieSessionModel(namespace + ".KSession1").setType(KieSessionModel.KieSessionType.STATELESS).setClockType(ClockTypeOption.get((String)"realtime")).setDefault(true);
        kieBaseModel1.newKieSessionModel(namespace + ".KSession2").setType(KieSessionModel.KieSessionType.STATEFUL).setClockType(ClockTypeOption.get((String)"pseudo"));
        kieBaseModel1.newKieSessionModel(namespace + ".KSessionDefault").setType(KieSessionModel.KieSessionType.STATEFUL).setClockType(ClockTypeOption.get((String)"pseudo")).setDefault(true);
        KieBaseModel kieBaseModel2 = kproj.newKieBaseModel(namespace + ".KBase2").setEqualsBehavior(EqualityBehaviorOption.IDENTITY).addPackage(namespace + ".test2").setEventProcessingMode(EventProcessingOption.CLOUD);
        kieBaseModel2.newKieSessionModel(namespace + ".KSession3").setType(KieSessionModel.KieSessionType.STATEFUL).setClockType(ClockTypeOption.get((String)"pseudo"));
        KieBaseModel kieBaseModel3 = kproj.newKieBaseModel(namespace + ".KBase3").addInclude(kieBaseModel1.getName()).addInclude(kieBaseModel2.getName()).setEqualsBehavior(EqualityBehaviorOption.IDENTITY).setEventProcessingMode(EventProcessingOption.CLOUD);
        kieBaseModel3.newKieSessionModel(namespace + ".KSession4").setType(KieSessionModel.KieSessionType.STATELESS).setClockType(ClockTypeOption.get((String)"pseudo"));
        KieServices ks = KieServices.Factory.get();
        KieFileSystemImpl kfs = (KieFileSystemImpl)ks.newKieFileSystem();
        kfs.write("src/main/resources/META-INF/beans.xml", AbstractKnowledgeTest.generateBeansXML());
        kfs.writeKModuleXML(kproj.toXML());
        ReleaseId releaseId = ks.newReleaseId(namespace, "art1", version);
        kfs.generateAndWritePomXML(releaseId);
        String kBase1R1 = this.getRule(namespace + ".test1", "rule1", version);
        String kBase1R2 = this.getRule(namespace + ".test1", "rule2", version);
        String kbase2R1 = this.getRule(namespace + ".test2", "rule1", version);
        String kbase2R2 = this.getRule(namespace + ".test2", "rule2", version);
        String fldKB1 = "src/main/resources/" + (namespace + ".test1").replace('.', '/');
        String fldKB2 = "src/main/resources/" + (namespace + ".test2").replace('.', '/');
        kfs.write(fldKB1 + "/rule1.drl", kBase1R1.getBytes());
        kfs.write(fldKB1 + "/rule2.drl", kBase1R2.getBytes());
        kfs.write(fldKB2 + "/rule1.drl", kbase2R1.getBytes());
        kfs.write(fldKB2 + "/rule2.drl", kbase2R2.getBytes());
        kfs.write("src/main/java/org/drools/compiler/cdi/test/KProjectTestClass" + namespace + ".java", this.generateKProjectTestClass((KieModuleModel)kproj, namespace));
        KieBuilder kBuilder = ks.newKieBuilder((KieFileSystem)kfs);
        kBuilder.buildAll();
        if (kBuilder.getResults().hasMessages(new Message.Level[]{Message.Level.ERROR})) {
            Assert.fail((String)("should not have errors" + kBuilder.getResults()));
        }
        MemoryKieModule kieModule = (MemoryKieModule)kBuilder.getKieModule();
        MemoryFileSystem trgMfs = kieModule.getMemoryFileSystem();
        if (createJar) {
            trgMfs.writeAsJar(this.fileManager.getRootDirectory(), namespace + "-" + version);
        } else {
            File file = this.fileManager.newFile(namespace + "-" + version);
            trgMfs.writeAsFs(file);
        }
        return kproj;
    }

    public String getRule(String packageName, String ruleName, String version) {
        String s = "package " + packageName + "\nglobal java.util.List list;\nrule " + ruleName + " when \nthen \n  list.add(\"" + packageName + ":" + ruleName + ":" + version + "\"); end \n";
        return s;
    }

    public static String generateBeansXML() {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<beans xmlns=\"http://java.sun.com/xml/ns/javaee\"  xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"  xsi:schemaLocation=\"http://java.sun.com/xml/ns/javaee http://java.sun.com/xml/ns/javaee/beans_1_0.xsd\">\n</beans>";
    }

    public String generateKProjectTestClass(KieModuleModel kproject, String namespace) {
        return "package org.drools.compiler.cdi.test;\nimport javax.inject.Named;\nimport javax.inject.Inject;\nimport javax.inject.Inject;\nimport javax.enterprise.event.Observes;\nimport org.jboss.weld.environment.se.events.ContainerInitialized;\nimport " + KieBase.class.getName() + ";\nimport " + KieSession.class.getName() + ";\nimport " + StatelessKieSession.class.getName() + ";\nimport " + KBase.class.getName() + ";\nimport " + KSession.class.getName() + ";\nimport " + KPTest.class.getName() + ";\nimport " + KProjectTestClass.class.getName() + ";\n@KPTest(\"" + namespace + "\") \npublic class KProjectTestClass" + namespace + " implements KProjectTestClass {\n    private @Inject @KBase(\"" + namespace + ".KBase1\")      KieBase kBase1; \n    public KieBase getKBase1() {\n        return kBase1;\n    }\n    private @Inject @KBase(\"" + namespace + ".KBase2\")     KieBase kBase2; \n    public KieBase getKBase2() {\n        return kBase2;\n    }\n    private @Inject @KBase(\"" + namespace + ".KBase3\") \n    KieBase kBase3; \n    public KieBase getKBase3() {\n        return kBase3;\n    }\n    private @Inject @KSession(\"" + namespace + ".KSession1\") StatelessKieSession kBase1kSession1; \n    public StatelessKieSession getKBase1KSession1() {\n        return kBase1kSession1;\n    }\n    private @Inject @KSession(\"" + namespace + ".KSession2\") KieSession kBase1kSession2; \n    public KieSession getKBase1KSession2() {\n        return kBase1kSession2;\n    }\n    private @Inject @KSession(\"" + namespace + ".KSession3\") KieSession kBase2kSession3; \n    public KieSession getKBase2KSession3() {\n        return kBase2kSession3;\n    }\n    private @Inject @KSession(\"" + namespace + ".KSession4\") StatelessKieSession kBase3kSession4; \n    public StatelessKieSession getKBase3KSession4() {\n        return kBase3kSession4;\n    }\n}\n";
    }

    public List<String> compile(KieModuleModel kproj, MemoryFileSystem srcMfs, MemoryFileSystem trgMfs, List<String> classes) {
        for (KieBaseModel kbase : kproj.getKieBaseModels().values()) {
            Folder srcFolder = srcMfs.getFolder("src/main/resources/" + kbase.getName());
            Folder trgFolder = trgMfs.getFolder(kbase.getName());
            this.copyFolder(srcMfs, srcFolder, trgMfs, trgFolder, kproj);
        }
        Folder srcFolder = srcMfs.getFolder("META-INF");
        Folder trgFolder = trgMfs.getFolder("META-INF");
        trgFolder.create();
        this.copyFolder(srcMfs, srcFolder, trgMfs, trgFolder, kproj);
        EclipseJavaCompilerSettings settings = new EclipseJavaCompilerSettings();
        settings.setSourceVersion("1.5");
        settings.setTargetVersion("1.5");
        EclipseJavaCompiler compiler = new EclipseJavaCompiler(settings, "");
        CompilationResult res = compiler.compile(classes.toArray(new String[classes.size()]), (ResourceReader)trgMfs, (ResourceStore)trgMfs);
        if (res.getErrors().length > 0) {
            Assert.fail((String)res.getErrors()[0].getMessage());
        }
        ArrayList<String> classes2 = new ArrayList<String>(classes.size());
        for (String str : classes) {
            classes2.add(AbstractKnowledgeTest.filenameToClassname(str));
        }
        return classes2;
    }

    public static String filenameToClassname(String filename) {
        return filename.substring(0, filename.lastIndexOf(".java")).replace('/', '.').replace('\\', '.');
    }

    public void copyFolder(MemoryFileSystem srcMfs, Folder srcFolder, MemoryFileSystem trgMfs, Folder trgFolder, KieModuleModel kproj) {
        Collection col;
        if (!trgFolder.exists()) {
            trgMfs.getFolder(trgFolder.getPath()).create();
        }
        if ((col = srcFolder.getMembers()) == null) {
            return;
        }
        for (Resource rs : col) {
            if (rs instanceof Folder) {
                this.copyFolder(srcMfs, (Folder)rs, trgMfs, trgFolder.getFolder(((Folder)rs).getName()), kproj);
                continue;
            }
            MemoryFile trgFile = (MemoryFile)trgFolder.getFile(((org.drools.compiler.compiler.io.File)rs).getName());
            try {
                trgMfs.setFileContents(trgFile, srcMfs.getFileContents((MemoryFile)rs));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void writeFs(String outFilename, MemoryFileSystem mfs) {
        File file = this.fileManager.newFile(outFilename);
        file.mkdir();
        this.writeFs(mfs, mfs.getRootFolder(), file);
    }

    public void writeFs(MemoryFileSystem mfs, Folder f, File file1) {
        for (Resource rs : f.getMembers()) {
            if (rs instanceof Folder) {
                File file2 = new File(file1, ((Folder)rs).getName());
                file2.mkdir();
                this.writeFs(mfs, (Folder)rs, file2);
                continue;
            }
            byte[] bytes = mfs.getFileContents((MemoryFile)rs);
            try {
                IoUtils.write((File)new File(file1, ((org.drools.compiler.compiler.io.File)rs).getName()), (byte[])bytes);
            }
            catch (IOException e) {
                Assert.fail((String)("Unable to write project to file system\n" + e.getMessage()));
            }
        }
    }
}

