/*
 * Decompiled with CFR 0.152.
 */
package org.drools.cdi.kproject;

import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.Enumeration;
import java.util.Set;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.util.AnnotationLiteral;
import org.drools.cdi.CDITestRunner;
import org.drools.cdi.kproject.AbstractKnowledgeTest;
import org.drools.cdi.kproject.KPTest;
import org.drools.cdi.kproject.KProjectTestClass;
import org.drools.compiler.kie.builder.impl.KieServicesImpl;
import org.drools.core.rule.JavaDialectRuntimeData;
import org.jboss.weld.environment.se.Weld;
import org.jboss.weld.environment.se.WeldContainer;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.KieServices;

public class KieProjectCDITest
extends AbstractKnowledgeTest {
    private static final ProtectionDomain PROTECTION_DOMAIN = (ProtectionDomain)AccessController.doPrivileged(new PrivilegedAction(){

        public Object run() {
            return JavaDialectRuntimeData.class.getProtectionDomain();
        }
    });

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void createMultpleJarAndFileResources() throws IOException, ClassNotFoundException, InterruptedException {
        this.createKieModule("jar1", true);
        this.createKieModule("jar2", true);
        this.createKieModule("jar3", true);
        this.createKieModule("fol4", false);
        ClassLoader origCl = Thread.currentThread().getContextClassLoader();
        try {
            File file1 = this.fileManager.newFile("jar1-1.0-SNAPSHOT.jar");
            File file2 = this.fileManager.newFile("jar2-1.0-SNAPSHOT.jar");
            File file3 = this.fileManager.newFile("jar3-1.0-SNAPSHOT.jar");
            File fol4 = this.fileManager.newFile("fol4-1.0-SNAPSHOT");
            URLClassLoader urlClassLoader = new URLClassLoader(new URL[]{file1.toURI().toURL(), file2.toURI().toURL(), file3.toURI().toURL(), fol4.toURI().toURL()});
            Thread.currentThread().setContextClassLoader(urlClassLoader);
            Enumeration<URL> e = urlClassLoader.getResources("META-INF/kmodule.xml");
            while (e.hasMoreElements()) {
                URL url = e.nextElement();
                System.out.println(url);
            }
            Class<?> cls = Thread.currentThread().getContextClassLoader().loadClass("org.drools.compiler.cdi.test.KProjectTestClassjar1");
            Assert.assertNotNull(cls);
            cls = Thread.currentThread().getContextClassLoader().loadClass("org.drools.compiler.cdi.test.KProjectTestClassjar2");
            Assert.assertNotNull(cls);
            cls = Thread.currentThread().getContextClassLoader().loadClass("org.drools.compiler.cdi.test.KProjectTestClassjar3");
            Assert.assertNotNull(cls);
            Weld weld = CDITestRunner.createWeld(KProjectTestClass.class.getName(), KPTestLiteral.class.getName(), "org.drools.compiler.cdi.test.KProjectTestClassjar1", "org.drools.compiler.cdi.test.KProjectTestClassjar2", "org.drools.compiler.cdi.test.KProjectTestClassjar3", "org.drools.compiler.cdi.test.KProjectTestClassfol4");
            ((KieServicesImpl)KieServices.Factory.get()).nullKieClasspathContainer();
            WeldContainer container = weld.initialize();
            Set beans = container.getBeanManager().getBeans(KProjectTestClass.class, new Annotation[]{new KPTestLiteral("jar1")});
            Bean bean = (Bean)beans.toArray()[0];
            KProjectTestClass o1 = (KProjectTestClass)bean.create(container.getBeanManager().createCreationalContext(null));
            Assert.assertNotNull((Object)o1);
            this.testEntry(o1, "jar1");
            beans = container.getBeanManager().getBeans(KProjectTestClass.class, new Annotation[]{new KPTestLiteral("jar2")});
            bean = (Bean)beans.toArray()[0];
            KProjectTestClass o2 = (KProjectTestClass)bean.create(container.getBeanManager().createCreationalContext(null));
            Assert.assertNotNull((Object)o2);
            this.testEntry(o2, "jar2");
            beans = container.getBeanManager().getBeans(KProjectTestClass.class, new Annotation[]{new KPTestLiteral("jar3")});
            bean = (Bean)beans.toArray()[0];
            KProjectTestClass o3 = (KProjectTestClass)bean.create(container.getBeanManager().createCreationalContext(null));
            Assert.assertNotNull((Object)o3);
            this.testEntry(o3, "jar3");
            beans = container.getBeanManager().getBeans(KProjectTestClass.class, new Annotation[]{new KPTestLiteral("fol4")});
            bean = (Bean)beans.toArray()[0];
            KProjectTestClass o4 = (KProjectTestClass)bean.create(container.getBeanManager().createCreationalContext(null));
            Assert.assertNotNull((Object)o4);
            this.testEntry(o4, "fol4");
            weld.shutdown();
        }
        finally {
            Thread.currentThread().setContextClassLoader(origCl);
        }
    }

    public static class KPTestLiteral
    extends AnnotationLiteral<KPTest>
    implements KPTest {
        private String value;

        public KPTestLiteral(String value) {
            this.value = value;
        }

        @Override
        public String value() {
            return this.value;
        }
    }
}

