/*
 * Decompiled with CFR 0.152.
 */
package org.drools.cdi;

import java.io.IOException;
import java.util.ArrayList;
import javax.inject.Inject;
import org.drools.cdi.CDITestRunner;
import org.drools.cdi.kproject.AbstractKnowledgeTest;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.api.KieBase;
import org.kie.api.cdi.KReleaseId;
import org.kie.api.runtime.KieSession;

@RunWith(value=CDITestRunner.class)
public class KieBaseDefaultInjectionTest {
    public static AbstractKnowledgeTest helper;
    @Inject
    private KieBase defaultClassPathKBase;
    @Inject
    @KReleaseId(groupId="jar1", artifactId="art1", version="1.0")
    private KieBase defaultDynamicKBase;

    @BeforeClass
    public static void beforeClass() {
        helper = new AbstractKnowledgeTest();
        try {
            helper.setUp();
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        try {
            helper.createKieModule("jar1", true, "1.0");
            helper.createKieModule("jar2", true, "2.0");
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("Unable to build dynamic KieModules:\n" + e.toString()));
        }
        CDITestRunner.setUp(helper.getFileManager().newFile("jar2-2.0.jar"));
        CDITestRunner.weld = CDITestRunner.createWeld(KieBaseDefaultInjectionTest.class.getName());
        CDITestRunner.container = CDITestRunner.weld.initialize();
    }

    @AfterClass
    public static void afterClass() {
        CDITestRunner.tearDown();
        try {
            helper.tearDown();
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void tessDefaultClassPathKBase() throws IOException, ClassNotFoundException, InterruptedException {
        Assert.assertNotNull((Object)this.defaultClassPathKBase);
        KieSession kSession = this.defaultClassPathKBase.newKieSession();
        ArrayList list = new ArrayList();
        kSession.setGlobal("list", list);
        kSession.fireAllRules();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertTrue((boolean)((String)list.get(0)).endsWith("2.0"));
        Assert.assertTrue((boolean)((String)list.get(1)).endsWith("2.0"));
    }

    @Test
    public void tessDefaultDynamicKBase() throws IOException, ClassNotFoundException, InterruptedException {
        Assert.assertNotNull((Object)this.defaultDynamicKBase);
        KieSession kSession = this.defaultDynamicKBase.newKieSession();
        ArrayList list = new ArrayList();
        kSession.setGlobal("list", list);
        kSession.fireAllRules();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertTrue((boolean)((String)list.get(0)).endsWith("1.0"));
        Assert.assertTrue((boolean)((String)list.get(1)).endsWith("1.0"));
    }
}

