/*
 * Decompiled with CFR 0.152.
 */
package org.drools.cdi;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.inject.Inject;
import org.drools.cdi.CDITestRunner;
import org.drools.cdi.kproject.AbstractKnowledgeTest;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.api.KieBase;
import org.kie.api.cdi.KBase;
import org.kie.api.cdi.KReleaseId;
import org.kie.api.runtime.KieSession;

@RunWith(value=CDITestRunner.class)
public class KieBaseInjectionTest {
    public static AbstractKnowledgeTest helper;
    @Inject
    @KBase
    @KReleaseId(groupId="jar1", artifactId="art1", version="1.0")
    private KieBase defaultKBase;
    @Inject
    @KBase(value="jar1.KBase1")
    @KReleaseId(groupId="jar1", artifactId="art1", version="1.0")
    private KieBase jar1KBase1v10;
    @Inject
    @KBase(value="jar1.KBase1")
    @KReleaseId(groupId="jar1", artifactId="art1", version="1.1")
    private KieBase jar1KBase1v11;
    @Inject
    @KBase(value="jar1.KBase1", name="kb1")
    @KReleaseId(groupId="jar1", artifactId="art1", version="1.0")
    private KieBase jar1KBase1kb1;
    @Inject
    @KBase(value="jar1.KBase1", name="kb2")
    @KReleaseId(groupId="jar1", artifactId="art1", version="1.0")
    private KieBase jar1KBase1kb2;
    @Inject
    @KBase(value="jar1.KBase1", name="kb2")
    @KReleaseId(groupId="jar1", artifactId="art1", version="1.0")
    private KieBase jar1KBase1kb22;

    @BeforeClass
    public static void beforeClass() {
        helper = new AbstractKnowledgeTest();
        try {
            helper.setUp();
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        try {
            helper.createKieModule("jar1", true, "1.0");
            helper.createKieModule("jar1", true, "1.1");
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("Unable to build dynamic KieModules:\n" + e.toString()));
        }
        CDITestRunner.setUp(new File[0]);
        CDITestRunner.weld = CDITestRunner.createWeld(KieBaseInjectionTest.class.getName());
        CDITestRunner.container = CDITestRunner.weld.initialize();
    }

    @AfterClass
    public static void afterClass() {
        CDITestRunner.tearDown();
        try {
            helper.tearDown();
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testDynamicKieBaseReleaseId() throws IOException, ClassNotFoundException, InterruptedException {
        this.checkKBase(this.defaultKBase, "1.0");
        this.checkKBase(this.jar1KBase1v10, "1.0");
        this.checkKBase(this.jar1KBase1v11, "1.1");
    }

    private void checkKBase(KieBase kBase, String check) {
        Assert.assertNotNull((Object)kBase);
        KieSession kSession = kBase.newKieSession();
        ArrayList list = new ArrayList();
        kSession.setGlobal("list", list);
        kSession.fireAllRules();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertTrue((boolean)((String)list.get(0)).endsWith(check));
        Assert.assertTrue((boolean)((String)list.get(1)).endsWith(check));
    }

    @Test
    public void testNamedKieBases() throws IOException, ClassNotFoundException, InterruptedException {
        Assert.assertNotNull((Object)this.jar1KBase1kb1);
        Assert.assertNotNull((Object)this.jar1KBase1kb2);
        Assert.assertNotNull((Object)this.jar1KBase1kb22);
        Assert.assertNotSame((Object)this.jar1KBase1kb1, (Object)this.jar1KBase1kb2);
        Assert.assertSame((Object)this.jar1KBase1kb2, (Object)this.jar1KBase1kb22);
        KieSession kSession = this.jar1KBase1kb1.newKieSession();
        ArrayList list = new ArrayList();
        kSession.setGlobal("list", list);
        kSession.fireAllRules();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertTrue((boolean)((String)list.get(0)).endsWith("1.0"));
        Assert.assertTrue((boolean)((String)list.get(1)).endsWith("1.0"));
        kSession = this.jar1KBase1kb2.newKieSession();
        list = new ArrayList();
        kSession.setGlobal("list", list);
        kSession.fireAllRules();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertTrue((boolean)((String)list.get(0)).endsWith("1.0"));
        Assert.assertTrue((boolean)((String)list.get(1)).endsWith("1.0"));
    }
}

