/*
 * Decompiled with CFR 0.152.
 */
package org.drools.cdi;

import java.io.IOException;
import java.util.ArrayList;
import javax.inject.Inject;
import org.drools.cdi.CDITestRunner;
import org.drools.cdi.kproject.AbstractKnowledgeTest;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.api.KieServices;
import org.kie.api.cdi.KReleaseId;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSession;

@RunWith(value=CDITestRunner.class)
public class KieContainerInjectionTest {
    public static AbstractKnowledgeTest helper;
    @Inject
    private KieContainer kContainer;
    @Inject
    @KReleaseId(groupId="jar1", artifactId="art1", version="1.1")
    private KieContainer kContainerv11;

    @BeforeClass
    public static void beforeClass() {
        helper = new AbstractKnowledgeTest();
        try {
            helper.setUp();
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
        try {
            helper.createKieModule("jar1", true, "1.0");
            helper.createKieModule("jar1", true, "1.1");
            helper.createKieModule("jar2", true, "2.0");
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)("Unable to build dynamic KieModules:\n" + e.toString()));
        }
        CDITestRunner.setUp(helper.getFileManager().newFile("jar2-2.0.jar"));
        CDITestRunner.weld = CDITestRunner.createWeld(KieContainerInjectionTest.class.getName());
        CDITestRunner.container = CDITestRunner.weld.initialize();
    }

    @AfterClass
    public static void afterClass() {
        CDITestRunner.tearDown();
        try {
            helper.tearDown();
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    public void testDefaultKieContainer() throws IOException, ClassNotFoundException, InterruptedException {
        Assert.assertSame((Object)this.kContainer, (Object)KieServices.Factory.get().getKieClasspathContainer());
        KieSession kSession = this.kContainer.newKieSession("jar2.KSession2");
        ArrayList list = new ArrayList();
        kSession.setGlobal("list", list);
        kSession.fireAllRules();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertTrue((boolean)((String)list.get(0)).endsWith("2.0"));
        Assert.assertTrue((boolean)((String)list.get(1)).endsWith("2.0"));
    }

    @Test
    public void testDynamicKieContainerWithReleaseId() throws IOException, ClassNotFoundException, InterruptedException {
        Assert.assertNotSame((Object)this.kContainerv11, (Object)KieServices.Factory.get().getKieClasspathContainer());
        KieSession kSession = this.kContainerv11.newKieSession("jar1.KSession2");
        ArrayList list = new ArrayList();
        kSession.setGlobal("list", list);
        kSession.fireAllRules();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertTrue((boolean)((String)list.get(0)).endsWith("1.1"));
        Assert.assertTrue((boolean)((String)list.get(1)).endsWith("1.1"));
    }
}

