/*
 * Decompiled with CFR 0.152.
 */
package org.drools.cdi.example;

import java.io.File;
import javax.inject.Inject;
import org.drools.cdi.CDITestRunner;
import org.drools.cdi.example.Message;
import org.drools.cdi.example.Message2;
import org.drools.cdi.example.Message2Impl1;
import org.drools.cdi.example.Message2Impl2;
import org.drools.cdi.example.MessageImpl;
import org.drools.cdi.example.MessageProducers;
import org.drools.cdi.example.MessageProducers2;
import org.drools.cdi.example.Msg;
import org.drools.cdi.example.Msg1;
import org.drools.cdi.example.Msg2;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=CDITestRunner.class)
public class CDIExamplesTest {
    @Inject
    private Message defaultMsg;
    @Inject
    @Msg1
    private Message2 m1;
    @Inject
    @Msg2
    private Message2 m2;
    @Inject
    @Msg1
    private String msg1;
    @Inject
    @Msg2
    private String msg2;
    @Inject
    @Msg(value="named1")
    private String msgNamed1;
    @Inject
    @Msg(value="named2")
    private String msgNamed2;
    @Inject
    @Msg(value="chained1")
    private String msgChained1;
    @Inject
    @Msg(value="chained2")
    private String msgChained2;

    @BeforeClass
    public static void beforeClass() {
        CDITestRunner.setUp(new File[0]);
        CDITestRunner.weld = CDITestRunner.createWeld(CDIExamplesTest.class.getName(), Msg.class.getName(), Msg1.class.getName(), Msg2.class.getName(), Message.class.getName(), MessageImpl.class.getName(), Message2.class.getName(), Message2Impl1.class.getName(), Message2Impl2.class.getName(), MessageProducers.class.getName(), MessageProducers2.class.getName());
        CDITestRunner.container = CDITestRunner.weld.initialize();
    }

    @AfterClass
    public static void afterClass() {
        CDITestRunner.tearDown();
    }

    @Test
    public void testDefaultInjection() {
        Assert.assertEquals((Object)"default.msg", (Object)this.defaultMsg.getText());
    }

    @Test
    public void testSimpleQualifiedInjection() {
        Assert.assertEquals((Object)"msg.1", (Object)this.msg1);
        Assert.assertEquals((Object)"msg.2", (Object)this.msg2);
    }

    @Test
    public void testQualiferWithValueInjection() {
        Assert.assertEquals((Object)"msg.named1", (Object)this.msgNamed1);
        Assert.assertEquals((Object)"msg.named2", (Object)this.msgNamed2);
    }

    @Test
    public void testChained1Injection() {
        Assert.assertEquals((Object)"chained.1 msg.1", (Object)this.msgChained1);
    }

    @Test
    public void testChained2Injection() {
        Assert.assertEquals((Object)"chained.2 default.msg msg.1 msg.named1", (Object)this.msgChained2);
    }

    @Test
    public void testNoProducers() {
        Assert.assertEquals((Object)"msg2 - 1", (Object)this.m1.getText());
        Assert.assertEquals((Object)"msg2 - 2", (Object)this.m2.getText());
    }
}

