/*
 * Decompiled with CFR 0.152.
 */
package org.drools.cdi.kproject;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.concurrent.atomic.AtomicInteger;
import org.drools.cdi.kproject.AbstractKnowledgeTest;
import org.drools.cdi.kproject.KProjectTestClassImpl;
import org.drools.compiler.kie.builder.impl.InternalKieServices;
import org.drools.compiler.kie.builder.impl.event.AbstractKieServicesEventListerner;
import org.drools.compiler.kie.builder.impl.event.KieModuleDiscovered;
import org.drools.compiler.kie.builder.impl.event.KieServicesEventListerner;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.KieServices;
import org.kie.api.runtime.KieContainer;

public class KieProjectDefaultClasspathTest
extends AbstractKnowledgeTest {
    private KieServicesEventListerner listener;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void createMultpleJarAndFileResources() throws IOException, ClassNotFoundException, InterruptedException {
        this.createKieModule("jar1", true);
        this.createKieModule("jar2", true);
        this.createKieModule("jar3", true);
        this.createKieModule("fol4", false);
        ClassLoader origCl = Thread.currentThread().getContextClassLoader();
        try {
            File file1 = this.fileManager.newFile("jar1-1.0-SNAPSHOT.jar");
            File file2 = this.fileManager.newFile("jar2-1.0-SNAPSHOT.jar");
            File file3 = this.fileManager.newFile("jar3-1.0-SNAPSHOT.jar");
            File fol4 = this.fileManager.newFile("fol4-1.0-SNAPSHOT");
            URLClassLoader urlClassLoader = new URLClassLoader(new URL[]{file1.toURI().toURL(), file2.toURI().toURL(), file3.toURI().toURL(), fol4.toURI().toURL()});
            Thread.currentThread().setContextClassLoader(urlClassLoader);
            Class<?> cls = Thread.currentThread().getContextClassLoader().loadClass("org.drools.compiler.cdi.test.KProjectTestClassjar1");
            Assert.assertNotNull(cls);
            cls = Thread.currentThread().getContextClassLoader().loadClass("org.drools.compiler.cdi.test.KProjectTestClassjar2");
            Assert.assertNotNull(cls);
            cls = Thread.currentThread().getContextClassLoader().loadClass("org.drools.compiler.cdi.test.KProjectTestClassjar3");
            Assert.assertNotNull(cls);
            InternalKieServices ks = (InternalKieServices)KieServices.Factory.get();
            final AtomicInteger kieModulesCounter = new AtomicInteger(0);
            this.listener = new AbstractKieServicesEventListerner(){

                public void onKieModuleDiscovered(KieModuleDiscovered event) {
                    if (!event.getKieModuleUrl().contains("test-classes") && !event.getKieModuleUrl().contains("drools-compiler")) {
                        kieModulesCounter.incrementAndGet();
                    }
                }
            };
            ks.registerListener(this.listener);
            KieContainer kContainer = ks.newKieClasspathContainer();
            Assert.assertEquals((long)4L, (long)kieModulesCounter.get());
            this.testEntry(new KProjectTestClassImpl("jar1", kContainer), "jar1");
            this.testEntry(new KProjectTestClassImpl("jar2", kContainer), "jar2");
            this.testEntry(new KProjectTestClassImpl("jar3", kContainer), "jar3");
            this.testEntry(new KProjectTestClassImpl("fol4", kContainer), "fol4");
        }
        finally {
            Thread.currentThread().setContextClassLoader(origCl);
        }
    }
}

