/*
 * Decompiled with CFR 0.152.
 */
package org.drools.cdi.kproject;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.stream.Collectors;
import org.drools.cdi.kproject.AbstractKnowledgeTest;
import org.drools.cdi.kproject.KProjectTestClassImpl;
import org.drools.compiler.kie.builder.impl.FileKieModule;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.drools.compiler.kie.builder.impl.KieContainerImpl;
import org.drools.compiler.kie.builder.impl.KieModuleKieProject;
import org.drools.compiler.kie.builder.impl.KieProject;
import org.drools.compiler.kie.builder.impl.ZipKieModule;
import org.drools.core.impl.KnowledgeBaseImpl;
import org.drools.core.util.IoUtils;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.builder.ReleaseId;
import org.kie.api.builder.model.KieModuleModel;
import org.kie.api.runtime.KieContainer;

public class KieProjectRuntimeModulesTest
extends AbstractKnowledgeTest {
    @Test
    public void createMultpleJarAndFileResources() throws IOException, ClassNotFoundException, InterruptedException {
        KieModuleModel kProjModel1 = this.createKieModule("jar1", true);
        KieModuleModel kProjModel2 = this.createKieModule("jar2", true);
        KieModuleModel kProjModel3 = this.createKieModule("jar3", true);
        KieModuleModel kProjModel4 = this.createKieModule("fol4", false);
        ReleaseId releaseId1 = KieServices.Factory.get().newReleaseId("jar1", "art1", "1.0-SNAPSHOT");
        ReleaseId releaseId2 = KieServices.Factory.get().newReleaseId("jar2", "art1", "1.0-SNAPSHOT");
        ReleaseId releaseId3 = KieServices.Factory.get().newReleaseId("jar3", "art1", "1.0-SNAPSHOT");
        ReleaseId releaseId4 = KieServices.Factory.get().newReleaseId("fol4", "art1", "1.0-SNAPSHOT");
        File file1 = this.fileManager.newFile("jar1-1.0-SNAPSHOT.jar");
        File file2 = this.fileManager.newFile("jar2-1.0-SNAPSHOT.jar");
        File file3 = this.fileManager.newFile("jar3-1.0-SNAPSHOT.jar");
        File fol4 = this.fileManager.newFile("fol4-1.0-SNAPSHOT");
        ZipKieModule mod1 = new ZipKieModule(releaseId1, kProjModel1, file1);
        ZipKieModule mod2 = new ZipKieModule(releaseId2, kProjModel2, file2);
        ZipKieModule mod3 = new ZipKieModule(releaseId3, kProjModel3, file3);
        FileKieModule mod4 = new FileKieModule(releaseId4, kProjModel4, fol4);
        mod1.addKieDependency((InternalKieModule)mod2);
        mod1.addKieDependency((InternalKieModule)mod3);
        mod1.addKieDependency((InternalKieModule)mod4);
        KieModuleKieProject kProject = new KieModuleKieProject((InternalKieModule)mod1);
        KieContainerImpl kContainer = new KieContainerImpl((KieProject)kProject, null);
        KieBase kBase = kContainer.getKieBase("jar1.KBase1");
        ClassLoader cl = ((KnowledgeBaseImpl)kBase).getRootClassLoader();
        Class<?> cls = cl.loadClass("org.drools.compiler.cdi.test.KProjectTestClassjar1");
        Assert.assertNotNull(cls);
        cls = cl.loadClass("org.drools.compiler.cdi.test.KProjectTestClassjar2");
        Assert.assertNotNull(cls);
        cls = cl.loadClass("org.drools.compiler.cdi.test.KProjectTestClassjar3");
        Assert.assertNotNull(cls);
        this.testEntry(new KProjectTestClassImpl("jar1", (KieContainer)kContainer), "jar1");
        this.testEntry(new KProjectTestClassImpl("jar2", (KieContainer)kContainer), "jar2");
        this.testEntry(new KProjectTestClassImpl("jar3", (KieContainer)kContainer), "jar3");
        this.testEntry(new KProjectTestClassImpl("fol4", (KieContainer)kContainer), "fol4");
    }

    @Test
    public void createModuleAndFindResources() throws IOException, ClassNotFoundException, InterruptedException {
        this.createKieModule("fol4", false);
        ReleaseId releaseId = KieServices.Factory.get().newReleaseId("fol4", "art1", "1.0-SNAPSHOT");
        KieContainer kieContainer = KieServices.Factory.get().newKieContainer(releaseId);
        Assert.assertNotNull((Object)kieContainer);
        InputStream is = kieContainer.getClassLoader().getResourceAsStream("/META-INF/beans.xml");
        Assert.assertNotNull((Object)is);
        byte[] bytesFromStream = IoUtils.readBytesFromInputStream((InputStream)is);
        Enumeration<URL> foundResources = kieContainer.getClassLoader().getResources("/META-INF/beans.xml");
        Assert.assertNotNull(foundResources);
        ArrayList<URL> resourcesAsList = Collections.list(foundResources);
        Assert.assertNotNull(resourcesAsList);
        Assert.assertEquals((long)1L, (long)resourcesAsList.size());
        URL resourceUrl = (URL)resourcesAsList.get(0);
        byte[] bytesFromURL = IoUtils.readBytesFromInputStream((InputStream)resourceUrl.openStream());
        Assert.assertTrue((boolean)Arrays.equals(bytesFromStream, bytesFromURL));
        String url = resourceUrl.toString();
        Assert.assertNotNull((Object)url);
        Assert.assertEquals((Object)"mfs:/META-INF/beans.xml", (Object)url);
        String file = resourceUrl.getFile();
        Assert.assertNotNull((Object)file);
        Assert.assertEquals((Object)"/META-INF/beans.xml", (Object)file);
    }

    @Test
    public void createModuleAndFindResourcesVerifyURL() throws IOException, ClassNotFoundException, InterruptedException {
        this.createKieModule("fol4", false);
        ReleaseId releaseId = KieServices.Factory.get().newReleaseId("fol4", "art1", "1.0-SNAPSHOT");
        KieContainer kieContainer = KieServices.Factory.get().newKieContainer(releaseId);
        Assert.assertNotNull((Object)kieContainer);
        InputStream is = kieContainer.getClassLoader().getResourceAsStream("META-INF/beans.xml");
        Assert.assertNotNull((Object)is);
        byte[] bytesFromStream = IoUtils.readBytesFromInputStream((InputStream)is);
        Enumeration<URL> foundResources = kieContainer.getClassLoader().getResources("META-INF/beans.xml");
        Assert.assertNotNull(foundResources);
        List resourcesAsList = Collections.list(foundResources).stream().filter(url -> !url.toString().contains("drools-cdi")).collect(Collectors.toList());
        Assert.assertNotNull(resourcesAsList);
        Assert.assertEquals((long)1L, (long)resourcesAsList.size());
        URL resourceUrl = (URL)resourcesAsList.get(0);
        byte[] bytesFromURL = IoUtils.readBytesFromInputStream((InputStream)resourceUrl.openStream());
        Assert.assertTrue((boolean)Arrays.equals(bytesFromStream, bytesFromURL));
        String url2 = resourceUrl.toString();
        Assert.assertNotNull((Object)url2);
        Assert.assertEquals((Object)"mfs:/META-INF/beans.xml", (Object)url2);
        String file = resourceUrl.getFile();
        Assert.assertNotNull((Object)file);
        Assert.assertEquals((Object)"/META-INF/beans.xml", (Object)file);
    }
}

