/*
 * Decompiled with CFR 0.152.
 */
package org.drools.cdi;

import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import javax.enterprise.inject.spi.Extension;
import org.drools.cdi.KieCDIExtension;
import org.drools.compiler.kie.builder.impl.KieContainerImpl;
import org.drools.compiler.kie.builder.impl.KieRepositoryImpl;
import org.drools.compiler.kie.builder.impl.KieServicesImpl;
import org.drools.core.command.impl.CommandFactoryServiceImpl;
import org.drools.core.io.impl.ResourceFactoryServiceImpl;
import org.drools.core.util.FileManager;
import org.jboss.weld.environment.se.Weld;
import org.jboss.weld.environment.se.WeldContainer;
import org.junit.Assert;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.InitializationError;
import org.kie.api.KieServices;
import org.kie.api.builder.KieRepository;
import org.kie.api.cdi.KBase;
import org.kie.api.cdi.KReleaseId;
import org.kie.api.cdi.KSession;
import org.kie.api.command.KieCommands;
import org.kie.api.runtime.KieContainer;

public class CDITestRunner
extends BlockJUnit4ClassRunner {
    public static volatile Weld weld;
    public static volatile WeldContainer container;
    public static volatile FileManager fileManager;
    public static volatile ClassLoader origCl;

    public static void setUp(File ... files) {
        fileManager = new FileManager();
        fileManager.setUp();
        origCl = Thread.currentThread().getContextClassLoader();
        ((KieServicesImpl)KieServices.Factory.get()).nullKieClasspathContainer();
        try {
            ArrayList<URL> urls = new ArrayList<URL>();
            if (files != null && files.length > 0) {
                for (File file : files) {
                    urls.add(file.toURI().toURL());
                }
            }
            URLClassLoader urlClassLoader = new URLClassLoader(urls.toArray(new URL[urls.size()]), Thread.currentThread().getContextClassLoader());
            Thread.currentThread().setContextClassLoader(urlClassLoader);
        }
        catch (MalformedURLException e) {
            Assert.fail((String)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void tearDown() {
        try {
            if (weld != null) {
                weld.shutdown();
                weld = null;
            }
            if (container != null) {
                container = null;
            }
        }
        finally {
            try {
                try {
                    ((URLClassLoader)Thread.currentThread().getContextClassLoader()).close();
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to close custom URLClassLoader (this is a test error)!", e);
                }
                Thread.currentThread().setContextClassLoader(origCl);
            }
            finally {
                fileManager.tearDown();
            }
        }
    }

    public CDITestRunner(Class cls) throws InitializationError {
        super(cls);
    }

    protected Object createTest() throws Exception {
        return container.instance().select(this.getTestClass().getJavaClass(), new Annotation[0]).get();
    }

    public static Weld createWeld(String ... classes) {
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(Arrays.asList(classes));
        list.add(KieCDIExtension.class.getName());
        list.add(KBase.class.getName());
        list.add(KSession.class.getName());
        list.add(KReleaseId.class.getName());
        list.add(KieServices.class.getName());
        list.add(KieServicesImpl.class.getName());
        list.add(KieContainer.class.getName());
        list.add(KieContainerImpl.class.getName());
        list.add(KieRepository.class.getName());
        list.add(KieRepositoryImpl.class.getName());
        list.add(KieCommands.class.getName());
        list.add(CommandFactoryServiceImpl.class.getName());
        list.add(ResourceFactoryServiceImpl.class.getName());
        Weld weld = new Weld();
        ArrayList classList = new ArrayList();
        for (String className : list) {
            try {
                Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(className);
                classList.add(clazz);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        weld.beanClasses(classList.toArray(new Class[0]));
        weld.addExtension((Extension)new KieCDIExtension());
        weld.disableDiscovery();
        return weld;
    }
}

