/*
 * Decompiled with CFR 0.152.
 */
package org.drools.commands;

import java.util.Arrays;
import java.util.List;
import org.drools.commands.fluent.Batch;
import org.drools.commands.fluent.BatchImpl;
import org.drools.commands.fluent.InternalExecutable;
import org.drools.commands.impl.NotTransactionalCommand;
import org.junit.Assert;
import org.junit.Test;
import org.kie.api.command.Command;
import org.kie.api.command.ExecutableCommand;
import org.kie.api.runtime.Context;

public class InternalExecutableTest {
    @Test
    public void notTransactionalCommandTest() {
        BatchImpl batch = new BatchImpl();
        batch.addCommand((Command)new TransactionalCommandTest());
        batch.addCommand((Command)new NotTransactionalCommandTest());
        InternalExecutableImplTest internalExecutableImplTest = new InternalExecutableImplTest(new Batch[]{batch});
        Assert.assertFalse((boolean)internalExecutableImplTest.canRunInTransaction());
    }

    @Test
    public void transactionalCommandTest() {
        BatchImpl batch = new BatchImpl();
        batch.addCommand((Command)new TransactionalCommandTest());
        batch.addCommand((Command)new TransactionalCommandTest());
        InternalExecutableImplTest internalExecutableImplTest = new InternalExecutableImplTest(new Batch[]{batch});
        Assert.assertTrue((boolean)internalExecutableImplTest.canRunInTransaction());
    }

    @Test
    public void emptyCommandTest() {
        BatchImpl batch = new BatchImpl();
        InternalExecutableImplTest internalExecutableImplTest = new InternalExecutableImplTest(new Batch[]{batch});
        Assert.assertTrue((boolean)internalExecutableImplTest.canRunInTransaction());
    }

    class InternalExecutableImplTest
    implements InternalExecutable {
        private final List<Batch> batches;

        public List<Batch> getBatches() {
            return this.batches;
        }

        InternalExecutableImplTest(Batch ... batches) {
            this.batches = Arrays.asList(batches);
        }
    }

    class NotTransactionalCommandTest
    implements NotTransactionalCommand<Void> {
        NotTransactionalCommandTest() {
        }

        public Void execute(Context context) {
            return null;
        }
    }

    class TransactionalCommandTest
    implements ExecutableCommand<Void> {
        TransactionalCommandTest() {
        }

        public Void execute(Context context) {
            return null;
        }
    }
}

