/*
 * Decompiled with CFR 0.152.
 */
package org.drools.commands;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.drools.commands.ConversationContextManager;
import org.drools.commands.impl.ContextImpl;
import org.drools.commands.runtime.ExecutionResultImpl;
import org.kie.api.KieBase;
import org.kie.api.runtime.Context;
import org.kie.api.runtime.ExecutionResults;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.RequestContext;
import org.kie.internal.command.ContextManager;

public class RequestContextImpl
extends ContextImpl
implements RequestContext {
    private Context appContext;
    private Context conversationContext;
    private ConversationContextManager cvnManager;
    private Map<String, Object> output = new HashMap<String, Object>();
    private Object result;
    private String lastSet;
    private Exception exception;

    public RequestContextImpl() {
        this.register(ExecutionResults.class, new ExecutionResultImpl());
    }

    public RequestContextImpl(long requestId, ContextManager ctxManager, ConversationContextManager cvnManager) {
        super(Long.toString(requestId), ctxManager);
        this.cvnManager = cvnManager;
        this.register(ExecutionResults.class, new ExecutionResultImpl());
    }

    public Context getApplicationContext() {
        return this.appContext;
    }

    public void setApplicationContext(Context appContext) {
        this.appContext = appContext;
    }

    public Context getConversationContext() {
        return this.conversationContext;
    }

    public void setConversationContext(Context conversationContext) {
        this.conversationContext = conversationContext;
    }

    public ConversationContextManager getConversationManager() {
        return this.cvnManager;
    }

    @Override
    public Object get(String identifier) {
        if (identifier == null || identifier.equals("")) {
            return null;
        }
        Object object = null;
        if (this.has(identifier)) {
            object = super.get(identifier);
        } else if (this.conversationContext != null && this.conversationContext.has(identifier)) {
            object = this.conversationContext.get(identifier);
        } else if (this.appContext != null && this.appContext.has(identifier)) {
            object = this.appContext.get(identifier);
        }
        return object;
    }

    public Object getResult() {
        return this.result;
    }

    public void setResult(Object result) {
        this.result = result;
    }

    public RequestContext with(KieBase kieBase) {
        this.register(KieBase.class, kieBase);
        return this;
    }

    public RequestContext with(KieSession kieSession) {
        this.register(KieSession.class, kieSession);
        return this;
    }

    public String getLastSet() {
        return this.lastSet;
    }

    public void setLastSetOrGet(String lastSet) {
        this.lastSet = lastSet;
    }

    public Map<String, Object> getOutputs() {
        return Collections.unmodifiableMap(this.output);
    }

    public void setOutput(String identifier, Object value) {
        this.output.put(identifier, value);
    }

    public void removeOutput(String identifier) {
        this.output.remove(identifier);
    }

    public Exception getException() {
        return this.exception;
    }

    public void setException(Exception exception) {
        this.exception = exception;
    }

    @Override
    public String toString() {
        return "ContextImpl{name='" + this.getName() + '\'' + '}';
    }
}

