/*
 * Decompiled with CFR 0.152.
 */
package org.drools.commands;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Random;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.drools.commands.runtime.rule.GetFactHandlesCommand;
import org.drools.core.common.InternalFactHandle;
import org.drools.kiesession.rulebase.InternalKnowledgeBase;
import org.drools.kiesession.rulebase.KnowledgeBaseFactory;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.kie.api.command.Command;
import org.kie.api.runtime.Context;
import org.kie.api.runtime.ExecutableRunner;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.internal.command.RegistryContext;

public class GetFactHandlesCommandTest {
    private KieSession ksession;
    private ExecutableRunner runner;
    private Context context;
    private Random random = new Random();

    @Before
    public void setup() {
        InternalKnowledgeBase kbase = KnowledgeBaseFactory.newKnowledgeBase();
        this.ksession = kbase.newKieSession();
        this.runner = ExecutableRunner.create();
        this.context = ((RegistryContext)this.runner.createContext()).register(KieSession.class, (Object)this.ksession);
    }

    @After
    public void cleanUp() {
        this.ksession.dispose();
    }

    @Test
    public void getEmptyFactHandlesTest() {
        GetFactHandlesCommand command = new GetFactHandlesCommand();
        Object result = this.runner.execute((Command)command, this.context);
        if (result instanceof Collection) {
            Assertions.assertThat((Object)result).isNotNull();
            Assertions.assertThat((boolean)((Collection)result).isEmpty()).isTrue();
        } else {
            Assertions.fail((String)"result of command was NOT a collection of FactHandles");
        }
    }

    @Test
    public void getOneFactHandleTest() {
        String randomFact = "" + this.random.nextLong();
        this.ksession.insert((Object)randomFact);
        GetFactHandlesCommand command = new GetFactHandlesCommand();
        Object result = this.runner.execute((Command)command, this.context);
        this.verifyThatCollectionContains1FactHandleWithThisFact(randomFact, result);
    }

    @Test
    public void getMultipleFactHandleTest() {
        HashSet<String> factSet = new HashSet<String>();
        int numFacts = 4;
        for (int i = 0; i < numFacts; ++i) {
            factSet.add("" + this.random.nextInt());
        }
        for (String fact : factSet) {
            this.ksession.insert((Object)fact);
        }
        GetFactHandlesCommand command = new GetFactHandlesCommand();
        Object result = this.runner.execute((Command)command, this.context);
        this.verifyThatCollectionContainsTheseFactHandle(factSet, result);
    }

    @Test
    public void getEmptyDisconnectedFactHandlesTest() {
        GetFactHandlesCommand command = new GetFactHandlesCommand(true);
        Object result = this.runner.execute((Command)command, this.context);
        if (result instanceof Collection) {
            Assertions.assertThat((Object)result).isNotNull();
            Assertions.assertThat((boolean)((Collection)result).isEmpty()).isTrue();
        } else {
            Assertions.fail((String)"result of command was NOT a collection of FactHandles");
        }
    }

    @Test
    public void getOneDisconnectedFactHandleTest() {
        System.out.println(Thread.currentThread().getStackTrace()[1].getMethodName());
        String randomFact = "" + this.random.nextLong();
        this.ksession.insert((Object)randomFact);
        GetFactHandlesCommand command = new GetFactHandlesCommand(false);
        Object result = this.runner.execute((Command)command, this.context);
        this.verifyThatCollectionContains1FactHandleWithThisFact(randomFact, result);
        FactHandle factHandle = (FactHandle)((Collection)result).toArray()[0];
        command = new GetFactHandlesCommand(false);
        result = this.runner.execute((Command)command, this.context);
        this.verifyThatCollectionContains1FactHandleWithThisFact(randomFact, result);
        FactHandle connectedFactHandle = (FactHandle)((Collection)result).toArray()[0];
        command = new GetFactHandlesCommand(true);
        result = this.runner.execute((Command)command, this.context);
        this.verifyThatCollectionContains1FactHandleWithThisFact(randomFact, result);
        FactHandle disconnectedFactHandle = (FactHandle)((Collection)result).toArray()[0];
        Assertions.assertThat((factHandle == connectedFactHandle ? 1 : 0) != 0).isTrue();
        Assertions.assertThat((factHandle != disconnectedFactHandle ? 1 : 0) != 0).isTrue();
    }

    @Test
    public void getMultipleDisconnectedFactHandleTest() {
        int i;
        System.out.println("\nTest: " + Thread.currentThread().getStackTrace()[1].getMethodName());
        HashSet<String> factSet = new HashSet<String>();
        int numFacts = 4;
        for (int i2 = 0; i2 < numFacts; ++i2) {
            factSet.add("" + this.random.nextInt());
        }
        for (String fact : factSet) {
            this.ksession.insert((Object)fact);
        }
        GetFactHandlesCommand command = new GetFactHandlesCommand(false);
        Object result = this.runner.execute((Command)command, this.context);
        this.verifyThatCollectionContainsTheseFactHandle(factSet, result);
        Collection factHandles = (Collection)result;
        command = new GetFactHandlesCommand(false);
        result = this.runner.execute((Command)command, this.context);
        this.verifyThatCollectionContainsTheseFactHandle(factSet, result);
        Collection connectedFactHandles = (Collection)result;
        command = new GetFactHandlesCommand(true);
        result = this.runner.execute((Command)command, this.context);
        this.verifyThatCollectionContainsTheseFactHandle(factSet, result);
        Collection disconnectedFactHandles = (Collection)result;
        HashSet factHandlesCopy = new HashSet(factHandles);
        for (i = 0; i < connectedFactHandles.size(); ++i) {
            for (Object connectedFact : connectedFactHandles) {
                Iterator iter = factHandlesCopy.iterator();
                while (iter.hasNext()) {
                    Object fact = iter.next();
                    if (fact != connectedFact) continue;
                    iter.remove();
                }
            }
        }
        Assertions.assertThat((boolean)factHandlesCopy.isEmpty()).isTrue();
        for (i = 0; i < disconnectedFactHandles.size(); ++i) {
            for (Object disconnectedFact : disconnectedFactHandles) {
                for (Object fact : factHandles) {
                    Assertions.assertThat((fact != disconnectedFact ? 1 : 0) != 0).isTrue();
                }
            }
        }
        Assertions.assertThat((factHandles.size() == disconnectedFactHandles.size() ? 1 : 0) != 0).isTrue();
    }

    private void verifyThatCollectionContains1FactHandleWithThisFact(String fact, Object collection) {
        if (collection instanceof Collection) {
            Collection factHandles = null;
            try {
                factHandles = (Collection)collection;
            }
            catch (Exception e) {
                Assertions.fail((String)("Collection was not a Colleciton<FactHandle> " + e.getMessage()));
            }
            Assertions.assertThat((!factHandles.isEmpty() ? 1 : 0) != 0).isTrue();
            Assertions.assertThat((factHandles.size() == 1 ? 1 : 0) != 0).isTrue();
            InternalFactHandle factHandle = (InternalFactHandle)factHandles.toArray()[0];
            Assertions.assertThat((boolean)fact.equals(factHandle.getObject())).isTrue();
        } else {
            Assertions.fail((String)"result of command was NOT a collection of FactHandles");
        }
    }

    private void verifyThatCollectionContainsTheseFactHandle(HashSet<String> factSet, Object collection) {
        factSet = (HashSet)factSet.clone();
        if (collection instanceof Collection) {
            Collection factHandles = (Collection)collection;
            Assertions.assertThat((!factHandles.isEmpty() ? 1 : 0) != 0).isTrue();
            ((AbstractBooleanAssert)Assertions.assertThat((factHandles.size() == factSet.size() ? 1 : 0) != 0).as(factSet.size() + "inserted but only " + factHandles.size() + " facts retrieved", new Object[0])).isTrue();
            Object[] internalFactHandles = factHandles.toArray();
            for (int i = 0; i < internalFactHandles.length; ++i) {
                Object factObject = ((InternalFactHandle)internalFactHandles[i]).getObject();
                Assertions.assertThat((boolean)factSet.contains(factObject)).isTrue();
                factSet.remove(factObject);
            }
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)factSet.isEmpty()).as("Additional facts found that weren't inserted.", new Object[0])).isTrue();
        } else {
            Assertions.fail((String)"result of command was NOT a collection of FactHandles");
        }
    }
}

