/*
 * Decompiled with CFR 0.152.
 */
package org.drools.brms.server.rules;

import java.util.ArrayList;
import junit.framework.TestCase;
import org.drools.brms.client.modeldriven.SuggestionCompletionEngine;
import org.drools.brms.server.rules.SuggestionCompletionLoader;

public class SuggestionCompletionLoaderTest
extends TestCase {
    static /* synthetic */ Class class$java$lang$Object;

    public void testSuggestionCompLoader() throws Exception {
        SuggestionCompletionLoader loader = new SuggestionCompletionLoader();
        SuggestionCompletionEngine eng = loader.getSuggestionEngine("package foo \n import org.drools.Person", new ArrayList(), new ArrayList());
        SuggestionCompletionLoaderTest.assertNotNull((Object)eng);
    }

    public void testLoadDifferentFieldTypes() throws Exception {
        SuggestionCompletionLoader loader = new SuggestionCompletionLoader();
        SuggestionCompletionEngine eng = loader.getSuggestionEngine("package foo \n import org.drools.brms.server.rules.SomeFact", new ArrayList(), new ArrayList());
        SuggestionCompletionLoaderTest.assertNotNull((Object)eng);
        SuggestionCompletionLoaderTest.assertEquals((String)"Numeric", (String)eng.getFieldType("SomeFact", "age"));
        SuggestionCompletionLoaderTest.assertEquals((String)"String", (String)eng.getFieldType("SomeFact", "likes"));
        SuggestionCompletionLoaderTest.assertEquals((String)"String", (String)eng.getFieldType("SomeFact", "name"));
        SuggestionCompletionLoaderTest.assertEquals((String)"Numeric", (String)eng.getFieldType("SomeFact", "bigDecimal"));
        SuggestionCompletionLoaderTest.assertEquals((String)"Comparable", (String)eng.getFieldType("SomeFact", "date"));
        SuggestionCompletionLoaderTest.assertEquals((String)"Object", (String)eng.getFieldType("SomeFact", "cheese"));
        SuggestionCompletionLoaderTest.assertEquals((String)"Boolean", (String)eng.getFieldType("SomeFact", "dead"));
        SuggestionCompletionLoaderTest.assertEquals((String)"Boolean", (String)eng.getFieldType("SomeFact", "alive"));
    }

    public void testGlobal() throws Exception {
        SuggestionCompletionLoader loader = new SuggestionCompletionLoader();
        SuggestionCompletionEngine eng = loader.getSuggestionEngine("package foo \n global org.drools.Person p", new ArrayList(), new ArrayList());
        SuggestionCompletionLoaderTest.assertNotNull((Object)eng);
        SuggestionCompletionLoaderTest.assertFalse((boolean)loader.hasErrors());
        SuggestionCompletionLoaderTest.assertEquals((int)1, (int)eng.getGlobalVariables().length);
        SuggestionCompletionLoaderTest.assertEquals((String)"p", (String)eng.getGlobalVariables()[0]);
        SuggestionCompletionLoaderTest.assertEquals((Object)"Person", eng.globalTypes.get("p"));
    }

    public void testSortOrderOfFields() throws Exception {
        SuggestionCompletionLoader loader = new SuggestionCompletionLoader();
        SuggestionCompletionEngine eng = loader.getSuggestionEngine("package foo \n import org.drools.brms.server.rules.SomeFact", new ArrayList(), new ArrayList());
        SuggestionCompletionLoaderTest.assertNotNull((Object)eng);
        String[] fields = eng.getFieldCompletions("SomeFact");
        SuggestionCompletionLoaderTest.assertEquals((String)"age", (String)fields[0]);
        SuggestionCompletionLoaderTest.assertEquals((String)"alive", (String)fields[1]);
        SuggestionCompletionLoaderTest.assertEquals((String)"bigDecimal", (String)fields[2]);
    }

    public void testSortOrderOfFacts() throws Exception {
        SuggestionCompletionLoader loader = new SuggestionCompletionLoader();
        SuggestionCompletionEngine eng = loader.getSuggestionEngine("package foo \n import org.drools.brms.server.rules.SomeFact\n import org.drools.Person", new ArrayList(), new ArrayList());
        SuggestionCompletionLoaderTest.assertNotNull((Object)eng);
        String[] facts = eng.getFactTypes();
        SuggestionCompletionLoaderTest.assertEquals((int)2, (int)facts.length);
        SuggestionCompletionLoaderTest.assertEquals((String)"Person", (String)facts[0]);
        SuggestionCompletionLoaderTest.assertEquals((String)"SomeFact", (String)facts[1]);
    }

    public void testLoaderWithExistingClassloader() throws Exception {
        MockClassLoader mcl = new MockClassLoader();
        SuggestionCompletionLoader loader = new SuggestionCompletionLoader((ClassLoader)mcl);
        SuggestionCompletionEngine eng = loader.getSuggestionEngine("package foo \n import org.foo.Bar", new ArrayList(), new ArrayList());
        SuggestionCompletionLoaderTest.assertNotNull((Object)eng);
        SuggestionCompletionLoaderTest.assertNotNull((Object)eng.dataEnumLists);
        SuggestionCompletionLoaderTest.assertTrue((boolean)mcl.called);
    }

    static class MockClassLoader
    extends ClassLoader {
        public boolean called = false;

        MockClassLoader() {
        }

        public Class loadClass(String name) {
            this.called = true;
            return class$java$lang$Object == null ? (class$java$lang$Object = SuggestionCompletionLoaderTest.class$("java.lang.Object")) : class$java$lang$Object;
        }
    }
}

