/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import junit.framework.TestCase;
import org.drools.compiler.DroolsParserException;
import org.drools.compiler.PackageBuilder;
import org.drools.rule.Package;

public class CompilerPerfProfileTest
extends TestCase {
    public void testProfileRuns() throws Exception {
        this.build("JDT", "largeRuleNumber.drl", false);
        this.build("MVEL", "largeRuleNumberMVEL.drl", false);
        System.gc();
        Thread.sleep(100L);
        this.build("MVEL", "largeRuleNumberMVEL.drl", true);
        System.gc();
        Thread.sleep(100L);
        this.build("JDT", "largeRuleNumber.drl", true);
    }

    private void build(String msg, String resource, boolean showResults) throws DroolsParserException, IOException {
        PackageBuilder builder = new PackageBuilder();
        long start = System.currentTimeMillis();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream(resource)));
        Package pkg = builder.getPackage();
        CompilerPerfProfileTest.assertFalse((boolean)builder.hasErrors());
        CompilerPerfProfileTest.assertNotNull((Object)pkg);
        if (showResults) {
            System.out.print("Time taken for " + msg + " : " + (System.currentTimeMillis() - start));
        }
    }
}

