/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler;

import java.io.Reader;
import java.io.StringReader;
import junit.framework.TestCase;
import org.drools.RuntimeDroolsException;
import org.drools.compiler.DrlParser;
import org.drools.lang.Expander;
import org.drools.lang.dsl.DSLMappingFile;
import org.drools.lang.dsl.DefaultExpander;
import org.drools.lang.dsl.DefaultExpanderResolver;

public class DrlParserTest
extends TestCase {
    public void testExpandDRL() throws Exception {
        String dsl = "[condition]Something=Something()\n[then]another=another();";
        String drl = "rule 'foo' \n when \n Something \n then \n another \nend";
        DrlParser parser = new DrlParser();
        String result = parser.getExpandedDRL(drl, (Reader)new StringReader(dsl));
        this.assertEqualsIgnoreWhitespace("rule 'foo' \n when \n Something() \n then \n another(); \nend", result);
    }

    public void testExpandDRLUsingInjectedExpander() throws Exception {
        String dsl = "[condition]Something=Something()\n[then]another=another();";
        String drl = "rule 'foo' \n when \n Something \n then \n another \nend";
        DefaultExpanderResolver resolver = new DefaultExpanderResolver((Reader)new StringReader(dsl));
        DSLMappingFile file = new DSLMappingFile();
        if (!file.parseAndLoad((Reader)new StringReader(dsl))) {
            throw new RuntimeDroolsException("Error parsing and loading DSL file." + file.getErrors());
        }
        DefaultExpander expander = new DefaultExpander();
        expander.addDSLMapping(file.getMapping());
        resolver.addExpander("*", (Expander)expander);
        DrlParser parser = new DrlParser();
        String result = parser.getExpandedDRL(drl, resolver);
        this.assertEqualsIgnoreWhitespace("rule 'foo' \n when \n Something() \n then \n another(); \nend", result);
    }

    private void assertEqualsIgnoreWhitespace(String expected, String actual) {
        String cleanExpected = expected.replaceAll("\\s+", "");
        String cleanActual = actual.replaceAll("\\s+", "");
        DrlParserTest.assertEquals((String)cleanExpected, (String)cleanActual);
    }
}

