/*
 * Decompiled with CFR 0.152.
 */
package org.drools.integrationtests;

import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import junit.framework.TestCase;
import org.drools.Cheese;
import org.drools.Person;
import org.drools.RuleBase;
import org.drools.RuleBaseConfiguration;
import org.drools.RuleBaseFactory;
import org.drools.StatefulSession;
import org.drools.compiler.PackageBuilder;
import org.drools.rule.Package;

public class DslTest
extends TestCase {
    protected RuleBase getRuleBase() throws Exception {
        return RuleBaseFactory.newRuleBase((int)1, null);
    }

    protected RuleBase getRuleBase(RuleBaseConfiguration config) throws Exception {
        return RuleBaseFactory.newRuleBase((int)1, (RuleBaseConfiguration)config);
    }

    public void testWithExpanderDSL() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        InputStreamReader source = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("rule_with_expander_dsl.dslr"));
        InputStreamReader dsl = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_expander.dsl"));
        builder.addPackageFromDrl((Reader)source, (Reader)dsl);
        Package pkg = builder.getPackage();
        DslTest.assertTrue((boolean)pkg.isValid());
        DslTest.assertEquals(null, (String)pkg.getErrorSummary());
        String err = builder.getErrors().toString();
        DslTest.assertEquals((String)"", (String)err);
        DslTest.assertEquals((int)0, (int)builder.getErrors().getErrors().length);
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession wm = ruleBase.newStatefulSession();
        wm.insert((Object)new Person("Bob", "http://foo.bar"));
        wm.insert((Object)new Cheese("stilton", 42));
        ArrayList messages = new ArrayList();
        wm.setGlobal("messages", messages);
        wm.fireAllRules();
        DslTest.assertEquals((int)1, (int)messages.size());
    }

    public void testWithExpanderMore() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        InputStreamReader source = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("rule_with_expander_dsl_more.dslr"));
        InputStreamReader dsl = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_expander.dsl"));
        builder.addPackageFromDrl((Reader)source, (Reader)dsl);
        Package pkg = builder.getPackage();
        DslTest.assertTrue((boolean)pkg.isValid());
        DslTest.assertEquals(null, (String)pkg.getErrorSummary());
        String err = builder.getErrors().toString();
        DslTest.assertEquals((String)"", (String)err);
        DslTest.assertEquals((int)0, (int)builder.getErrors().getErrors().length);
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession wm = ruleBase.newStatefulSession();
        wm.insert((Object)new Person("rage"));
        wm.insert((Object)new Cheese("cheddar", 15));
        ArrayList messages = new ArrayList();
        wm.setGlobal("messages", messages);
        wm.fireAllRules();
        DslTest.assertEquals((int)0, (int)messages.size());
        wm.insert((Object)new Person("fire"));
        wm.fireAllRules();
        DslTest.assertEquals((int)0, (int)messages.size());
        wm.insert((Object)new Cheese("brie", 15));
        wm.fireAllRules();
        DslTest.assertEquals((int)1, (int)messages.size());
    }

    public void testEmptyDSL() throws Exception {
        String DSL = "# This is an empty dsl file.";
        PackageBuilder builder = new PackageBuilder();
        InputStreamReader drlReader = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("literal_rule.drl"));
        StringReader dslReader = new StringReader("# This is an empty dsl file.");
        builder.addPackageFromDrl((Reader)drlReader, (Reader)dslReader);
        Package pkg = builder.getPackage();
        DslTest.assertFalse((boolean)pkg.isValid());
    }

    public void testDSLWithIndividualConstraintMappings() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        InputStreamReader source = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_dslWithIndividualConstraints.dslr"));
        InputStreamReader dsl = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_dslWithIndividualConstraints.dsl"));
        builder.addPackageFromDrl((Reader)source, (Reader)dsl);
        Package pkg = builder.getPackage();
        DslTest.assertTrue((String)pkg.getErrorSummary(), (boolean)pkg.isValid());
        DslTest.assertEquals((String)pkg.getErrorSummary(), null, (String)pkg.getErrorSummary());
        DslTest.assertEquals((int)0, (int)builder.getErrors().getErrors().length);
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession wm = ruleBase.newStatefulSession();
        ArrayList results = new ArrayList();
        wm.setGlobal("results", results);
        Cheese cheese = new Cheese("stilton", 42);
        wm.insert((Object)cheese);
        wm.fireAllRules();
        DslTest.assertEquals((int)1, (int)results.size());
        DslTest.assertEquals((Object)cheese, results.get(0));
    }
}

