/*
 * Decompiled with CFR 0.152.
 */
package org.drools.integrationtests;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.drools.Cheese;
import org.drools.FactA;
import org.drools.FactB;
import org.drools.Person;
import org.drools.Precondition;
import org.drools.RuleBase;
import org.drools.RuleBaseConfiguration;
import org.drools.RuleBaseFactory;
import org.drools.StatefulSession;
import org.drools.compiler.PackageBuilder;
import org.drools.compiler.PackageBuilderConfiguration;
import org.drools.reteoo.ReteooRuleBase;
import org.drools.rule.Package;

public class DynamicRulesTest
extends TestCase {
    protected RuleBase getRuleBase() throws Exception {
        return RuleBaseFactory.newRuleBase((int)1, null);
    }

    protected RuleBase getRuleBase(RuleBaseConfiguration config) throws Exception {
        return RuleBaseFactory.newRuleBase((int)1, (RuleBaseConfiguration)config);
    }

    public void testDynamicRuleAdditions() throws Exception {
        InputStreamReader reader = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_Dynamic1.drl"));
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)reader);
        Package pkg1 = this.serialisePackage(builder.getPackage());
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg1);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        workingMemory.setGlobal("total", (Object)new Integer(0));
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("list", list);
        Person bob = new Person("bob", "stilton");
        bob.setStatus("Not evaluated");
        workingMemory.insert((Object)bob);
        Cheese stilton = new Cheese("stilton", 5);
        workingMemory.insert((Object)stilton);
        Cheese cheddar = new Cheese("cheddar", 5);
        workingMemory.insert((Object)cheddar);
        workingMemory.fireAllRules();
        DynamicRulesTest.assertEquals((int)1, (int)list.size());
        DynamicRulesTest.assertEquals((Object)"stilton", list.get(0));
        reader = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_Dynamic2.drl"));
        builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)reader);
        Package pkg2 = this.serialisePackage(builder.getPackage());
        ruleBase.addPackage(pkg2);
        DynamicRulesTest.assertEquals((int)3, (int)list.size());
        DynamicRulesTest.assertEquals((Object)"stilton", list.get(0));
        DynamicRulesTest.assertTrue(("cheddar".equals(list.get(1)) || "cheddar".equals(list.get(2)) ? 1 : 0) != 0);
        DynamicRulesTest.assertTrue(("stilton".equals(list.get(1)) || "stilton".equals(list.get(2)) ? 1 : 0) != 0);
        list.clear();
        reader = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_Dynamic3.drl"));
        builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)reader);
        Package pkg3 = this.serialisePackage(builder.getPackage());
        ruleBase.addPackage(pkg3);
        Assert.assertEquals((String)"Rule from package 3 should have been fired", (String)"match Person ok", (String)bob.getStatus());
        DynamicRulesTest.assertEquals((int)1, (int)list.size());
        DynamicRulesTest.assertEquals((Object)bob, list.get(0));
        reader = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_Dynamic4.drl"));
        builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)reader);
        Package pkg4 = this.serialisePackage(builder.getPackage());
        ruleBase.addPackage(pkg4);
        Assert.assertEquals((String)"Rule from package 4 should have been fired", (String)"Who likes Stilton ok", (String)bob.getStatus());
        DynamicRulesTest.assertEquals((int)2, (int)list.size());
        DynamicRulesTest.assertEquals((Object)bob, list.get(1));
    }

    public void testDynamicRuleRemovals() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_Dynamic1.drl")));
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_Dynamic3.drl")));
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_Dynamic4.drl")));
        Package pkg = this.serialisePackage(builder.getPackage());
        ReteooRuleBase reteooRuleBase = null;
        RuleBase ruleBase = this.getRuleBase();
        reteooRuleBase = (ReteooRuleBase)ruleBase;
        ruleBase.addPackage(pkg);
        PackageBuilder builder2 = new PackageBuilder();
        builder2.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_Dynamic2.drl")));
        ruleBase.addPackage(this.serialisePackage(builder2.getPackage()));
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("list", list);
        Person bob = new Person("bob", "stilton");
        bob.setStatus("Not evaluated");
        workingMemory.insert((Object)bob);
        Cheese stilton1 = new Cheese("stilton", 5);
        workingMemory.insert((Object)stilton1);
        Cheese stilton2 = new Cheese("stilton", 3);
        workingMemory.insert((Object)stilton2);
        Cheese stilton3 = new Cheese("stilton", 1);
        workingMemory.insert((Object)stilton3);
        Cheese cheddar = new Cheese("cheddar", 5);
        workingMemory.insert((Object)cheddar);
        DynamicRulesTest.assertEquals((int)15, (int)workingMemory.getAgenda().getActivations().length);
        reteooRuleBase.removeRule("org.drools.test", "Who likes Stilton");
        DynamicRulesTest.assertEquals((int)12, (int)workingMemory.getAgenda().getActivations().length);
        reteooRuleBase.removeRule("org.drools.test", "like cheese");
        Cheese muzzarela = new Cheese("muzzarela", 5);
        DynamicRulesTest.assertEquals((int)8, (int)workingMemory.getAgenda().getActivations().length);
        workingMemory.insert((Object)muzzarela);
        DynamicRulesTest.assertEquals((int)9, (int)workingMemory.getAgenda().getActivations().length);
        reteooRuleBase.removePackage("org.drools.test");
        DynamicRulesTest.assertEquals((int)0, (int)workingMemory.getAgenda().getActivations().length);
    }

    public void testDynamicRuleRemovalsUnusedWorkingMemory() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_Dynamic1.drl")));
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_Dynamic2.drl")));
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_Dynamic3.drl")));
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_Dynamic4.drl")));
        Package pkg = builder.getPackage();
        ReteooRuleBase reteooRuleBase = null;
        RuleBase ruleBase = this.getRuleBase();
        reteooRuleBase = (ReteooRuleBase)ruleBase;
        ruleBase.addPackage(pkg);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        if (reteooRuleBase != null) {
            DynamicRulesTest.assertEquals((int)1, (int)reteooRuleBase.getPackages().length);
            DynamicRulesTest.assertEquals((int)5, (int)reteooRuleBase.getPackages()[0].getRules().length);
            reteooRuleBase.removeRule("org.drools.test", "Who likes Stilton");
            DynamicRulesTest.assertEquals((int)4, (int)reteooRuleBase.getPackages()[0].getRules().length);
            reteooRuleBase.removeRule("org.drools.test", "like cheese");
            DynamicRulesTest.assertEquals((int)3, (int)reteooRuleBase.getPackages()[0].getRules().length);
            reteooRuleBase.removePackage("org.drools.test");
            DynamicRulesTest.assertEquals((int)0, (int)reteooRuleBase.getPackages().length);
        }
    }

    public void testDynamicFunction() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_DynamicFunction1.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("list", list);
        Cheese stilton = new Cheese("stilton", 5);
        workingMemory.insert((Object)stilton);
        workingMemory.fireAllRules();
        DynamicRulesTest.assertEquals((Object)new Integer(5), list.get(0));
        ruleBase.removeFunction("org.drools.test", "addFive");
        Cheese cheddar = new Cheese("cheddar", 5);
        workingMemory.insert((Object)cheddar);
        try {
            workingMemory.fireAllRules();
            DynamicRulesTest.fail((String)"Function should have been removed and NoClassDefFoundError thrown from the Consequence");
        }
        catch (NoClassDefFoundError e) {
            // empty catch block
        }
        builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_DynamicFunction2.drl")));
        ruleBase.addPackage(this.serialisePackage(builder.getPackage()));
        Cheese brie = new Cheese("brie", 5);
        workingMemory.insert((Object)brie);
        workingMemory.fireAllRules();
        DynamicRulesTest.assertEquals((Object)new Integer(6), list.get(1));
        builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_DynamicFunction3.drl")));
        ruleBase.addPackage(this.serialisePackage(builder.getPackage()));
        Cheese feta = new Cheese("feta", 5);
        workingMemory.insert((Object)feta);
        workingMemory.fireAllRules();
        DynamicRulesTest.assertEquals((Object)new Integer(5), list.get(2));
    }

    public void testRemovePackage() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_RemovePackage.drl")));
        RuleBase ruleBase = this.getRuleBase();
        String packageName = builder.getPackage().getName();
        ruleBase.addPackage(this.serialisePackage(builder.getPackage()));
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        workingMemory.insert((Object)new Precondition("genericcode", "genericvalue"));
        workingMemory.fireAllRules();
        RuleBase ruleBaseWM = workingMemory.getRuleBase();
        ruleBaseWM.removePackage(packageName);
        PackageBuilder builder1 = new PackageBuilder();
        builder1.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_RemovePackage.drl")));
        ruleBaseWM.addPackage(this.serialisePackage(builder1.getPackage()));
        workingMemory.fireAllRules();
        ruleBaseWM.removePackage(packageName);
        ruleBaseWM.addPackage(this.serialisePackage(builder1.getPackage()));
        ruleBaseWM.removePackage(packageName);
        ruleBaseWM.addPackage(this.serialisePackage(builder1.getPackage()));
    }

    public void testDynamicRules() throws Exception {
        RuleBase ruleBase = this.getRuleBase();
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        Cheese a = new Cheese("stilton", 10);
        Cheese b = new Cheese("stilton", 15);
        Cheese c = new Cheese("stilton", 20);
        workingMemory.insert((Object)a);
        workingMemory.insert((Object)b);
        workingMemory.insert((Object)c);
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_DynamicRules.drl")));
        Package pkg = builder.getPackage();
        ruleBase.addPackage(this.serialisePackage(pkg));
        workingMemory.fireAllRules();
    }

    public void testDynamicRules2() throws Exception {
        RuleBase ruleBase = this.getRuleBase();
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        FactA a = new FactA("hello", new Integer(1), new Float(3.14));
        FactB b = new FactB("hello", new Integer(2), new Float(6.28));
        workingMemory.insert((Object)a);
        workingMemory.insert((Object)b);
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_DynamicRules2.drl")));
        Package pkg = this.serialisePackage(builder.getPackage());
        ruleBase.addPackage(pkg);
        workingMemory.fireAllRules();
    }

    public void testRuleBaseAddRemove() throws Exception {
        RuleBase ruleBase = RuleBaseFactory.newRuleBase();
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_Dynamic1.drl")));
        Package pkg = this.serialisePackage(builder.getPackage());
        ruleBase.addPackage(pkg);
        ruleBase.removePackage(pkg.getName());
        builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_Dynamic1.drl")));
        pkg = this.serialisePackage(builder.getPackage());
        ruleBase.addPackage(pkg);
        ruleBase.removePackage(pkg.getName());
    }

    public void testClassLoaderSwitchsUsingConf() throws Exception {
        try {
            SubvertedClassLoader loader1 = new SubvertedClassLoader(new URL[]{((Object)((Object)this)).getClass().getResource("/")}, ((Object)((Object)this)).getClass().getClassLoader());
            Class<?> cheeseClass = loader1.loadClass("org.drools.Cheese");
            PackageBuilderConfiguration conf = new PackageBuilderConfiguration((ClassLoader)loader1);
            PackageBuilder builder = new PackageBuilder(conf);
            builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_Dynamic1.drl")));
            RuleBaseConfiguration rbconf = new RuleBaseConfiguration((ClassLoader)loader1);
            RuleBase ruleBase = RuleBaseFactory.newRuleBase((RuleBaseConfiguration)rbconf);
            Package pkg = this.serialisePackage(builder.getPackage());
            ruleBase.addPackage(pkg);
            StatefulSession wm = ruleBase.newStatefulSession();
            wm.insert(cheeseClass.newInstance());
            wm.fireAllRules();
            SubvertedClassLoader loader2 = new SubvertedClassLoader(new URL[]{((Object)((Object)this)).getClass().getResource("/")}, ((Object)((Object)this)).getClass().getClassLoader());
            cheeseClass = loader2.loadClass("org.drools.Cheese");
            conf = new PackageBuilderConfiguration((ClassLoader)loader2);
            builder = new PackageBuilder(conf);
            builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_Dynamic1.drl")));
            rbconf = new RuleBaseConfiguration((ClassLoader)loader2);
            ruleBase = RuleBaseFactory.newRuleBase((RuleBaseConfiguration)rbconf);
            pkg = this.serialisePackage(builder.getPackage());
            ruleBase.addPackage(pkg);
            wm = ruleBase.newStatefulSession();
            wm.insert(cheeseClass.newInstance());
            wm.fireAllRules();
        }
        catch (ClassCastException cce) {
            cce.printStackTrace();
            DynamicRulesTest.fail((String)"No ClassCastException should be raised.");
        }
    }

    public void testClassLoaderSwitchsUsingContext() throws Exception {
        try {
            ClassLoader original = Thread.currentThread().getContextClassLoader();
            SubvertedClassLoader loader1 = new SubvertedClassLoader(new URL[]{((Object)((Object)this)).getClass().getResource("/")}, ((Object)((Object)this)).getClass().getClassLoader());
            Thread.currentThread().setContextClassLoader(loader1);
            Class<?> cheeseClass = loader1.loadClass("org.drools.Cheese");
            PackageBuilder builder = new PackageBuilder();
            builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_Dynamic1.drl")));
            RuleBase ruleBase = RuleBaseFactory.newRuleBase();
            Package pkg = this.serialisePackage(builder.getPackage());
            ruleBase.addPackage(pkg);
            StatefulSession wm = ruleBase.newStatefulSession();
            wm.insert(cheeseClass.newInstance());
            wm.fireAllRules();
            SubvertedClassLoader loader2 = new SubvertedClassLoader(new URL[]{((Object)((Object)this)).getClass().getResource("/")}, ((Object)((Object)this)).getClass().getClassLoader());
            Thread.currentThread().setContextClassLoader(loader2);
            cheeseClass = loader2.loadClass("org.drools.Cheese");
            builder = new PackageBuilder();
            builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_Dynamic1.drl")));
            ruleBase = RuleBaseFactory.newRuleBase();
            pkg = this.serialisePackage(builder.getPackage());
            ruleBase.addPackage(pkg);
            wm = ruleBase.newStatefulSession();
            wm.insert(cheeseClass.newInstance());
            wm.fireAllRules();
            Thread.currentThread().setContextClassLoader(original);
        }
        catch (ClassCastException cce) {
            cce.printStackTrace();
            DynamicRulesTest.fail((String)"No ClassCastException should be raised.");
        }
    }

    protected Package serialisePackage(Package pkg) {
        try {
            byte[] bytes = this.serializeOut(pkg);
            return (Package)this.serializeIn(bytes);
        }
        catch (Exception e) {
            throw new RuntimeException("trouble serialising package.", e);
        }
    }

    protected Object serializeIn(byte[] bytes) throws IOException, ClassNotFoundException {
        ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(bytes));
        Object obj = in.readObject();
        in.close();
        return obj;
    }

    protected byte[] serializeOut(Object obj) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(bos);
        out.writeObject(obj);
        out.close();
        byte[] bytes = bos.toByteArray();
        return bytes;
    }

    public class SubvertedClassLoader
    extends URLClassLoader {
        private static final long serialVersionUID = 400L;

        public SubvertedClassLoader(URL[] urls, ClassLoader parentClassLoader) {
            super(urls, parentClassLoader);
        }

        protected synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
            Class<?> c = this.findLoadedClass(name);
            if (c == null) {
                try {
                    c = this.findClass(name);
                }
                catch (ClassNotFoundException e) {
                    c = super.loadClass(name, resolve);
                }
            }
            return c;
        }
    }
}

