/*
 * Decompiled with CFR 0.152.
 */
package org.drools.integrationtests;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.drools.Cheese;
import org.drools.FactHandle;
import org.drools.Person;
import org.drools.RuleBase;
import org.drools.RuleBaseConfiguration;
import org.drools.RuleBaseFactory;
import org.drools.StatefulSession;
import org.drools.WorkingMemory;
import org.drools.common.DefaultAgenda;
import org.drools.common.InternalWorkingMemoryActions;
import org.drools.common.RuleFlowGroupImpl;
import org.drools.compiler.DrlParser;
import org.drools.compiler.DroolsParserException;
import org.drools.compiler.PackageBuilder;
import org.drools.event.ActivationCancelledEvent;
import org.drools.event.ActivationCreatedEvent;
import org.drools.event.AgendaEventListener;
import org.drools.event.DefaultAgendaEventListener;
import org.drools.integrationtests.helloworld.Message;
import org.drools.lang.descr.PackageDescr;
import org.drools.rule.Package;
import org.drools.ruleflow.common.instance.ProcessInstance;
import org.drools.spi.Activation;
import org.drools.spi.ActivationGroup;
import org.drools.spi.AgendaGroup;

public class ExecutionFlowControlTest
extends TestCase {
    protected RuleBase getRuleBase() throws Exception {
        return RuleBaseFactory.newRuleBase((int)1, null);
    }

    protected RuleBase getRuleBase(RuleBaseConfiguration config) throws Exception {
        return RuleBaseFactory.newRuleBase((int)1, (RuleBaseConfiguration)config);
    }

    public void testSalienceInteger() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_salienceIntegerRule.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("list", list);
        Person person = new Person("Edson", "cheese");
        workingMemory.insert((Object)person);
        workingMemory.fireAllRules();
        Assert.assertEquals((String)"Two rules should have been fired", (int)2, (int)list.size());
        Assert.assertEquals((String)"Rule 3 should have been fired first", (Object)"Rule 3", list.get(0));
        Assert.assertEquals((String)"Rule 2 should have been fired second", (Object)"Rule 2", list.get(1));
    }

    public void testSalienceExpression() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_salienceExpressionRule.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("list", list);
        Person person10 = new Person("bob", "cheese", 10);
        workingMemory.insert((Object)person10);
        Person person20 = new Person("mic", "cheese", 20);
        workingMemory.insert((Object)person20);
        workingMemory.fireAllRules();
        Assert.assertEquals((String)"Two rules should have been fired", (int)2, (int)list.size());
        Assert.assertEquals((String)"Rule 3 should have been fired first", (Object)"Rule 3", list.get(0));
        Assert.assertEquals((String)"Rule 2 should have been fired second", (Object)"Rule 2", list.get(1));
    }

    public void testNoLoop() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("no-loop.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("list", list);
        Cheese brie = new Cheese("brie", 12);
        workingMemory.insert((Object)brie);
        workingMemory.fireAllRules();
        Assert.assertEquals((String)"Should not loop  and thus size should be 1", (int)1, (int)list.size());
    }

    public void testLockOnActive() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_LockOnActive.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("list", list);
        Cheese brie12 = new Cheese("brie", 12);
        workingMemory.insert((Object)brie12);
        AgendaGroup group1 = workingMemory.getAgenda().getAgendaGroup("group1");
        ExecutionFlowControlTest.assertEquals((int)1, (int)group1.size());
        workingMemory.setFocus("group1");
        Cheese brie10 = new Cheese("brie", 10);
        workingMemory.insert((Object)brie10);
        ExecutionFlowControlTest.assertEquals((int)1, (int)group1.size());
        Cheese cheddar20 = new Cheese("cheddar", 20);
        workingMemory.insert((Object)cheddar20);
        AgendaGroup group2 = workingMemory.getAgenda().getAgendaGroup("group1");
        ExecutionFlowControlTest.assertEquals((int)1, (int)group2.size());
        RuleFlowGroupImpl rfg = (RuleFlowGroupImpl)workingMemory.getAgenda().getRuleFlowGroup("ruleflow2");
        rfg.setActive(true);
        Cheese cheddar17 = new Cheese("cheddar", 17);
        workingMemory.insert((Object)cheddar17);
        ExecutionFlowControlTest.assertEquals((int)1, (int)group2.size());
    }

    public void testLockOnActiveWithModify() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_LockOnActiveWithUpdate.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession wm = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        wm.setGlobal("list", list);
        Cheese brie = new Cheese("brie", 13);
        Person bob = new Person("bob");
        bob.setCheese(brie);
        Person mic = new Person("mic");
        mic.setCheese(brie);
        Person mark = new Person("mark");
        mark.setCheese(brie);
        FactHandle brieHandle = wm.insert((Object)brie);
        wm.insert((Object)bob);
        wm.insert((Object)mic);
        wm.insert((Object)mark);
        DefaultAgenda agenda = (DefaultAgenda)wm.getAgenda();
        AgendaGroup group1 = agenda.getAgendaGroup("group1");
        agenda.setFocus(group1);
        ExecutionFlowControlTest.assertEquals((int)3, (int)group1.size());
        agenda.fireNextItem(null);
        ExecutionFlowControlTest.assertEquals((int)2, (int)group1.size());
        wm.update(brieHandle, (Object)brie);
        ExecutionFlowControlTest.assertEquals((int)2, (int)group1.size());
        AgendaGroup group2 = agenda.getAgendaGroup("group2");
        agenda.setFocus(group2);
        RuleFlowGroupImpl rfg = (RuleFlowGroupImpl)wm.getAgenda().getRuleFlowGroup("ruleflow2");
        ExecutionFlowControlTest.assertEquals((int)3, (int)rfg.size());
        agenda.activateRuleFlowGroup("ruleflow2");
        agenda.fireNextItem(null);
        ExecutionFlowControlTest.assertEquals((int)2, (int)rfg.size());
        wm.update(brieHandle, (Object)brie);
        ExecutionFlowControlTest.assertEquals((int)2, (int)group2.size());
    }

    public void testAgendaGroups() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_AgendaGroups.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("list", list);
        Cheese brie = new Cheese("brie", 12);
        workingMemory.insert((Object)brie);
        workingMemory.fireAllRules();
        ExecutionFlowControlTest.assertEquals((int)7, (int)list.size());
        ExecutionFlowControlTest.assertEquals((Object)"group3", list.get(0));
        ExecutionFlowControlTest.assertEquals((Object)"group4", list.get(1));
        ExecutionFlowControlTest.assertEquals((Object)"group3", list.get(2));
        ExecutionFlowControlTest.assertEquals((Object)"MAIN", list.get(3));
        ExecutionFlowControlTest.assertEquals((Object)"group1", list.get(4));
        ExecutionFlowControlTest.assertEquals((Object)"group1", list.get(5));
        ExecutionFlowControlTest.assertEquals((Object)"MAIN", list.get(6));
        workingMemory.setFocus("group2");
        workingMemory.fireAllRules();
        ExecutionFlowControlTest.assertEquals((int)8, (int)list.size());
        ExecutionFlowControlTest.assertEquals((Object)"group2", list.get(7));
    }

    public void testActivationGroups() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_ActivationGroups.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("list", list);
        Cheese brie = new Cheese("brie", 12);
        workingMemory.insert((Object)brie);
        ActivationGroup activationGroup0 = workingMemory.getAgenda().getActivationGroup("activation-group-0");
        ExecutionFlowControlTest.assertEquals((int)2, (int)activationGroup0.size());
        ActivationGroup activationGroup3 = workingMemory.getAgenda().getActivationGroup("activation-group-3");
        ExecutionFlowControlTest.assertEquals((int)1, (int)activationGroup3.size());
        AgendaGroup agendaGroup3 = workingMemory.getAgenda().getAgendaGroup("agenda-group-3");
        ExecutionFlowControlTest.assertEquals((int)1, (int)agendaGroup3.size());
        AgendaGroup agendaGroupMain = workingMemory.getAgenda().getAgendaGroup("MAIN");
        ExecutionFlowControlTest.assertEquals((int)3, (int)agendaGroupMain.size());
        workingMemory.clearAgendaGroup("agenda-group-3");
        ExecutionFlowControlTest.assertEquals((int)0, (int)activationGroup3.size());
        ExecutionFlowControlTest.assertEquals((int)0, (int)agendaGroup3.size());
        workingMemory.fireAllRules();
        ExecutionFlowControlTest.assertEquals((int)0, (int)activationGroup0.size());
        ExecutionFlowControlTest.assertEquals((int)2, (int)list.size());
        ExecutionFlowControlTest.assertEquals((Object)"rule0", list.get(0));
        ExecutionFlowControlTest.assertEquals((Object)"rule2", list.get(1));
    }

    public void testDuration() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_Duration.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("list", list);
        Cheese brie = new Cheese("brie", 12);
        FactHandle brieHandle = workingMemory.insert((Object)brie);
        workingMemory.fireAllRules();
        ExecutionFlowControlTest.assertEquals((int)0, (int)list.size());
        Thread.sleep(300L);
        ExecutionFlowControlTest.assertEquals((int)1, (int)list.size());
    }

    public void testInsertRetractNoloop() throws Exception {
        InputStreamReader reader = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_Insert_Retract_Noloop.drl"));
        RuleBase ruleBase = this.loadRuleBase(reader);
        StatefulSession wm = ruleBase.newStatefulSession();
        wm.insert((Object)new Cheese("stilton", 15));
        wm.fireAllRules();
    }

    public void testDurationWithNoLoop() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_Duration_with_NoLoop.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("list", list);
        Cheese brie = new Cheese("brie", 12);
        FactHandle brieHandle = workingMemory.insert((Object)brie);
        workingMemory.fireAllRules();
        ExecutionFlowControlTest.assertEquals((int)0, (int)list.size());
        Thread.sleep(300L);
        ExecutionFlowControlTest.assertEquals((int)1, (int)list.size());
    }

    public void testFireRuleAfterDuration() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_FireRuleAfterDuration.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("list", list);
        Cheese brie = new Cheese("brie", 12);
        FactHandle brieHandle = workingMemory.insert((Object)brie);
        workingMemory.fireAllRules();
        ExecutionFlowControlTest.assertEquals((int)0, (int)list.size());
        Thread.sleep(300L);
        workingMemory.fireAllRules();
        ExecutionFlowControlTest.assertEquals((int)2, (int)list.size());
    }

    public void testUpdateNoLoop() throws Exception {
        InputStreamReader reader = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_UpdateNoloop.drl"));
        RuleBase ruleBase = this.loadRuleBase(reader);
        StatefulSession wm = ruleBase.newStatefulSession();
        wm.insert((Object)new Cheese("stilton", 15));
        wm.fireAllRules();
    }

    public void testUpdateActivationCreationNoLoop() throws Exception {
        InputStreamReader reader = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_UpdateActivationCreationNoLoop.drl"));
        RuleBase ruleBase = this.loadRuleBase(reader);
        InternalWorkingMemoryActions wm = (InternalWorkingMemoryActions)ruleBase.newStatefulSession();
        final ArrayList created = new ArrayList();
        final ArrayList cancelled = new ArrayList();
        DefaultAgendaEventListener l = new DefaultAgendaEventListener(){

            public void activationCreated(ActivationCreatedEvent event, WorkingMemory workingMemory) {
                created.add(event);
            }

            public void activationCancelled(ActivationCancelledEvent event, WorkingMemory workingMemory) {
                cancelled.add(event);
            }
        };
        wm.addEventListener((AgendaEventListener)l);
        Cheese stilton = new Cheese("stilton", 15);
        FactHandle stiltonHandle = wm.insert((Object)stilton);
        Person p1 = new Person("p1");
        p1.setCheese(stilton);
        wm.insert((Object)p1);
        Person p2 = new Person("p2");
        p2.setCheese(stilton);
        wm.insert((Object)p2);
        Person p3 = new Person("p3");
        p3.setCheese(stilton);
        wm.insert((Object)p3);
        ExecutionFlowControlTest.assertEquals((int)3, (int)created.size());
        ExecutionFlowControlTest.assertEquals((int)0, (int)cancelled.size());
        Activation item = ((ActivationCreatedEvent)created.get(2)).getActivation();
        wm.update(stiltonHandle, (Object)stilton, item.getRule(), item);
        ExecutionFlowControlTest.assertEquals((int)5, (int)created.size());
        ExecutionFlowControlTest.assertEquals((int)3, (int)cancelled.size());
    }

    public void testRuleFlowGroup() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("ruleflowgroup.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("list", list);
        workingMemory.insert((Object)"Test");
        workingMemory.fireAllRules();
        ExecutionFlowControlTest.assertEquals((int)0, (int)list.size());
        workingMemory.getAgenda().activateRuleFlowGroup("Group1");
        workingMemory.fireAllRules();
        ExecutionFlowControlTest.assertEquals((int)1, (int)list.size());
    }

    public void testRuleFlow() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("ruleflow.drl")));
        builder.addRuleFlow((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("ruleflow.rfm")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("list", list);
        workingMemory.fireAllRules();
        ExecutionFlowControlTest.assertEquals((int)0, (int)list.size());
        ProcessInstance processInstance = workingMemory.startProcess("0");
        ExecutionFlowControlTest.assertEquals((int)1, (int)processInstance.getState());
        workingMemory.fireAllRules();
        ExecutionFlowControlTest.assertEquals((int)4, (int)list.size());
        ExecutionFlowControlTest.assertEquals((Object)"Rule1", list.get(0));
        ExecutionFlowControlTest.assertEquals((Object)"Rule3", list.get(1));
        ExecutionFlowControlTest.assertEquals((Object)"Rule2", list.get(2));
        ExecutionFlowControlTest.assertEquals((Object)"Rule4", list.get(3));
        ExecutionFlowControlTest.assertEquals((int)2, (int)processInstance.getState());
    }

    public void testRuleFlowClear() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_ruleflowClear.drl")));
        builder.addRuleFlow((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_ruleflowClear.rfm")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("list", list);
        final ArrayList activations = new ArrayList();
        DefaultAgendaEventListener listener = new DefaultAgendaEventListener(){

            public void activationCancelled(ActivationCancelledEvent event, WorkingMemory workingMemory) {
                activations.add(event.getActivation());
            }
        };
        workingMemory.addEventListener((AgendaEventListener)listener);
        ExecutionFlowControlTest.assertEquals((int)0, (int)workingMemory.getAgenda().getRuleFlowGroup("flowgroup-1").size());
        workingMemory.fireAllRules();
        ExecutionFlowControlTest.assertEquals((int)4, (int)workingMemory.getAgenda().getRuleFlowGroup("flowgroup-1").size());
        ExecutionFlowControlTest.assertEquals((int)0, (int)workingMemory.getAgenda().getAgendaGroup("MAIN").size());
        ProcessInstance processInstance = workingMemory.startProcess("ruleFlowClear");
        ExecutionFlowControlTest.assertEquals((int)4, (int)workingMemory.getAgenda().getAgendaGroup("MAIN").size());
        ExecutionFlowControlTest.assertEquals((int)0, (int)activations.size());
        workingMemory.getAgenda().clearRuleFlowGroup("flowgroup-1");
        ExecutionFlowControlTest.assertEquals((int)0, (int)workingMemory.getAgenda().getAgendaGroup("MAIN").size());
        ExecutionFlowControlTest.assertEquals((int)0, (int)workingMemory.getAgenda().getRuleFlowGroup("flowgroup-1").size());
        ExecutionFlowControlTest.assertEquals((int)4, (int)activations.size());
    }

    public void testRuleFlowInPackage() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("ruleflow.drl")));
        builder.addRuleFlow((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("ruleflow.rfm")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("list", list);
        workingMemory.fireAllRules();
        ExecutionFlowControlTest.assertEquals((int)0, (int)list.size());
        ProcessInstance processInstance = workingMemory.startProcess("0");
        ExecutionFlowControlTest.assertEquals((int)1, (int)processInstance.getState());
        workingMemory.fireAllRules();
        ExecutionFlowControlTest.assertEquals((int)4, (int)list.size());
        ExecutionFlowControlTest.assertEquals((Object)"Rule1", list.get(0));
        ExecutionFlowControlTest.assertEquals((Object)"Rule3", list.get(1));
        ExecutionFlowControlTest.assertEquals((Object)"Rule2", list.get(2));
        ExecutionFlowControlTest.assertEquals((Object)"Rule4", list.get(3));
        ExecutionFlowControlTest.assertEquals((int)2, (int)processInstance.getState());
    }

    public void testLoadingRuleFlowInPackage1() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addRuleFlow((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("ruleflow.rfm")));
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("ruleflow.drl")));
        builder.getPackage();
    }

    public void testLoadingRuleFlowInPackage2() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addRuleFlow((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("ruleflow.rfm")));
        builder.getPackage();
    }

    public void testLoadingRuleFlowInPackage3() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addRuleFlow((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("empty_ruleflow.rfm")));
        builder.getPackage();
    }

    public void testLoadingRuleFlowInPackage4() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addRuleFlow((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("empty_ruleflow.rfm")));
        try {
            builder.addRuleFlow((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("ruleflow.rfm")));
            throw new Exception("An exception should have been thrown.");
        }
        catch (PackageBuilder.PackageMergeException packageMergeException) {
            return;
        }
    }

    public void testLoadingRuleFlowInPackage5() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("ruleflow.drl")));
        try {
            builder.addRuleFlow((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("empty_ruleflow.rfm")));
            throw new Exception("An exception should have been thrown.");
        }
        catch (PackageBuilder.PackageMergeException packageMergeException) {
            return;
        }
    }

    public void testLoadingRuleFlowInPackage6() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addRuleFlow((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("empty_ruleflow.rfm")));
        try {
            builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("ruleflow.drl")));
            throw new Exception("An exception should have been thrown.");
        }
        catch (PackageBuilder.PackageMergeException packageMergeException) {
            return;
        }
    }

    public void testLoadingRuleFlowInPackage7() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addRuleFlow((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("error_ruleflow.rfm")));
        ExecutionFlowControlTest.assertEquals((int)1, (int)builder.getErrors().getErrors().length);
    }

    private RuleBase loadRuleBase(Reader reader) throws IOException, DroolsParserException, Exception {
        DrlParser parser = new DrlParser();
        PackageDescr packageDescr = parser.parse(reader);
        if (parser.hasErrors()) {
            Assert.fail((String)"Error messages in parser, need to sort this our (or else collect error messages)");
        }
        PackageBuilder builder = new PackageBuilder();
        builder.addPackage(packageDescr);
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        return ruleBase;
    }

    public void testDateEffective() throws Exception {
        InputStreamReader reader = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_EffectiveDate.drl"));
        RuleBase ruleBase = this.loadRuleBase(reader);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("list", list);
        Message message = new Message("hola");
        workingMemory.insert((Object)message);
        workingMemory.fireAllRules();
        ExecutionFlowControlTest.assertFalse((boolean)message.isFired());
    }
}

