/*
 * Decompiled with CFR 0.152.
 */
package org.drools.integrationtests;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.drools.Cheese;
import org.drools.Cheesery;
import org.drools.FactHandle;
import org.drools.Order;
import org.drools.OrderItem;
import org.drools.Person;
import org.drools.RuleBase;
import org.drools.RuleBaseConfiguration;
import org.drools.RuleBaseFactory;
import org.drools.SpecialString;
import org.drools.State;
import org.drools.StatefulSession;
import org.drools.compiler.DrlParser;
import org.drools.compiler.DroolsParserException;
import org.drools.compiler.PackageBuilder;
import org.drools.lang.descr.PackageDescr;
import org.drools.rule.Package;
import org.drools.rule.Rule;

public class FirstOrderLogicTest
extends TestCase {
    protected RuleBase getRuleBase() throws Exception {
        return RuleBaseFactory.newRuleBase((int)1, null);
    }

    protected RuleBase getRuleBase(RuleBaseConfiguration config) throws Exception {
        return RuleBaseFactory.newRuleBase((int)1, (RuleBaseConfiguration)config);
    }

    public void testCollect() throws Exception {
        InputStreamReader reader = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_Collect.drl"));
        RuleBase ruleBase = this.loadRuleBase(reader);
        StatefulSession wm = ruleBase.newStatefulSession();
        ArrayList results = new ArrayList();
        wm.setGlobal("results", results);
        wm.insert((Object)new Cheese("stilton", 10));
        wm.insert((Object)new Cheese("stilton", 7));
        wm.insert((Object)new Cheese("stilton", 8));
        wm.insert((Object)new Cheese("brie", 5));
        wm.insert((Object)new Cheese("provolone", 150));
        wm.insert((Object)new Cheese("provolone", 20));
        wm.insert((Object)new Person("Bob", "stilton"));
        wm.insert((Object)new Person("Mark", "provolone"));
        wm.fireAllRules();
        Assert.assertEquals((int)1, (int)results.size());
        Assert.assertEquals((int)3, (int)((Collection)results.get(0)).size());
        Assert.assertEquals((String)ArrayList.class.getName(), (String)results.get(0).getClass().getName());
    }

    public void testCollectModify() throws Exception {
        InputStreamReader reader = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_Collect.drl"));
        RuleBase ruleBase = this.loadRuleBase(reader);
        StatefulSession wm = ruleBase.newStatefulSession();
        ArrayList results = new ArrayList();
        wm.setGlobal("results", results);
        Cheese[] cheese = new Cheese[]{new Cheese("stilton", 10), new Cheese("stilton", 2), new Cheese("stilton", 5), new Cheese("brie", 15), new Cheese("brie", 16), new Cheese("provolone", 8)};
        Person bob = new Person("Bob", "stilton");
        FactHandle[] cheeseHandles = new FactHandle[cheese.length];
        for (int i = 0; i < cheese.length; ++i) {
            cheeseHandles[i] = wm.insert((Object)cheese[i]);
        }
        FactHandle bobHandle = wm.insert((Object)bob);
        int fireCount = 0;
        wm.fireAllRules();
        Assert.assertEquals((int)(++fireCount), (int)results.size());
        Assert.assertEquals((int)3, (int)((Collection)results.get(fireCount - 1)).size());
        Assert.assertEquals((String)ArrayList.class.getName(), (String)results.get(fireCount - 1).getClass().getName());
        boolean index = true;
        cheese[1].setPrice(9);
        wm.update(cheeseHandles[1], (Object)cheese[1]);
        wm.fireAllRules();
        Assert.assertEquals((int)(++fireCount), (int)results.size());
        Assert.assertEquals((int)3, (int)((Collection)results.get(fireCount - 1)).size());
        Assert.assertEquals((String)ArrayList.class.getName(), (String)results.get(fireCount - 1).getClass().getName());
        bob.setLikes("brie");
        wm.update(bobHandle, (Object)bob);
        wm.fireAllRules();
        Assert.assertEquals((int)fireCount, (int)results.size());
        wm.retract(cheeseHandles[3]);
        wm.fireAllRules();
        Assert.assertEquals((int)fireCount, (int)results.size());
    }

    public void testExistsWithBinding() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_ExistsWithBindings.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("results", list);
        Cheese c = new Cheese("stilton", 10);
        Person p = new Person("Mark", "stilton");
        workingMemory.insert((Object)c);
        workingMemory.insert((Object)p);
        workingMemory.fireAllRules();
        FirstOrderLogicTest.assertTrue((boolean)list.contains(c.getType()));
        FirstOrderLogicTest.assertEquals((int)1, (int)list.size());
    }

    public void testNot() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("not_rule_test.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("list", list);
        Cheese stilton = new Cheese("stilton", 5);
        FactHandle stiltonHandle = workingMemory.insert((Object)stilton);
        Cheese cheddar = new Cheese("cheddar", 7);
        FactHandle cheddarHandle = workingMemory.insert((Object)cheddar);
        workingMemory.fireAllRules();
        FirstOrderLogicTest.assertEquals((int)0, (int)list.size());
        workingMemory.retract(stiltonHandle);
        workingMemory.fireAllRules();
        FirstOrderLogicTest.assertEquals((int)4, (int)list.size());
        Assert.assertTrue((boolean)list.contains(new Integer(5)));
        Assert.assertTrue((boolean)list.contains(new Integer(6)));
        Assert.assertTrue((boolean)list.contains(new Integer(7)));
        Assert.assertTrue((boolean)list.contains(new Integer(8)));
    }

    public void testNotWithBindings() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("not_with_bindings_rule_test.drl")));
        Package pkg = builder.getPackage();
        Rule rule = pkg.getRules()[0];
        FirstOrderLogicTest.assertTrue((boolean)rule.isValid());
        FirstOrderLogicTest.assertEquals((int)0, (int)builder.getErrors().getErrors().length);
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("list", list);
        Cheese stilton = new Cheese("stilton", 5);
        FactHandle stiltonHandle = workingMemory.insert((Object)stilton);
        Cheese cheddar = new Cheese("cheddar", 7);
        FactHandle cheddarHandle = workingMemory.insert((Object)cheddar);
        Person paul = new Person("paul", "stilton", 12);
        workingMemory.insert((Object)paul);
        workingMemory.fireAllRules();
        FirstOrderLogicTest.assertEquals((int)0, (int)list.size());
        workingMemory.retract(stiltonHandle);
        workingMemory.fireAllRules();
        FirstOrderLogicTest.assertEquals((int)1, (int)list.size());
    }

    public void testExists() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("exists_rule_test.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("list", list);
        Cheese cheddar = new Cheese("cheddar", 7);
        FactHandle cheddarHandle = workingMemory.insert((Object)cheddar);
        workingMemory.fireAllRules();
        FirstOrderLogicTest.assertEquals((int)0, (int)list.size());
        Cheese stilton = new Cheese("stilton", 5);
        FactHandle stiltonHandle = workingMemory.insert((Object)stilton);
        workingMemory.fireAllRules();
        FirstOrderLogicTest.assertEquals((int)1, (int)list.size());
        Cheese brie = new Cheese("brie", 5);
        FactHandle brieHandle = workingMemory.insert((Object)brie);
        workingMemory.fireAllRules();
        FirstOrderLogicTest.assertEquals((int)1, (int)list.size());
    }

    public void testExists2() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_exists.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("list", list);
        Cheese cheddar = new Cheese("cheddar", 7);
        Cheese provolone = new Cheese("provolone", 5);
        Person edson = new Person("Edson", "cheddar");
        Person bob = new Person("Bob", "muzzarela");
        workingMemory.insert((Object)cheddar);
        workingMemory.fireAllRules();
        FirstOrderLogicTest.assertEquals((int)0, (int)list.size());
        workingMemory.insert((Object)provolone);
        workingMemory.fireAllRules();
        FirstOrderLogicTest.assertEquals((int)0, (int)list.size());
        workingMemory.insert((Object)edson);
        workingMemory.fireAllRules();
        FirstOrderLogicTest.assertEquals((int)1, (int)list.size());
        workingMemory.insert((Object)bob);
        workingMemory.fireAllRules();
        FirstOrderLogicTest.assertEquals((int)1, (int)list.size());
    }

    public void testForall() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_Forall.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("results", list);
        State state = new State("SP");
        workingMemory.insert((Object)state);
        Person bob = new Person("Bob");
        bob.setStatus(state.getState());
        bob.setLikes("stilton");
        workingMemory.insert((Object)bob);
        workingMemory.fireAllRules();
        FirstOrderLogicTest.assertEquals((int)0, (int)list.size());
        workingMemory.insert((Object)new Cheese(bob.getLikes(), 10));
        workingMemory.fireAllRules();
        FirstOrderLogicTest.assertEquals((int)1, (int)list.size());
    }

    public void testRemoveIdentitiesSubNetwork() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_removeIdentitiesSubNetwork.drl")));
        Package pkg = builder.getPackage();
        RuleBaseConfiguration config = new RuleBaseConfiguration();
        config.setRemoveIdentities(true);
        RuleBase ruleBase = this.getRuleBase(config);
        ruleBase.addPackage(pkg);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("results", list);
        Person bob = new Person("bob", "stilton");
        workingMemory.insert((Object)bob);
        Person mark = new Person("mark", "stilton");
        workingMemory.insert((Object)mark);
        Cheese stilton1 = new Cheese("stilton", 6);
        FactHandle stilton1Handle = workingMemory.insert((Object)stilton1);
        Cheese stilton2 = new Cheese("stilton", 7);
        FactHandle stilton2Handle = workingMemory.insert((Object)stilton2);
        workingMemory.fireAllRules();
        FirstOrderLogicTest.assertEquals((int)0, (int)list.size());
        workingMemory.retract(stilton1Handle);
        workingMemory.fireAllRules();
        FirstOrderLogicTest.assertEquals((int)1, (int)list.size());
        FirstOrderLogicTest.assertEquals((Object)mark, list.get(0));
        workingMemory.retract(stilton2Handle);
        workingMemory.fireAllRules();
        FirstOrderLogicTest.assertEquals((int)2, (int)list.size());
        FirstOrderLogicTest.assertEquals((Object)bob, list.get(1));
    }

    public void testCollectWithNestedFromWithParams() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_CollectWithNestedFrom.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList results = new ArrayList();
        workingMemory.setGlobal("results", results);
        Person bob = new Person("bob", "stilton");
        Cheesery cheesery = new Cheesery();
        cheesery.addCheese(new Cheese("stilton", 10));
        cheesery.addCheese(new Cheese("brie", 20));
        cheesery.addCheese(new Cheese("muzzarela", 8));
        cheesery.addCheese(new Cheese("stilton", 5));
        cheesery.addCheese(new Cheese("provolone", 1));
        workingMemory.insert((Object)bob);
        workingMemory.insert((Object)cheesery);
        workingMemory.fireAllRules();
        FirstOrderLogicTest.assertEquals((int)1, (int)results.size());
        List cheeses = (List)results.get(0);
        FirstOrderLogicTest.assertEquals((int)2, (int)cheeses.size());
        FirstOrderLogicTest.assertEquals((String)bob.getLikes(), (String)((Cheese)cheeses.get(0)).getType());
        FirstOrderLogicTest.assertEquals((String)bob.getLikes(), (String)((Cheese)cheeses.get(1)).getType());
    }

    public void testCollectModifyAlphaRestriction() throws Exception {
        InputStreamReader reader = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_CollectAlphaRestriction.drl"));
        RuleBase ruleBase = this.loadRuleBase(reader);
        StatefulSession wm = ruleBase.newStatefulSession();
        ArrayList results = new ArrayList();
        wm.setGlobal("results", results);
        Cheese[] cheese = new Cheese[]{new Cheese("stilton", 10), new Cheese("stilton", 2), new Cheese("stilton", 5), new Cheese("brie", 15), new Cheese("brie", 16), new Cheese("provolone", 8)};
        FactHandle[] cheeseHandles = new FactHandle[cheese.length];
        for (int i = 0; i < cheese.length; ++i) {
            cheeseHandles[i] = wm.insert((Object)cheese[i]);
        }
        int fireCount = 0;
        wm.fireAllRules();
        Assert.assertEquals((int)(++fireCount), (int)results.size());
        Assert.assertEquals((int)3, (int)((Collection)results.get(fireCount - 1)).size());
        Assert.assertEquals((String)ArrayList.class.getName(), (String)results.get(fireCount - 1).getClass().getName());
        boolean index = true;
        cheese[1].setType("brie");
        wm.update(cheeseHandles[1], (Object)cheese[1]);
        wm.fireAllRules();
        Assert.assertEquals((int)(++fireCount), (int)results.size());
        Assert.assertEquals((int)2, (int)((Collection)results.get(fireCount - 1)).size());
        Assert.assertEquals((String)ArrayList.class.getName(), (String)results.get(fireCount - 1).getClass().getName());
        wm.retract(cheeseHandles[2]);
        wm.fireAllRules();
        Assert.assertEquals((int)(++fireCount), (int)results.size());
        Assert.assertEquals((int)1, (int)((Collection)results.get(fireCount - 1)).size());
        Assert.assertEquals((String)ArrayList.class.getName(), (String)results.get(fireCount - 1).getClass().getName());
    }

    private RuleBase loadRuleBase(Reader reader) throws IOException, DroolsParserException, Exception {
        DrlParser parser = new DrlParser();
        PackageDescr packageDescr = parser.parse(reader);
        if (parser.hasErrors()) {
            System.out.println(parser.getErrors());
            Assert.fail((String)"Error messages in parser, need to sort this our (or else collect error messages)");
        }
        PackageBuilder builder = new PackageBuilder();
        builder.addPackage(packageDescr);
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        return ruleBase;
    }

    public void testForallSinglePattern() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_ForallSinglePattern.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("results", list);
        workingMemory.fireAllRules();
        FirstOrderLogicTest.assertEquals((int)1, (int)list.size());
        FactHandle stilton1 = workingMemory.insert((Object)new Cheese("stilton", 10));
        workingMemory.fireAllRules();
        FirstOrderLogicTest.assertEquals((int)1, (int)list.size());
        FactHandle stilton2 = workingMemory.insert((Object)new Cheese("stilton", 11));
        workingMemory.fireAllRules();
        FirstOrderLogicTest.assertEquals((int)1, (int)list.size());
        FactHandle brie = workingMemory.insert((Object)new Cheese("brie", 10));
        workingMemory.fireAllRules();
        FirstOrderLogicTest.assertEquals((int)1, (int)list.size());
        workingMemory.retract(stilton1);
        workingMemory.fireAllRules();
        FirstOrderLogicTest.assertEquals((int)1, (int)list.size());
        workingMemory.retract(brie);
        workingMemory.fireAllRules();
        FirstOrderLogicTest.assertEquals((int)2, (int)list.size());
    }

    public void testMVELCollect() throws Exception {
        InputStreamReader reader = new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_MVELCollect.drl"));
        RuleBase ruleBase = this.loadRuleBase(reader);
        StatefulSession wm = ruleBase.newStatefulSession();
        ArrayList results = new ArrayList();
        wm.setGlobal("results", results);
        wm.insert((Object)new Cheese("stilton", 10));
        wm.insert((Object)new Cheese("stilton", 7));
        wm.insert((Object)new Cheese("stilton", 8));
        wm.insert((Object)new Cheese("brie", 5));
        wm.insert((Object)new Cheese("provolone", 150));
        wm.insert((Object)new Cheese("provolone", 20));
        wm.insert((Object)new Person("Bob", "stilton"));
        wm.insert((Object)new Person("Mark", "provolone"));
        wm.fireAllRules();
        Assert.assertEquals((int)1, (int)results.size());
        Assert.assertEquals((int)6, (int)((List)results.get(0)).size());
    }

    public void testNestedCorelatedRulesWithForall() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(FirstOrderLogicTest.class.getResourceAsStream("test_NestedCorrelatedRulesWithForall.drl")));
        RuleBase rb = RuleBaseFactory.newRuleBase();
        rb.addPackage(builder.getPackage());
        StatefulSession session = rb.newStatefulSession();
        ArrayList list1 = new ArrayList();
        ArrayList list2 = new ArrayList();
        ArrayList list3 = new ArrayList();
        ArrayList list4 = new ArrayList();
        session.setGlobal("list1", list1);
        session.setGlobal("list2", list2);
        session.setGlobal("list3", list3);
        session.setGlobal("list4", list4);
        SpecialString first42 = new SpecialString("42");
        SpecialString second42 = new SpecialString("42");
        SpecialString world = new SpecialString("World");
        session.insert((Object)world);
        session.insert((Object)first42);
        session.insert((Object)second42);
        FirstOrderLogicTest.assertTrue((boolean)list1.isEmpty());
        FirstOrderLogicTest.assertTrue((boolean)list2.isEmpty());
        FirstOrderLogicTest.assertTrue((boolean)list3.isEmpty());
        FirstOrderLogicTest.assertTrue((boolean)list4.isEmpty());
        session.fireAllRules();
        FirstOrderLogicTest.assertEquals((int)0, (int)list1.size());
        FirstOrderLogicTest.assertEquals((int)0, (int)list2.size());
        FirstOrderLogicTest.assertEquals((int)1, (int)list3.size());
        FirstOrderLogicTest.assertEquals((int)0, (int)list4.size());
    }

    public void testFromInsideNotAndExists() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_FromInsideNotAndExists.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("results", list);
        Cheese cheddar = new Cheese("cheddar", 7);
        Cheese provolone = new Cheese("provolone", 5);
        Cheesery cheesery = new Cheesery();
        cheesery.addCheese(cheddar);
        cheesery.addCheese(provolone);
        FactHandle handle = workingMemory.insert((Object)cheesery);
        workingMemory.fireAllRules();
        FirstOrderLogicTest.assertEquals((int)0, (int)list.size());
        cheesery.addCheese(new Cheese("stilton", 10));
        cheesery.removeCheese(cheddar);
        workingMemory.update(handle, (Object)cheesery);
        workingMemory.fireAllRules();
        FirstOrderLogicTest.assertEquals((int)2, (int)list.size());
    }

    public void testOr() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_OrNesting.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("results", list);
        Cheese cheddar = new Cheese("cheddar", 7);
        Cheese provolone = new Cheese("provolone", 5);
        Cheese brie = new Cheese("brie", 15);
        Person mark = new Person("mark", "stilton");
        FactHandle ch = workingMemory.insert((Object)cheddar);
        FactHandle ph = workingMemory.insert((Object)provolone);
        FactHandle bh = workingMemory.insert((Object)brie);
        FactHandle markh = workingMemory.insert((Object)mark);
        workingMemory.fireAllRules();
        FirstOrderLogicTest.assertEquals((int)1, (int)list.size());
    }

    public void testCollectWithMemberOfOperators() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_CollectMemberOfOperator.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("results", list);
        Order order1 = new Order(1, "bob");
        OrderItem item11 = new OrderItem(order1, 1);
        OrderItem item12 = new OrderItem(order1, 2);
        Order order2 = new Order(2, "mark");
        OrderItem item21 = new OrderItem(order2, 1);
        OrderItem item22 = new OrderItem(order2, 2);
        workingMemory.insert((Object)order1);
        workingMemory.insert((Object)item11);
        workingMemory.insert((Object)item12);
        workingMemory.insert((Object)order2);
        workingMemory.insert((Object)item21);
        workingMemory.insert((Object)item22);
        workingMemory.fireAllRules();
        int index = 0;
        FirstOrderLogicTest.assertEquals((int)8, (int)list.size());
        FirstOrderLogicTest.assertSame((Object)order1, list.get(index++));
        FirstOrderLogicTest.assertSame((Object)item11, list.get(index++));
        FirstOrderLogicTest.assertSame((Object)order2, list.get(index++));
        FirstOrderLogicTest.assertSame((Object)item21, list.get(index++));
        FirstOrderLogicTest.assertSame((Object)order1, list.get(index++));
        FirstOrderLogicTest.assertSame((Object)item11, list.get(index++));
        FirstOrderLogicTest.assertSame((Object)order2, list.get(index++));
        FirstOrderLogicTest.assertSame((Object)item21, list.get(index++));
    }

    public void testCollectWithContainsOperators() throws Exception {
        PackageBuilder builder = new PackageBuilder();
        builder.addPackageFromDrl((Reader)new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream("test_CollectContainsOperator.drl")));
        Package pkg = builder.getPackage();
        RuleBase ruleBase = this.getRuleBase();
        ruleBase.addPackage(pkg);
        StatefulSession workingMemory = ruleBase.newStatefulSession();
        ArrayList list = new ArrayList();
        workingMemory.setGlobal("results", list);
        Order order1 = new Order(1, "bob");
        OrderItem item11 = new OrderItem(order1, 1);
        OrderItem item12 = new OrderItem(order1, 2);
        Order order2 = new Order(2, "mark");
        OrderItem item21 = new OrderItem(order2, 1);
        OrderItem item22 = new OrderItem(order2, 2);
        workingMemory.insert((Object)order1);
        workingMemory.insert((Object)item11);
        workingMemory.insert((Object)item12);
        workingMemory.insert((Object)order2);
        workingMemory.insert((Object)item21);
        workingMemory.insert((Object)item22);
        workingMemory.fireAllRules();
        int index = 0;
        FirstOrderLogicTest.assertEquals((int)8, (int)list.size());
        FirstOrderLogicTest.assertSame((Object)order1, list.get(index++));
        FirstOrderLogicTest.assertSame((Object)item11, list.get(index++));
        FirstOrderLogicTest.assertSame((Object)order2, list.get(index++));
        FirstOrderLogicTest.assertSame((Object)item21, list.get(index++));
        FirstOrderLogicTest.assertSame((Object)order1, list.get(index++));
        FirstOrderLogicTest.assertSame((Object)item11, list.get(index++));
        FirstOrderLogicTest.assertSame((Object)order2, list.get(index++));
        FirstOrderLogicTest.assertSame((Object)item21, list.get(index++));
    }
}

